/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.utilities;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class TSVToCSVConverter {
    public static void main(String[] args) throws IOException {
        BufferedWriter outputFile;
        Stream<String> lines;
        if (args.length != 2) {
            throw new JMetalException("Wrong number of arguments: two file names are required.");
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        try {
            lines = Files.lines(Paths.get(inputFileName, new String[0]), Charset.defaultCharset());
            outputFile = Files.newBufferedWriter(Paths.get(outputFileName, new String[0]), new OpenOption[0]);
            lines.forEach(line -> {
                String values = line.replaceAll("\\s+", ",");
                if (values.endsWith(",")) {
                    values = values.substring(0, values.length() - 1);
                }
                try {
                    outputFile.write(values);
                    outputFile.write("\n");
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            });
        }
        catch (IOException e2) {
            throw new JMetalException(e2);
        }
        lines.close();
        outputFile.close();
    }
}

