/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.domtree;

import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.domtree.Node;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;
import ru.ifmo.nds.util.DominanceHelper;

public final class PresortDelayed
extends NonDominatedSorting {
    private Node[] nodes;
    private Node[] rankMergeArray;
    private final boolean useRecursiveMerge;
    private double[][] points;
    private int[] ranks;

    public PresortDelayed(int n, int n2, boolean bl) {
        super(n, n2);
        this.nodes = new Node[n];
        this.rankMergeArray = new Node[n];
        this.useRecursiveMerge = bl;
        for (int i = 0; i < n; ++i) {
            this.nodes[i] = new Node(i);
        }
        this.points = new double[n][];
        this.ranks = new int[n];
    }

    @Override
    protected void closeImpl() {
        this.nodes = null;
        this.rankMergeArray = null;
        this.points = null;
        this.ranks = null;
    }

    @Override
    public String getName() {
        return "Dominance Tree (presort, " + (this.useRecursiveMerge ? "recursive merge, " : "sequential merge, ") + "delayed insertion)";
    }

    private static Node mergeHelperDelayed(Node node, Node node2) {
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        double[] dArray = node.point;
        int n = dArray.length - 1;
        Node node6 = null;
        while (node2 != null) {
            if (DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(dArray, node2.point, n)) {
                if (node5 != null) {
                    node5.next = node2;
                } else {
                    node4 = node2;
                }
                node5 = node2;
                node2 = node2.next;
                node5.next = null;
                if (node6 == null) continue;
                node6.next = node2;
                continue;
            }
            node6 = node2;
            node2 = node2.next;
            if (node3 != null) continue;
            node3 = node6;
        }
        if (node4 != null) {
            node.child = PresortDelayed.merge(node.child, node4);
        }
        return node3;
    }

    private static Node merge(Node node, Node node2) {
        if (node == null) {
            return node2;
        }
        assert (node2 != null);
        Node node3 = null;
        Node node4 = null;
        while (node != null && node2 != null) {
            Node node5;
            if (node.index < node2.index) {
                node2 = PresortDelayed.mergeHelperDelayed(node, node2);
                node5 = node;
                node = node.next;
                node5.next = null;
                if (node4 != null) {
                    node4.next = node5;
                }
                node4 = node5;
            } else {
                node = PresortDelayed.mergeHelperDelayed(node2, node);
                node5 = node2;
                node2 = node2.next;
                node5.next = null;
                if (node4 != null) {
                    node4.next = node5;
                }
                node4 = node5;
            }
            if (node3 != null) continue;
            node3 = node4;
        }
        node4.next = node != null ? node : node2;
        return node3;
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2 = dArray.length;
        ArrayHelper.fillIdentity(this.indices, n2);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n2, dArray[0].length);
        int n3 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
        for (int i = 0; i < n3; ++i) {
            Node.initialize(this.nodes[i], this.points[i]);
        }
        Node node = PresortDelayed.mergeAllRecursively(this.nodes, 0, n3);
        int n4 = 0;
        while (node != null) {
            int n5 = this.rankAndPutChildrenToMergeArray(node, this.ranks, n4);
            node = this.mergeAll(this.rankMergeArray, n5, this.useRecursiveMerge);
            ++n4;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            nArray[n4] = this.ranks[nArray[n4]];
            this.points[n4] = null;
        }
    }

    private int rankAndPutChildrenToMergeArray(Node node, int[] nArray, int n) {
        int n2 = 0;
        while (node != null) {
            nArray[node.index] = n;
            if (node.child != null) {
                this.rankMergeArray[n2] = node.child;
                ++n2;
            }
            node = node.next;
        }
        return n2;
    }

    private Node mergeAll(Node[] nodeArray, int n, boolean bl) {
        if (n == 0) {
            return null;
        }
        if (bl) {
            return PresortDelayed.mergeAllRecursively(nodeArray, 0, n);
        }
        Node node = nodeArray[0];
        for (int i = 1; i < n; ++i) {
            node = PresortDelayed.merge(node, nodeArray[i]);
        }
        return node;
    }

    private static Node mergeAllRecursively(Node[] nodeArray, int n, int n2) {
        if (n + 1 == n2) {
            return nodeArray[n];
        }
        int n3 = n + n2 >>> 1;
        return PresortDelayed.merge(PresortDelayed.mergeAllRecursively(nodeArray, n, n3), PresortDelayed.mergeAllRecursively(nodeArray, n3, n2));
    }
}

