/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.jfb.hybrid;

import ru.ifmo.nds.jfb.HybridAlgorithmWrapper;
import ru.ifmo.nds.jfb.JFBBase;

public final class LinearNDS
extends HybridAlgorithmWrapper {
    private static final int THRESHOLD_3D = 50;
    private static final int THRESHOLD_ALL = 100;
    private static final LinearNDS WRAPPER_INSTANCE = new LinearNDS();

    private LinearNDS() {
    }

    public static LinearNDS getWrapperInstance() {
        return WRAPPER_INSTANCE;
    }

    @Override
    public boolean supportsMultipleThreads() {
        return true;
    }

    @Override
    public String getName() {
        return "LinearNDS";
    }

    @Override
    public HybridAlgorithmWrapper.Instance create(int[] nArray, int[] nArray2, double[][] dArray, double[][] dArray2) {
        return new Instance(nArray, nArray2, dArray);
    }

    private static final class Instance
    extends HybridAlgorithmWrapper.Instance {
        private final int[] ranks;
        private final int[] indices;
        private final double[][] points;

        private Instance(int[] nArray, int[] nArray2, double[][] dArray) {
            this.ranks = nArray;
            this.indices = nArray2;
            this.points = dArray;
        }

        private boolean notHookCondition(int n, int n2) {
            switch (n2) {
                case 1: {
                    return true;
                }
                case 2: {
                    return n >= 50;
                }
            }
            return n >= 100;
        }

        @Override
        public int helperAHook(int n, int n2, int n3, int n4) {
            if (this.notHookCondition(n2 - n, n3)) {
                return -1;
            }
            for (int i = n; i < n2; ++i) {
                n2 = JFBBase.updateByPoint(this.ranks, this.indices, this.points, n4, this.indices[i], i + 1, n2, n3);
            }
            return n2;
        }

        @Override
        public int helperBHook(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            if (this.notHookCondition(n2 - n + n4 - n3, n5)) {
                return -1;
            }
            int n8 = n3;
            for (int i = n; i < n2; ++i) {
                int n9 = this.indices[i];
                while (n8 < n4 && this.indices[n8] < n9) {
                    ++n8;
                }
                n4 = JFBBase.updateByPoint(this.ranks, this.indices, this.points, n7, n9, n8, n4, n5);
            }
            return n4;
        }
    }
}

