/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.ndt;

import ru.ifmo.nds.ndt.Split;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.SplitMergeHelper;

public class SplitBuilder {
    private final double[] medianSwap;
    private final int[] indices;
    private final double[][] transposedPoints;
    private final int threshold;
    private final SplitMergeHelper splitMerge;
    private final Split[] splits;

    public SplitBuilder(double[][] dArray, int n, int n2) {
        this.transposedPoints = dArray;
        this.medianSwap = new double[n];
        this.indices = new int[n];
        this.splitMerge = new SplitMergeHelper(n);
        this.splits = new Split[n];
        for (int i = 0; i < n; ++i) {
            this.splits[i] = new Split();
        }
        this.threshold = n2;
    }

    private Split construct(int n, int n2, int n3, int n4, int[] nArray) {
        if (n + this.threshold < n2) {
            int n5 = n3 + 1 == nArray[0] ? 1 : n3 + 1;
            double d2 = ArrayHelper.transplantAndReturnMinIfNotSameElseNaN(this.transposedPoints[n3], this.indices, n, n2, this.medianSwap, n);
            if (Double.isNaN(d2)) {
                if (n4 == nArray[0]) {
                    return Split.NULL_MAX_DEPTH;
                }
                return this.construct(n, n2, n5, n4 + 1, nArray);
            }
            double d3 = ArrayHelper.destructiveMedian(this.medianSwap, n, n2);
            if (d2 == d3) {
                d3 = Math.nextUp(d3);
            }
            int n6 = this.splitMerge.splitInTwo(this.transposedPoints[n3], this.indices, n, n, n2, d3, false);
            Split split = this.splits[nArray[1]];
            nArray[1] = nArray[1] + 1;
            split.initialize(n3, d3, this.construct(n, n6, n5, 0, nArray), this.construct(n6, n2, n5, 0, nArray));
            return split;
        }
        return Split.NULL_POINTS;
    }

    public Split result(int n, int n2) {
        ArrayHelper.fillIdentity(this.indices, n);
        return this.construct(0, n, 1, 0, new int[]{n2, 0});
    }

    public Split result(int n, int n2, int[] nArray, int n3) {
        System.arraycopy(nArray, n, this.indices, n, n2 - n);
        return this.construct(n, n2, 1, 0, new int[]{n3, n});
    }
}

