/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util;

import ru.ifmo.nds.util.RankQueryStructureDouble;

public final class RedBlackRankQueryStructure
extends RankQueryStructureDouble {
    private final Node[] allNodes;

    public RedBlackRankQueryStructure(int n) {
        this.allNodes = new Node[n];
        for (int i = 0; i < n; ++i) {
            this.allNodes[i] = new Node();
            this.allNodes[i].index = i;
        }
    }

    @Override
    public String getName() {
        return "Red-Black Tree";
    }

    @Override
    public int maximumPoints() {
        return this.allNodes.length;
    }

    @Override
    public boolean supportsMultipleThreads() {
        return true;
    }

    @Override
    public RankQueryStructureDouble.RangeHandle createHandle(int n, int n2, int n3, int[] nArray, double[] dArray) {
        return new RangeHandleImpl(this.allNodes, n);
    }

    private static final class RangeHandleImpl
    extends RankQueryStructureDouble.RangeHandle {
        private final Node[] allNodes;
        private Node root = null;
        private int size = 0;
        private final int offset;

        private RangeHandleImpl(Node[] nodeArray, int n) {
            this.allNodes = nodeArray;
            this.offset = n;
        }

        @Override
        public RankQueryStructureDouble.RangeHandle put(double d2, int n) {
            Node node = RangeHandleImpl.minNodeAfterExactByValue(this.root, n);
            if (node == null || node.key > d2) {
                Node node2 = null;
                if (node == null) {
                    if (this.root != null) {
                        node = RangeHandleImpl.maxNodeNonNull(this.root);
                    }
                } else {
                    if (node.value == n) {
                        node2 = node;
                    }
                    node = RangeHandleImpl.predecessor(node);
                }
                while (node != null && node.key >= d2) {
                    Node node3 = RangeHandleImpl.predecessor(node);
                    this.delete(node);
                    node = node3;
                }
                if (node2 == null) {
                    this.insert(d2, n);
                } else {
                    node2.key = d2;
                }
            }
            return this;
        }

        @Override
        public int getMaximumWithKeyAtMost(double d2, int n) {
            Node node = RangeHandleImpl.maxNodeBeforeExact(this.root, d2);
            return node == null ? -1 : node.value;
        }

        private Node newNode(double d2, int n, Node node) {
            int n2 = this.offset + this.size;
            Node node2 = this.allNodes[n2];
            node2.key = d2;
            node2.value = n;
            node2.red = true;
            node2.left = null;
            node2.right = null;
            node2.parent = node;
            ++this.size;
            return node2;
        }

        private void deleteNode(Node node) {
            --this.size;
            int n = this.offset + this.size;
            if (node.index != n) {
                Node node2;
                this.allNodes[node.index] = node2 = this.allNodes[n];
                this.allNodes[n] = node;
                node2.index = node.index;
                node.index = n;
            }
        }

        private static boolean isRed(Node node) {
            return node != null && node.red;
        }

        private static boolean isBlack(Node node) {
            return node == null || !node.red;
        }

        private static Node minNodeNonNull(Node node) {
            Node node2;
            while ((node2 = node.left) != null) {
                node = node2;
            }
            return node;
        }

        private static Node maxNodeNonNull(Node node) {
            Node node2;
            while ((node2 = node.right) != null) {
                node = node2;
            }
            return node;
        }

        private static Node maxNodeBeforeExact(Node node, double d2) {
            Node node2;
            double d3;
            if (node == null) {
                return null;
            }
            Node node3 = node;
            do {
                if (d2 == (d3 = node3.key)) {
                    return node3;
                }
                node2 = node3;
            } while ((node3 = d2 < d3 ? node3.left : node3.right) != null);
            return d2 > d3 ? node2 : RangeHandleImpl.predecessor(node2);
        }

        private static Node minNodeAfterExactByValue(Node node, int n) {
            Node node2;
            int n2;
            if (node == null) {
                return null;
            }
            Node node3 = node;
            do {
                if (n == (n2 = node3.value)) {
                    return node3;
                }
                node2 = node3;
            } while ((node3 = n < n2 ? node3.left : node3.right) != null);
            return n < n2 ? node2 : RangeHandleImpl.successor(node2);
        }

        private void insert(double d2, int n) {
            if (this.root == null) {
                this.root = this.newNode(d2, n, null);
                this.root.red = false;
            } else {
                Node node;
                boolean bl;
                Node node2 = this.root;
                do {
                    node = node2;
                } while ((node2 = (bl = n < node2.value) ? node2.left : node2.right) != null);
                Node node3 = this.newNode(d2, n, node);
                if (bl) {
                    node.left = node3;
                } else {
                    node.right = node3;
                }
                this.root = RangeHandleImpl.fixAfterInsert(this.root, node3);
            }
        }

        private static Node fixAfterInsert(Node node, Node node2) {
            Node node3;
            Node node4 = node2;
            while (RangeHandleImpl.isRed(node3 = node4.parent)) {
                Node node5;
                Node node6 = node3.parent;
                if (node3 == node6.left) {
                    node5 = node6.right;
                    if (RangeHandleImpl.isRed(node5)) {
                        node3.red = false;
                        node5.red = false;
                        node6.red = true;
                        node4 = node6;
                        continue;
                    }
                    if (node4 == node3.right) {
                        node4 = node3;
                        node = RangeHandleImpl.rotateLeft(node, node4);
                        node3 = node4.parent;
                        node6 = node3.parent;
                    }
                    node3.red = false;
                    node6.red = true;
                    node = RangeHandleImpl.rotateRight(node, node6);
                    continue;
                }
                node5 = node6.left;
                if (RangeHandleImpl.isRed(node5)) {
                    node3.red = false;
                    node5.red = false;
                    node6.red = true;
                    node4 = node6;
                    continue;
                }
                if (node4 == node3.left) {
                    node4 = node3;
                    node = RangeHandleImpl.rotateRight(node, node4);
                    node3 = node4.parent;
                    node6 = node3.parent;
                }
                node3.red = false;
                node6.red = true;
                node = RangeHandleImpl.rotateLeft(node, node6);
            }
            node.red = false;
            return node;
        }

        private void delete(Node node) {
            if (node != null) {
                Node node2;
                Node node3;
                Node node4 = node;
                boolean bl = node4.red;
                if (node.left == null) {
                    node3 = node.right;
                    this.root = RangeHandleImpl.transplant(this.root, node, node.right);
                    node2 = node.parent;
                } else if (node.right == null) {
                    node3 = node.left;
                    this.root = RangeHandleImpl.transplantNonNull(this.root, node, node.left);
                    node2 = node.parent;
                } else {
                    node4 = RangeHandleImpl.minNodeNonNull(node.right);
                    bl = node4.red;
                    node3 = node4.right;
                    if (node4.parent == node) {
                        node2 = node4;
                    } else {
                        node2 = node4.parent;
                        this.root = RangeHandleImpl.transplant(this.root, node4, node3);
                        node4.right = node.right;
                        node4.right.parent = node4;
                    }
                    this.root = RangeHandleImpl.transplantNonNull(this.root, node, node4);
                    node4.left = node.left;
                    node4.left.parent = node4;
                    node4.red = node.red;
                }
                if (!bl) {
                    this.root = RangeHandleImpl.fixAfterDelete(this.root, node3, node2);
                }
                this.deleteNode(node);
            }
        }

        private static Node fixAfterDelete(Node node, Node node2, Node node3) {
            Node node4 = node2;
            Node node5 = node3;
            while (node4 != node && RangeHandleImpl.isBlack(node4)) {
                Node node6;
                if (node4 == node5.left) {
                    node6 = node5.right;
                    if (node6.red) {
                        node6.red = false;
                        node5.red = true;
                        node = RangeHandleImpl.rotateLeft(node, node5);
                        node6 = node5.right;
                    }
                    if (RangeHandleImpl.isBlack(node6.left) && RangeHandleImpl.isBlack(node6.right)) {
                        node6.red = true;
                        node4 = node5;
                    } else {
                        if (RangeHandleImpl.isBlack(node6.right)) {
                            node6.left.red = false;
                            node6.red = true;
                            node = RangeHandleImpl.rotateRight(node, node6);
                            node6 = node5.right;
                        }
                        node6.red = node5.red;
                        node5.red = false;
                        node6.right.red = false;
                        node4 = node = RangeHandleImpl.rotateLeft(node, node5);
                    }
                } else {
                    node6 = node5.left;
                    if (node6.red) {
                        node6.red = false;
                        node5.red = true;
                        node = RangeHandleImpl.rotateRight(node, node5);
                        node6 = node5.left;
                    }
                    if (RangeHandleImpl.isBlack(node6.left) && RangeHandleImpl.isBlack(node6.right)) {
                        node6.red = true;
                        node4 = node5;
                    } else {
                        if (RangeHandleImpl.isBlack(node6.left)) {
                            node6.right.red = false;
                            node6.red = true;
                            node = RangeHandleImpl.rotateLeft(node, node6);
                            node6 = node5.left;
                        }
                        node6.red = node5.red;
                        node5.red = false;
                        node6.left.red = false;
                        node4 = node = RangeHandleImpl.rotateRight(node, node5);
                    }
                }
                node5 = node4.parent;
            }
            if (node4 != null) {
                node4.red = false;
            }
            return node;
        }

        private static Node successor(Node node) {
            if (node.right != null) {
                return RangeHandleImpl.minNodeNonNull(node.right);
            }
            Node node2 = node;
            Node node3 = node2.parent;
            while (node3 != null && node2 == node3.right) {
                node2 = node3;
                node3 = node3.parent;
            }
            return node3;
        }

        private static Node predecessor(Node node) {
            if (node.left != null) {
                return RangeHandleImpl.maxNodeNonNull(node.left);
            }
            Node node2 = node;
            Node node3 = node2.parent;
            while (node3 != null && node2 == node3.left) {
                node2 = node3;
                node3 = node3.parent;
            }
            return node3;
        }

        private static Node rotateLeft(Node node, Node node2) {
            if (node2 != null) {
                Node node3;
                Node node4 = node2.right;
                node2.right = node3 = node4.left;
                if (node3 != null) {
                    node3.parent = node2;
                }
                node = RangeHandleImpl.transplantNonNull(node, node2, node4);
                node4.left = node2;
                node2.parent = node4;
            }
            return node;
        }

        private static Node rotateRight(Node node, Node node2) {
            if (node2 != null) {
                Node node3;
                Node node4 = node2.left;
                node2.left = node3 = node4.right;
                if (node3 != null) {
                    node3.parent = node2;
                }
                node = RangeHandleImpl.transplantNonNull(node, node2, node4);
                node4.right = node2;
                node2.parent = node4;
            }
            return node;
        }

        private static Node transplant(Node node, Node node2, Node node3) {
            return node3 == null ? RangeHandleImpl.transplantNull(node, node2) : RangeHandleImpl.transplantNonNull(node, node2, node3);
        }

        private static Node transplantNull(Node node, Node node2) {
            Node node3 = node2.parent;
            if (node3 == null) {
                return null;
            }
            if (node2 == node3.left) {
                node3.left = null;
            } else {
                node3.right = null;
            }
            return node;
        }

        private static Node transplantNonNull(Node node, Node node2, Node node3) {
            Node node4;
            node3.parent = node4 = node2.parent;
            if (node4 == null) {
                return node3;
            }
            if (node2 == node4.left) {
                node4.left = node3;
            } else {
                node4.right = node3;
            }
            return node;
        }
    }

    private static class Node {
        double key;
        int value;
        int index;
        boolean red;
        Node left;
        Node right;
        Node parent;

        private Node() {
        }
    }
}

