/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util;

import java.util.Arrays;

public final class SplitMergeHelper {
    private final int[] scratchM;
    private final int[] scratchR;

    public SplitMergeHelper(int n) {
        this.scratchM = new int[n];
        this.scratchR = new int[n];
    }

    public final int splitInTwo(double[] dArray, int[] nArray, int n, int n2, int n3, double d2, boolean bl) {
        int n4 = n2;
        int n5 = n;
        for (int i = n2; i < n3; ++i) {
            int n6 = nArray[i];
            double d3 = dArray[n6];
            if (d3 < d2 || bl && d3 == d2) {
                nArray[n4] = n6;
                ++n4;
                continue;
            }
            this.scratchR[n5] = n6;
            ++n5;
        }
        System.arraycopy(this.scratchR, n, nArray, n4, n5 - n);
        return n4;
    }

    public final long splitInThree(double[] dArray, int[] nArray, int n, int n2, int n3, double d2) {
        int n4 = n2;
        int n5 = n;
        int n6 = n;
        for (int i = n2; i < n3; ++i) {
            int n7 = nArray[i];
            double d3 = dArray[n7];
            if (d3 < d2) {
                nArray[n4] = n7;
                ++n4;
                continue;
            }
            if (d3 == d2) {
                this.scratchM[n5] = n7;
                ++n5;
                continue;
            }
            this.scratchR[n6] = n7;
            ++n6;
        }
        System.arraycopy(this.scratchM, n, nArray, n4, n5 -= n);
        System.arraycopy(this.scratchR, n, nArray, n5 += n4, n6 - n);
        return SplitMergeHelper.pack(n4, n5);
    }

    public final int mergeThree(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n4 != n5) {
            n3 = this.mergeTwo(nArray, n, n2, n3, n4, n5);
        }
        return this.mergeTwo(nArray, n, n2, n3, n6, n7);
    }

    private int mergeTwo(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n4 == n5) {
            return n3;
        }
        n2 = -Arrays.binarySearch(nArray, n2, n3, nArray[n4]) - 1;
        int n7 = n;
        int n8 = n2;
        int n9 = n4;
        if (n8 < n3 && n9 < n5) {
            n6 = nArray[n8];
            int n10 = nArray[n9];
            while (true) {
                if (n6 <= n10) {
                    this.scratchM[n7] = n6;
                    ++n7;
                    if (++n8 == n3) break;
                    n6 = nArray[n8];
                    continue;
                }
                this.scratchM[n7] = n10;
                ++n7;
                if (++n9 == n5) break;
                n10 = nArray[n9];
            }
        }
        if (n9 != (n6 = n2 + (n7 - n) + n3 - n8) && n5 > n9) {
            System.arraycopy(nArray, n9, nArray, n6, n5 - n9);
        }
        if (n6 != n3 && n3 > n8) {
            System.arraycopy(nArray, n8, nArray, n2 + (n7 - n), n3 - n8);
        }
        if (n7 > n) {
            System.arraycopy(this.scratchM, n, nArray, n2, n7 - n);
        }
        return n6 + n5 - n9;
    }

    private static long pack(int n, int n2) {
        return (long)n << 32 ^ (long)n2;
    }

    public static int extractMid(long l) {
        return (int)(l >>> 32);
    }

    public static int extractRight(long l) {
        return (int)l;
    }
}

