/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util.veb;

import ru.ifmo.nds.util.veb.AnyAnyBitSet;
import ru.ifmo.nds.util.veb.IntBitSet;
import ru.ifmo.nds.util.veb.IntIntBitSet;
import ru.ifmo.nds.util.veb.IntLongBitSet;
import ru.ifmo.nds.util.veb.LongAnyBitSet;
import ru.ifmo.nds.util.veb.LongBitSet;
import ru.ifmo.nds.util.veb.LongLongBitSet;

public abstract class VanEmdeBoasSet {
    public abstract boolean isEmpty();

    public abstract int min();

    public abstract int max();

    public abstract int prev(int var1);

    public abstract int next(int var1);

    public abstract void add(int var1);

    public abstract void remove(int var1);

    public abstract void clear();

    public abstract int prevInclusively(int var1);

    public abstract void setEnsuringMonotonicity(int var1, int var2, int var3, int[] var4);

    abstract void cleanupUpwards(int var1, int var2, int[] var3);

    public static VanEmdeBoasSet create(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new IntBitSet();
            }
            case 6: {
                return new LongBitSet();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return new IntIntBitSet(n);
            }
            case 11: {
                return new IntLongBitSet();
            }
            case 12: {
                return new LongLongBitSet();
            }
            case 13: {
                return new LongAnyBitSet();
            }
        }
        return new AnyAnyBitSet(n);
    }

    static int min(int n) {
        return Integer.numberOfTrailingZeros(n);
    }

    static int max(int n) {
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    static int prev(int n, int n2) {
        int n3 = n & ~(-1 << n2);
        return 31 - Integer.numberOfLeadingZeros(n3);
    }

    static int prevInclusively(int n, int n2) {
        int n3 = n & ~(-2 << n2);
        return 31 - Integer.numberOfLeadingZeros(n3);
    }

    static int next(int n, int n2) {
        int n3 = n & -1 << n2 << 1;
        return Integer.numberOfTrailingZeros(n3);
    }

    static int min(long l) {
        return Long.numberOfTrailingZeros(l);
    }

    static int max(long l) {
        return 63 - Long.numberOfLeadingZeros(l);
    }

    static int prev(long l, int n) {
        long l2 = l & (-1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        return 63 - Long.numberOfLeadingZeros(l2);
    }

    static int prevInclusively(long l, int n) {
        long l2 = l & (-2L << n ^ 0xFFFFFFFFFFFFFFFFL);
        return 63 - Long.numberOfLeadingZeros(l2);
    }

    static int next(long l, int n) {
        long l2 = l & -1L << n << 1;
        return Long.numberOfTrailingZeros(l2);
    }

    static int setEnsuringMonotonicity(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        int n6;
        int n7 = -1 << n2 << 1;
        int n8 = n & ~n7;
        if (n8 != 0 && nArray[n3 + 31 - Integer.numberOfLeadingZeros(n8)] >= n4) {
            return n;
        }
        nArray[n3 + n2] = n4;
        n |= 1 << n2;
        while ((n6 = n & n7) != 0 && nArray[n3 + (n5 = Integer.numberOfTrailingZeros(n6))] <= n4) {
            n ^= 1 << n5;
        }
        return n;
    }

    static long setEnsuringMonotonicity(long l, int n, int n2, int n3, int[] nArray) {
        int n4;
        long l2;
        long l3 = -1L << n << 1;
        long l4 = l & (l3 ^ 0xFFFFFFFFFFFFFFFFL);
        if (l4 != 0L && nArray[n2 + 63 - Long.numberOfLeadingZeros(l4)] >= n3) {
            return l;
        }
        nArray[n2 + n] = n3;
        l |= 1L << n;
        while ((l2 = l & l3) != 0L && nArray[n2 + (n4 = Long.numberOfTrailingZeros(l2))] <= n3) {
            l ^= 1L << n4;
        }
        return l;
    }

    static int cleanupUpwards(int n, int n2, int n3, int[] nArray) {
        int n4 = VanEmdeBoasSet.max(n);
        if (nArray[n2 + n4] <= n3) {
            return 0;
        }
        if (n != 1 << n4) {
            int n5 = VanEmdeBoasSet.min(n);
            while (n5 < n4 && nArray[n2 + n5] <= n3) {
                n5 = VanEmdeBoasSet.next(n ^= 1 << n5, n5);
            }
        }
        return n;
    }

    static long cleanupUpwards(long l, int n, int n2, int[] nArray) {
        int n3 = VanEmdeBoasSet.max(l);
        if (nArray[n + n3] <= n2) {
            return 0L;
        }
        if (l != 1L << n3) {
            int n4 = VanEmdeBoasSet.min(l);
            while (n4 < n3 && nArray[n + n4] <= n2) {
                n4 = VanEmdeBoasSet.next(l ^= 1L << n4, n4);
            }
        }
        return l;
    }
}

