/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.output.prediction;

import weka.classifiers.Classifier;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.core.Instance;
import weka.core.Utils;

public class PlainText
extends AbstractOutput {
    private static final long serialVersionUID = 2033389864898242735L;

    @Override
    public String globalInfo() {
        return "Outputs the predictions in plain text.";
    }

    @Override
    public String getDisplay() {
        return "Plain text";
    }

    @Override
    protected void doPrintHeader() {
        if (this.m_Header.classAttribute().isNominal()) {
            if (this.m_OutputDistribution) {
                this.append("    inst#     actual  predicted error distribution");
            } else {
                this.append("    inst#     actual  predicted error prediction");
            }
        } else {
            this.append("    inst#     actual  predicted      error");
        }
        if (this.m_Attributes != null) {
            this.append(" (");
            boolean first = true;
            for (int i = 0; i < this.m_Header.numAttributes(); ++i) {
                if (i == this.m_Header.classIndex() || !this.m_Attributes.isInRange(i)) continue;
                if (!first) {
                    this.append(",");
                }
                this.append(this.m_Header.attribute(i).name());
                first = false;
            }
            this.append(")");
        }
        this.append("\n");
    }

    protected String attributeValuesString(Instance instance) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attributes != null) {
            boolean firstOutput = true;
            this.m_Attributes.setUpper(instance.numAttributes() - 1);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!this.m_Attributes.isInRange(i) || i == instance.classIndex()) continue;
                if (firstOutput) {
                    text.append("(");
                } else {
                    text.append(",");
                }
                text.append(instance.toString(i));
                firstOutput = false;
            }
            if (!firstOutput) {
                text.append(")");
            }
        }
        return text.toString();
    }

    @Override
    protected void doPrintClassification(double[] dist, Instance inst, int index) throws Exception {
        int width = 7 + this.m_NumDecimals;
        int prec = this.m_NumDecimals;
        Instance withMissing = (Instance)inst.copy();
        withMissing.setDataset(inst.dataset());
        double predValue = 0.0;
        predValue = Utils.sum(dist) == 0.0 ? Utils.missingValue() : (inst.classAttribute().isNominal() ? (double)Utils.maxIndex(dist) : dist[0]);
        this.append(Utils.padLeftAndAllowOverflow("" + (index + 1), 9));
        if (inst.dataset().classAttribute().isNumeric()) {
            if (inst.classIsMissing()) {
                this.append(" " + Utils.padLeft("?", width));
            } else {
                this.append(" " + Utils.doubleToString(inst.classValue(), width, prec));
            }
            if (Utils.isMissingValue(predValue)) {
                this.append(" " + Utils.padLeft("?", width));
            } else {
                this.append(" " + Utils.doubleToString(predValue, width, prec));
            }
            if (Utils.isMissingValue(predValue) || inst.classIsMissing()) {
                this.append(" " + Utils.padLeft("?", width));
            } else {
                this.append(" " + Utils.doubleToString(predValue - inst.classValue(), width, prec));
            }
        } else {
            this.append(" " + Utils.padLeftAndAllowOverflow((int)inst.classValue() + 1 + ":" + inst.toString(inst.classIndex()), width));
            if (Utils.isMissingValue(predValue)) {
                this.append(" " + Utils.padLeft("?", width));
            } else {
                this.append(" " + Utils.padLeftAndAllowOverflow((int)predValue + 1 + ":" + inst.dataset().classAttribute().value((int)predValue), width));
            }
            if (!Utils.isMissingValue(predValue) && !inst.classIsMissing() && (int)predValue + 1 != (int)inst.classValue() + 1) {
                this.append("   +  ");
            } else {
                this.append("      ");
            }
            if (this.m_OutputDistribution) {
                if (Utils.isMissingValue(predValue)) {
                    this.append(" ?");
                } else {
                    this.append(" ");
                    for (int n = 0; n < dist.length; ++n) {
                        if (n > 0) {
                            this.append(",");
                        }
                        if (n == (int)predValue) {
                            this.append("*");
                        }
                        this.append(Utils.doubleToString(dist[n], prec));
                    }
                }
            } else if (Utils.isMissingValue(predValue)) {
                this.append(" ?");
            } else {
                this.append(" " + Utils.doubleToString(dist[(int)predValue], prec));
            }
        }
        this.append(" " + this.attributeValuesString(withMissing) + "\n");
    }

    @Override
    protected void doPrintClassification(Classifier classifier, Instance inst, int index) throws Exception {
        double[] d2 = classifier.distributionForInstance(inst);
        this.doPrintClassification(d2, inst, index);
    }

    @Override
    protected void doPrintFooter() {
    }
}

