/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class DecisionTableHashKey
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 5674163500154964602L;
    private double[] attributes;
    private boolean[] missing;
    private int key;

    public DecisionTableHashKey(Instance t, int numAtts, boolean ignoreClass) throws Exception {
        int cindex = t.classIndex();
        this.key = -999;
        this.attributes = new double[numAtts];
        this.missing = new boolean[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            if (i == cindex && !ignoreClass) {
                this.missing[i] = true;
                continue;
            }
            this.missing[i] = t.isMissing(i);
            if (this.missing[i]) continue;
            this.attributes[i] = t.value(i);
        }
    }

    public String toString(Instances t, int maxColWidth) {
        int cindex = t.classIndex();
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == cindex) continue;
            if (this.missing[i]) {
                text.append("?");
                for (int j = 0; j < maxColWidth; ++j) {
                    text.append(" ");
                }
                continue;
            }
            String ss = t.attribute(i).value((int)this.attributes[i]);
            StringBuffer sb = new StringBuffer(ss);
            for (int j = 0; j < maxColWidth - ss.length() + 1; ++j) {
                sb.append(" ");
            }
            text.append(sb);
        }
        return text.toString();
    }

    public DecisionTableHashKey(double[] t) {
        int l = t.length;
        this.key = -999;
        this.attributes = new double[l];
        this.missing = new boolean[l];
        for (int i = 0; i < l; ++i) {
            if (t[i] == Double.MAX_VALUE) {
                this.missing[i] = true;
                continue;
            }
            this.missing[i] = false;
            this.attributes[i] = t[i];
        }
    }

    public int hashCode() {
        int hv = 0;
        if (this.key != -999) {
            return this.key;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.missing[i]) {
                hv += i * 13;
                continue;
            }
            hv = (int)((double)hv + (double)(i * 5) * (this.attributes[i] + 1.0));
        }
        if (this.key == -999) {
            this.key = hv;
        }
        return hv;
    }

    public boolean equals(Object b2) {
        if (b2 == null || !b2.getClass().equals(this.getClass())) {
            return false;
        }
        boolean ok = true;
        if (b2 instanceof DecisionTableHashKey) {
            DecisionTableHashKey n = (DecisionTableHashKey)b2;
            for (int i = 0; i < this.attributes.length; ++i) {
                boolean l = n.missing[i];
                if (this.missing[i] || l) {
                    if ((!this.missing[i] || l) && (this.missing[i] || !l)) continue;
                    ok = false;
                } else {
                    if (this.attributes[i] == n.attributes[i]) continue;
                    ok = false;
                }
                break;
            }
        } else {
            return false;
        }
        return ok;
    }

    public void print_hash_code() {
        System.out.println("Hash val: " + this.hashCode());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

