/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import java.util.Map;
import weka.classifiers.trees.ht.LearningNode;
import weka.classifiers.trees.ht.NBNode;
import weka.classifiers.trees.ht.WeightMass;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class NBNodeAdaptive
extends NBNode
implements LearningNode,
Serializable {
    private static final long serialVersionUID = -4509802312019989686L;
    protected double m_majClassCorrectWeight = 0.0;
    protected double m_nbCorrectWeight = 0.0;

    public NBNodeAdaptive(Instances header, double nbWeightThreshold) throws Exception {
        super(header, nbWeightThreshold);
    }

    protected String majorityClass() {
        String mc = "";
        double max = -1.0;
        for (Map.Entry e2 : this.m_classDistribution.entrySet()) {
            if (!(((WeightMass)e2.getValue()).m_weight > max)) continue;
            max = ((WeightMass)e2.getValue()).m_weight;
            mc = (String)e2.getKey();
        }
        return mc;
    }

    @Override
    public void updateNode(Instance inst) throws Exception {
        String trueClass = inst.classAttribute().value((int)inst.classValue());
        int trueClassIndex = (int)inst.classValue();
        if (this.majorityClass().equals(trueClass)) {
            this.m_majClassCorrectWeight += inst.weight();
        }
        if (this.m_bayes.classifyInstance(inst) == (double)trueClassIndex) {
            this.m_nbCorrectWeight += inst.weight();
        }
        super.updateNode(inst);
    }

    @Override
    public double[] getDistribution(Instance inst, Attribute classAtt) throws Exception {
        if (this.m_majClassCorrectWeight > this.m_nbCorrectWeight) {
            return super.bypassNB(inst, classAtt);
        }
        return super.getDistribution(inst, classAtt);
    }

    @Override
    protected int dumpTree(int depth, int leafCount, StringBuffer buff) {
        leafCount = super.dumpTree(depth, leafCount, buff);
        buff.append(" NB adaptive" + this.m_leafNum);
        return leafCount;
    }

    @Override
    protected void printLeafModels(StringBuffer buff) {
        buff.append("NB adaptive" + this.m_leafNum).append("\n").append(this.m_bayes.toString());
    }
}

