/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class PreConstructedLinearModel
extends AbstractClassifier
implements Serializable {
    static final long serialVersionUID = 2030974097051713247L;
    private double[] m_coefficients;
    private double m_intercept;
    private Instances m_instancesHeader;
    private int m_numParameters;

    public PreConstructedLinearModel(double[] coeffs, double intercept) {
        this.m_coefficients = coeffs;
        this.m_intercept = intercept;
        int count = 0;
        for (int i = 0; i < coeffs.length; ++i) {
            if (coeffs[i] == 0.0) continue;
            ++count;
        }
        this.m_numParameters = count;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.m_instancesHeader = new Instances(instances, 0);
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        double result = 0.0;
        for (int i = 0; i < this.m_coefficients.length; ++i) {
            if (i == inst.classIndex() || inst.isMissing(i)) continue;
            result += this.m_coefficients[i] * inst.value(i);
        }
        return result += this.m_intercept;
    }

    public int numParameters() {
        return this.m_numParameters;
    }

    public double[] coefficients() {
        return this.m_coefficients;
    }

    public double intercept() {
        return this.m_intercept;
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer();
        b2.append("\n" + this.m_instancesHeader.classAttribute().name() + " = ");
        boolean first = true;
        for (int i = 0; i < this.m_coefficients.length; ++i) {
            if (this.m_coefficients[i] == 0.0) continue;
            double c2 = this.m_coefficients[i];
            if (first) {
                b2.append("\n\t" + Utils.doubleToString(c2, 12, this.getNumDecimalPlaces()).trim() + " * " + this.m_instancesHeader.attribute(i).name() + " ");
                first = false;
                continue;
            }
            b2.append("\n\t" + (this.m_coefficients[i] < 0.0 ? "- " + Utils.doubleToString(Math.abs(c2), 12, this.getNumDecimalPlaces()).trim() : "+ " + Utils.doubleToString(Math.abs(c2), 12, this.getNumDecimalPlaces()).trim()) + " * " + this.m_instancesHeader.attribute(i).name() + " ");
        }
        b2.append("\n\t" + (this.m_intercept < 0.0 ? "- " : "+ ") + Utils.doubleToString(Math.abs(this.m_intercept), 12, this.getNumDecimalPlaces()).trim());
        return b2.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15358 $");
    }
}

