/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import weka.core.Attribute;
import weka.core.ProtectedProperties;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class AttributeMetaInfo
implements Serializable,
RevisionHandler {
    protected ProtectedProperties m_Metadata;
    protected int m_Ordering;
    protected boolean m_IsRegular;
    protected boolean m_IsAveragable;
    protected boolean m_HasZeropoint;
    protected double m_LowerBound;
    protected boolean m_LowerBoundIsOpen;
    protected double m_UpperBound;
    protected boolean m_UpperBoundIsOpen;

    public AttributeMetaInfo(ProtectedProperties metadata, Attribute att) {
        this.setMetadata(metadata, att);
    }

    private void setMetadata(ProtectedProperties metadata, Attribute att) {
        this.m_Metadata = metadata;
        if (att.m_Type == 3) {
            this.m_Ordering = 1;
            this.m_IsRegular = true;
            this.m_IsAveragable = false;
            this.m_HasZeropoint = false;
        } else {
            String orderString = this.m_Metadata.getProperty("ordering", "");
            String def = att.m_Type == 0 && orderString.compareTo("modulo") != 0 && orderString.compareTo("symbolic") != 0 ? "true" : "false";
            this.m_IsAveragable = this.m_Metadata.getProperty("averageable", def).compareTo("true") == 0;
            boolean bl = this.m_HasZeropoint = this.m_Metadata.getProperty("zeropoint", def).compareTo("true") == 0;
            if (this.m_IsAveragable || this.m_HasZeropoint) {
                def = "true";
            }
            boolean bl2 = this.m_IsRegular = this.m_Metadata.getProperty("regular", def).compareTo("true") == 0;
            this.m_Ordering = orderString.compareTo("symbolic") == 0 ? 0 : (orderString.compareTo("ordered") == 0 ? 1 : (orderString.compareTo("modulo") == 0 ? 2 : (att.m_Type == 0 || this.m_IsAveragable || this.m_HasZeropoint ? 1 : 0)));
        }
        if (this.m_IsAveragable && !this.m_IsRegular) {
            throw new IllegalArgumentException("An averagable attribute must be regular");
        }
        if (this.m_HasZeropoint && !this.m_IsRegular) {
            throw new IllegalArgumentException("A zeropoint attribute must be regular");
        }
        if (this.m_IsRegular && this.m_Ordering == 0) {
            throw new IllegalArgumentException("A symbolic attribute cannot be regular");
        }
        if (this.m_IsAveragable && this.m_Ordering != 1) {
            throw new IllegalArgumentException("An averagable attribute must be ordered");
        }
        if (this.m_HasZeropoint && this.m_Ordering != 1) {
            throw new IllegalArgumentException("A zeropoint attribute must be ordered");
        }
        att.m_Weight = 1.0;
        String weightString = this.m_Metadata.getProperty("weight");
        if (weightString != null) {
            try {
                att.m_Weight = Double.valueOf(weightString);
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Not a valid attribute weight: '" + weightString + "'");
            }
        }
        if (att.m_Type == 0) {
            this.setNumericRange(this.m_Metadata.getProperty("range"));
        }
    }

    private void setNumericRange(String rangeString) {
        this.m_LowerBound = Double.NEGATIVE_INFINITY;
        this.m_LowerBoundIsOpen = false;
        this.m_UpperBound = Double.POSITIVE_INFINITY;
        this.m_UpperBoundIsOpen = false;
        if (rangeString == null) {
            return;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(rangeString));
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.ordinaryChar(91);
        tokenizer.ordinaryChar(40);
        tokenizer.ordinaryChar(44);
        tokenizer.ordinaryChar(93);
        tokenizer.ordinaryChar(41);
        try {
            tokenizer.nextToken();
            if (tokenizer.ttype == 91) {
                this.m_LowerBoundIsOpen = false;
            } else if (tokenizer.ttype == 40) {
                this.m_LowerBoundIsOpen = true;
            } else {
                throw new IllegalArgumentException("Expected opening brace on range, found: " + tokenizer.toString());
            }
            tokenizer.nextToken();
            if (tokenizer.ttype != -3) {
                throw new IllegalArgumentException("Expected lower bound in range, found: " + tokenizer.toString());
            }
            if (tokenizer.sval.compareToIgnoreCase("-inf") == 0) {
                this.m_LowerBound = Double.NEGATIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("+inf") == 0) {
                this.m_LowerBound = Double.POSITIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("inf") == 0) {
                this.m_LowerBound = Double.NEGATIVE_INFINITY;
            } else {
                try {
                    this.m_LowerBound = Double.valueOf(tokenizer.sval);
                }
                catch (NumberFormatException e2) {
                    throw new IllegalArgumentException("Expected lower bound in range, found: '" + tokenizer.sval + "'");
                }
            }
            if (tokenizer.nextToken() != 44) {
                throw new IllegalArgumentException("Expected comma in range, found: " + tokenizer.toString());
            }
            tokenizer.nextToken();
            if (tokenizer.ttype != -3) {
                throw new IllegalArgumentException("Expected upper bound in range, found: " + tokenizer.toString());
            }
            if (tokenizer.sval.compareToIgnoreCase("-inf") == 0) {
                this.m_UpperBound = Double.NEGATIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("+inf") == 0) {
                this.m_UpperBound = Double.POSITIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("inf") == 0) {
                this.m_UpperBound = Double.POSITIVE_INFINITY;
            } else {
                try {
                    this.m_UpperBound = Double.valueOf(tokenizer.sval);
                }
                catch (NumberFormatException e3) {
                    throw new IllegalArgumentException("Expected upper bound in range, found: '" + tokenizer.sval + "'");
                }
            }
            tokenizer.nextToken();
            if (tokenizer.ttype == 93) {
                this.m_UpperBoundIsOpen = false;
            } else if (tokenizer.ttype == 41) {
                this.m_UpperBoundIsOpen = true;
            } else {
                throw new IllegalArgumentException("Expected closing brace on range, found: " + tokenizer.toString());
            }
            if (tokenizer.nextToken() != -1) {
                throw new IllegalArgumentException("Expected end of range string, found: " + tokenizer.toString());
            }
        }
        catch (IOException e4) {
            throw new IllegalArgumentException("IOException reading attribute range string: " + e4.getMessage());
        }
        if (this.m_UpperBound < this.m_LowerBound) {
            throw new IllegalArgumentException("Upper bound (" + this.m_UpperBound + ") on numeric range is less than lower bound (" + this.m_LowerBound + ")!");
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

