/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.ArrayList;
import java.util.Enumeration;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;

public class BinarySparseInstance
extends SparseInstance {
    private static final long serialVersionUID = -5297388762342528737L;

    public BinarySparseInstance(Instance instance) {
        this.m_Weight = instance.weight();
        this.m_Dataset = null;
        this.m_NumAttributes = instance.numAttributes();
        if (instance instanceof SparseInstance) {
            this.m_AttValues = null;
            this.m_Indices = ((SparseInstance)instance).m_Indices;
        } else {
            int[] tempIndices = new int[instance.numAttributes()];
            int vals = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (instance.value(i) == 0.0) continue;
                tempIndices[vals] = i;
                ++vals;
            }
            this.m_AttValues = null;
            this.m_Indices = new int[vals];
            System.arraycopy(tempIndices, 0, this.m_Indices, 0, vals);
        }
    }

    public BinarySparseInstance(SparseInstance instance) {
        this.m_AttValues = null;
        this.m_Indices = instance.m_Indices;
        this.m_Weight = instance.m_Weight;
        this.m_NumAttributes = instance.m_NumAttributes;
        this.m_Dataset = null;
    }

    public BinarySparseInstance(double weight, double[] attValues) {
        this.m_Weight = weight;
        this.m_Dataset = null;
        this.m_NumAttributes = attValues.length;
        int[] tempIndices = new int[this.m_NumAttributes];
        int vals = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (attValues[i] == 0.0) continue;
            tempIndices[vals] = i;
            ++vals;
        }
        this.m_AttValues = null;
        this.m_Indices = new int[vals];
        System.arraycopy(tempIndices, 0, this.m_Indices, 0, vals);
    }

    public BinarySparseInstance(double weight, int[] indices, int maxNumValues) {
        this.m_AttValues = null;
        this.m_Indices = indices;
        this.m_Weight = weight;
        this.m_NumAttributes = maxNumValues;
        this.m_Dataset = null;
    }

    public BinarySparseInstance(int numAttributes) {
        this.m_AttValues = null;
        this.m_NumAttributes = numAttributes;
        this.m_Indices = new int[numAttributes];
        for (int i = 0; i < this.m_Indices.length; ++i) {
            this.m_Indices[i] = i;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    @Override
    public Object copy() {
        BinarySparseInstance result = new BinarySparseInstance(this);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    @Override
    public Instance copy(double[] values) {
        BinarySparseInstance result = new BinarySparseInstance(this.m_Weight, values);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    @Override
    public Instance mergeInstance(Instance inst) {
        int j;
        int[] indices = new int[this.numValues() + inst.numValues()];
        int m = 0;
        for (j = 0; j < this.numValues(); ++j) {
            indices[m++] = this.index(j);
        }
        for (j = 0; j < inst.numValues(); ++j) {
            if (inst.valueSparse(j) == 0.0) continue;
            indices[m++] = this.numAttributes() + inst.index(j);
        }
        if (m != indices.length) {
            int[] newInd = new int[m];
            System.arraycopy(indices, 0, newInd, 0, m);
            indices = newInd;
        }
        return new BinarySparseInstance(1.0, indices, this.numAttributes() + inst.numAttributes());
    }

    @Override
    public void replaceMissingValues(double[] array) {
    }

    @Override
    public void setValue(int attIndex, double value) {
        int index = this.locateIndex(attIndex);
        if (index >= 0 && this.m_Indices[index] == attIndex) {
            if (value == 0.0) {
                int[] tempIndices = new int[this.m_Indices.length - 1];
                System.arraycopy(this.m_Indices, 0, tempIndices, 0, index);
                System.arraycopy(this.m_Indices, index + 1, tempIndices, index, this.m_Indices.length - index - 1);
                this.m_Indices = tempIndices;
            }
        } else if (value != 0.0) {
            int[] tempIndices = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index + 1);
            tempIndices[index + 1] = attIndex;
            System.arraycopy(this.m_Indices, index + 1, tempIndices, index + 2, this.m_Indices.length - index - 1);
            this.m_Indices = tempIndices;
        }
    }

    @Override
    public void setValueSparse(int indexOfIndex, double value) {
        if (value == 0.0) {
            int[] tempIndices = new int[this.m_Indices.length - 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, indexOfIndex);
            System.arraycopy(this.m_Indices, indexOfIndex + 1, tempIndices, indexOfIndex, this.m_Indices.length - indexOfIndex - 1);
            this.m_Indices = tempIndices;
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] newValues = new double[this.m_NumAttributes];
        for (int i = 0; i < this.m_Indices.length; ++i) {
            newValues[this.m_Indices[i]] = 1.0;
        }
        return newValues;
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append('{');
        for (int i = 0; i < this.m_Indices.length; ++i) {
            if (i > 0) {
                text.append(",");
            }
            if (this.m_Dataset == null) {
                text.append(this.m_Indices[i] + " 1");
                continue;
            }
            if (this.m_Dataset.attribute(this.m_Indices[i]).isNominal() || this.m_Dataset.attribute(this.m_Indices[i]).isString()) {
                text.append(this.m_Indices[i] + " " + Utils.quote(this.m_Dataset.attribute(this.m_Indices[i]).value(1)));
                continue;
            }
            text.append(this.m_Indices[i] + " 1");
        }
        text.append('}');
        if (this.m_Weight != 1.0) {
            text.append(",{" + Utils.doubleToString(this.m_Weight, AbstractInstance.s_numericAfterDecimalPoint) + "}");
        }
        return text.toString();
    }

    @Override
    public double value(int attIndex) {
        int index = this.locateIndex(attIndex);
        if (index >= 0 && this.m_Indices[index] == attIndex) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public final double valueSparse(int indexOfIndex) {
        return 1.0;
    }

    @Override
    protected void forceDeleteAttributeAt(int position) {
        int index = this.locateIndex(position);
        --this.m_NumAttributes;
        if (index >= 0 && this.m_Indices[index] == position) {
            int[] tempIndices = new int[this.m_Indices.length - 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index);
            for (int i = index; i < this.m_Indices.length - 1; ++i) {
                tempIndices[i] = this.m_Indices[i + 1] - 1;
            }
            this.m_Indices = tempIndices;
        } else {
            int[] tempIndices = new int[this.m_Indices.length];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index + 1);
            for (int i = index + 1; i < this.m_Indices.length - 1; ++i) {
                tempIndices[i] = this.m_Indices[i] - 1;
            }
            this.m_Indices = tempIndices;
        }
    }

    @Override
    protected void forceInsertAttributeAt(int position) {
        int index = this.locateIndex(position);
        ++this.m_NumAttributes;
        if (index >= 0 && this.m_Indices[index] == position) {
            int[] tempIndices = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index);
            tempIndices[index] = position;
            for (int i = index; i < this.m_Indices.length; ++i) {
                tempIndices[i + 1] = this.m_Indices[i] + 1;
            }
            this.m_Indices = tempIndices;
        } else {
            int[] tempIndices = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index + 1);
            tempIndices[index + 1] = position;
            for (int i = index + 1; i < this.m_Indices.length; ++i) {
                tempIndices[i + 1] = this.m_Indices[i] + 1;
            }
            this.m_Indices = tempIndices;
        }
    }

    public static void main(String[] options) {
        try {
            int i;
            Attribute length = new Attribute("length");
            Attribute weight = new Attribute("weight");
            ArrayList<String> my_nominal_values = new ArrayList<String>(3);
            my_nominal_values.add("first");
            my_nominal_values.add("second");
            Attribute position = new Attribute("position", my_nominal_values);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
            attributes.add(length);
            attributes.add(weight);
            attributes.add(position);
            Instances race = new Instances("race", attributes, 0);
            race.setClassIndex(position.index());
            BinarySparseInstance inst = new BinarySparseInstance(3);
            inst.setValue(length, 5.3);
            inst.setValue(weight, 300.0);
            inst.setValue(position, "first");
            inst.setDataset(race);
            System.out.println("The instance: " + inst);
            System.out.println("First attribute: " + inst.attribute(0));
            System.out.println("Class attribute: " + inst.classAttribute());
            System.out.println("Class index: " + inst.classIndex());
            System.out.println("Class is missing: " + inst.classIsMissing());
            System.out.println("Class value (internal format): " + inst.classValue());
            SparseInstance copy = (SparseInstance)inst.copy();
            System.out.println("Shallow copy: " + copy);
            copy.setDataset(inst.dataset());
            System.out.println("Shallow copy with dataset set: " + copy);
            System.out.print("All stored values in internal format: ");
            for (i = 0; i < inst.numValues(); ++i) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(inst.valueSparse(i));
            }
            System.out.println();
            System.out.print("All values set to zero: ");
            while (inst.numValues() > 0) {
                inst.setValueSparse(0, 0.0);
            }
            for (i = 0; i < inst.numValues(); ++i) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(inst.valueSparse(i));
            }
            System.out.println();
            System.out.print("All values set to one: ");
            for (i = 0; i < inst.numAttributes(); ++i) {
                inst.setValue(i, 1.0);
            }
            for (i = 0; i < inst.numValues(); ++i) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(inst.valueSparse(i));
            }
            System.out.println();
            copy.setDataset(null);
            copy.deleteAttributeAt(0);
            copy.insertAttributeAt(0);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with first attribute deleted and inserted: " + copy);
            copy.setDataset(null);
            copy.deleteAttributeAt(1);
            copy.insertAttributeAt(1);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with second attribute deleted and inserted: " + copy);
            copy.setDataset(null);
            copy.deleteAttributeAt(2);
            copy.insertAttributeAt(2);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with third attribute deleted and inserted: " + copy);
            System.out.println("Enumerating attributes (leaving out class):");
            Enumeration<Attribute> enu = inst.enumerateAttributes();
            while (enu.hasMoreElements()) {
                Attribute att = enu.nextElement();
                System.out.println(att);
            }
            System.out.println("Header of original and copy equivalent: " + inst.equalHeaders(copy));
            System.out.println("Length of copy missing: " + copy.isMissing(length));
            System.out.println("Weight of copy missing: " + copy.isMissing(weight.index()));
            System.out.println("Length of copy missing: " + Utils.isMissingValue(copy.value(length)));
            System.out.println("Number of attributes: " + copy.numAttributes());
            System.out.println("Number of classes: " + copy.numClasses());
            double[] meansAndModes = new double[]{2.0, 3.0, 0.0};
            copy.replaceMissingValues(meansAndModes);
            System.out.println("Copy with missing value replaced: " + copy);
            copy.setClassMissing();
            System.out.println("Copy with missing class: " + copy);
            copy.setClassValue(0.0);
            System.out.println("Copy with class value set to first value: " + copy);
            copy.setClassValue("second");
            System.out.println("Copy with class value set to \"second\": " + copy);
            copy.setMissing(1);
            System.out.println("Copy with second attribute set to be missing: " + copy);
            copy.setMissing(length);
            System.out.println("Copy with length set to be missing: " + copy);
            copy.setValue(0, 0.0);
            System.out.println("Copy with first attribute set to 0: " + copy);
            copy.setValue(weight, 1.0);
            System.out.println("Copy with weight attribute set to 1: " + copy);
            copy.setValue(position, "second");
            System.out.println("Copy with position set to \"second\": " + copy);
            copy.setValue(2, "first");
            System.out.println("Copy with last attribute set to \"first\": " + copy);
            System.out.println("Current weight of instance copy: " + copy.weight());
            copy.setWeight(2.0);
            System.out.println("Current weight of instance copy (set to 2): " + copy.weight());
            System.out.println("Last value of copy: " + copy.toString(2));
            System.out.println("Value of position for copy: " + copy.toString(position));
            System.out.println("Last value of copy (internal format): " + copy.value(2));
            System.out.println("Value of position for copy (internal format): " + copy.value(position));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12472 $");
    }
}

