/*
 * Decompiled with CFR 0.152.
 */
package weka.core.json;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Reader;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import weka.core.json.Parser;
import weka.core.json.Scanner;

public class JSONNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -3047440914507883491L;
    protected String m_Name;
    protected Object m_Value;
    protected NodeType m_NodeType;

    public JSONNode() {
        this(null, NodeType.OBJECT);
    }

    public JSONNode(String name, Boolean value) {
        this(name, value, NodeType.PRIMITIVE);
    }

    public JSONNode(String name, Integer value) {
        this(name, value, NodeType.PRIMITIVE);
    }

    public JSONNode(String name, Double value) {
        this(name, value, NodeType.PRIMITIVE);
    }

    public JSONNode(String name, String value) {
        this(name, value, NodeType.PRIMITIVE);
    }

    protected JSONNode(String name, NodeType type) {
        this(name, null, type);
    }

    protected JSONNode(String name, Object value, NodeType type) {
        this.m_Name = name;
        this.m_Value = value;
        this.m_NodeType = type;
    }

    public boolean isAnonymous() {
        return this.m_Name == null;
    }

    public String getName() {
        return this.m_Name;
    }

    public Object getValue() {
        return this.getValue(null);
    }

    public Object getValue(Object defValue) {
        if (this.m_Value == null) {
            return defValue;
        }
        if (this.m_Value instanceof String) {
            return this.unescape(this.m_Value.toString());
        }
        return this.m_Value;
    }

    public boolean isPrimitive() {
        return this.m_NodeType == NodeType.PRIMITIVE;
    }

    public boolean isArray() {
        return this.m_NodeType == NodeType.ARRAY;
    }

    public boolean isObject() {
        return this.m_NodeType == NodeType.OBJECT;
    }

    public NodeType getNodeType() {
        return this.m_NodeType;
    }

    public JSONNode addNull(String name) {
        return this.add(name, null, NodeType.PRIMITIVE);
    }

    public JSONNode addPrimitive(String name, Boolean value) {
        return this.add(name, value, NodeType.PRIMITIVE);
    }

    public JSONNode addPrimitive(String name, Integer value) {
        return this.add(name, value, NodeType.PRIMITIVE);
    }

    public JSONNode addPrimitive(String name, Double value) {
        return this.add(name, value, NodeType.PRIMITIVE);
    }

    public JSONNode addPrimitive(String name, String value) {
        return this.add(name, value, NodeType.PRIMITIVE);
    }

    public JSONNode addArray(String name) {
        return this.add(name, null, NodeType.ARRAY);
    }

    public JSONNode addNullArrayElement() {
        return this.add(null, null, NodeType.PRIMITIVE);
    }

    public JSONNode addObjectArrayElement() {
        return this.add(null, null, NodeType.OBJECT);
    }

    public JSONNode addArrayElement(Object value) {
        if (this.getNodeType() != NodeType.ARRAY) {
            return null;
        }
        NodeType type = null;
        if (value != null) {
            type = value instanceof Boolean ? NodeType.PRIMITIVE : (value instanceof Integer ? NodeType.PRIMITIVE : (value instanceof Double ? NodeType.PRIMITIVE : (value instanceof String ? NodeType.PRIMITIVE : (value.getClass().isArray() ? NodeType.ARRAY : NodeType.OBJECT))));
        }
        return this.add(null, value, type);
    }

    public JSONNode addObject(String name) {
        return this.add(name, null, NodeType.OBJECT);
    }

    protected JSONNode add(String name, Object value, NodeType type) {
        if (this.isPrimitive()) {
            return null;
        }
        JSONNode child = new JSONNode(name, value, type);
        this.add(child);
        return child;
    }

    public boolean hasChild(String name) {
        return this.getChild(name) != null;
    }

    public JSONNode getChild(String name) {
        JSONNode result = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            JSONNode node = (JSONNode)this.getChildAt(i);
            if (node.isAnonymous() || !node.getName().equals(name)) continue;
            result = node;
            break;
        }
        return result;
    }

    protected String getIndentation(int level) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            result.append("\t");
        }
        return result.toString();
    }

    protected Object escape(Object o) {
        if (o instanceof String) {
            return this.escape((String)o);
        }
        return o;
    }

    protected String escape(String s) {
        StringBuffer result;
        if ((s = s.replace("\\n", "@@-@@n").replace("\\r", "@@-@@r").replace("\\t", "@@-@@t").replace("\\b", "@@-@@b").replace("\\f", "@@-@@f")).indexOf(34) > -1 || s.indexOf(92) > -1 || s.indexOf(8) > -1 || s.indexOf(12) > -1 || s.indexOf(10) > -1 || s.indexOf(13) > -1 || s.indexOf(9) > -1) {
            result = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char c2 = s.charAt(i);
                if (c2 == '\"') {
                    result.append("\\\"");
                    continue;
                }
                if (c2 == '\\') {
                    result.append("\\\\");
                    continue;
                }
                if (c2 == '\b') {
                    result.append("\\b");
                    continue;
                }
                if (c2 == '\f') {
                    result.append("\\f");
                    continue;
                }
                if (c2 == '\n') {
                    result.append("\\n");
                    continue;
                }
                if (c2 == '\r') {
                    result.append("\\r");
                    continue;
                }
                if (c2 == '\t') {
                    result.append("\\t");
                    continue;
                }
                result.append(c2);
            }
        } else {
            result = new StringBuffer(s);
        }
        return result.toString();
    }

    protected String unescape(String s) {
        String[] charsFind = new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\b", "\\f", "\\\"", "\\%", "\\u001E"};
        char[] charsReplace = new char[]{'\\', '\'', '\t', '\n', '\r', '\b', '\f', '\"', '%', '\u001e'};
        int[] pos = new int[charsFind.length];
        String str = new String(s);
        StringBuilder newStringBuffer = new StringBuilder();
        while (str.length() > 0) {
            int curPos = str.length();
            int index = -1;
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = str.indexOf(charsFind[i]);
                if (pos[i] <= -1 || pos[i] >= curPos) continue;
                index = i;
                curPos = pos[i];
            }
            if (index == -1) {
                newStringBuffer.append(str);
                str = "";
                continue;
            }
            newStringBuffer.append(str.substring(0, pos[index]));
            newStringBuffer.append(charsReplace[index]);
            str = str.substring(pos[index] + charsFind[index].length());
        }
        return newStringBuffer.toString().replace("@@-@@", "\\");
    }

    public void toString(StringBuffer buffer) {
        int level = this.getLevel();
        boolean isLast = this.getNextSibling() == null;
        String indent = this.getIndentation(level);
        buffer.append(indent);
        if (this.m_Name != null) {
            buffer.append("\"");
            buffer.append(this.escape(this.m_Name));
            buffer.append("\" : ");
        }
        if (this.isObject()) {
            buffer.append("{\n");
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((JSONNode)this.getChildAt(i)).toString(buffer);
            }
            buffer.append(indent);
            buffer.append("}");
        } else if (this.isArray()) {
            buffer.append("[\n");
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((JSONNode)this.getChildAt(i)).toString(buffer);
            }
            buffer.append(indent);
            buffer.append("]");
        } else if (this.m_Value == null) {
            buffer.append("null");
        } else if (this.m_Value instanceof String) {
            buffer.append("\"");
            buffer.append(this.escape((String)this.m_Value));
            buffer.append("\"");
        } else {
            buffer.append(this.m_Value.toString());
        }
        if (!isLast) {
            buffer.append(",");
        }
        buffer.append("\n");
    }

    @Override
    public String toString() {
        String result = null;
        result = this.isObject() ? (this.isRoot() ? "JSON" : (this.m_Name == null ? "<object>" : this.escape(this.m_Name) + " (Object)")) : (this.isArray() ? (this.m_Name == null ? "<array>" : this.escape(this.m_Name) + " (Array)") : (this.m_Name != null ? this.escape(this.m_Name) + ": " + this.escape(this.m_Value) : "" + this.m_Value));
        return result;
    }

    public static JSONNode read(Reader reader) throws Exception {
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        Parser parser2 = new Parser(new Scanner(reader, (SymbolFactory)sf), sf);
        parser2.parse();
        return parser2.getResult();
    }

    public static void main(String[] args) throws Exception {
        JSONNode person = new JSONNode();
        person.addPrimitive("firstName", "John");
        person.addPrimitive("lastName", "Smith");
        JSONNode address = person.addObject("address");
        address.addPrimitive("streetAddress", "21 2nd Street");
        address.addPrimitive("city", "New York");
        address.addPrimitive("state", "NY");
        address.addPrimitive("postalCode", 10021);
        JSONNode phonenumbers = person.addArray("phoneNumbers");
        phonenumbers.addArrayElement("212 555-1234");
        phonenumbers.addArrayElement("646 555-4567");
        StringBuffer buffer = new StringBuffer();
        person.toString(buffer);
        System.out.println(buffer.toString());
        JTree tree = new JTree(person);
        JFrame frame = new JFrame("JSON");
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new JScrollPane(tree), "Center");
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static enum NodeType {
        PRIMITIVE,
        OBJECT,
        ARRAY;

    }
}

