/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddID;

public class FilteredNeighbourSearch
extends NearestNeighbourSearch
implements CapabilitiesHandler {
    private static final long serialVersionUID = 1369174644087067375L;
    protected AddID m_AddID = new AddID();
    protected int m_IndexOfID = -1;
    protected Filter m_Filter = new AllFilter();
    protected NearestNeighbourSearch m_SearchMethod = new LinearNNSearch();
    protected NearestNeighbourSearch m_ModifiedSearchMethod = null;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getFilter().getCapabilities();
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    @Override
    public void setInstances(Instances data) {
        try {
            super.setInstances(data);
            this.getCapabilities().testWithFail(data);
            Instances filteredData = new Instances(data);
            this.getFilter().setInputFormat(filteredData);
            filteredData = Filter.useFilter(data, this.getFilter());
            if (data.numInstances() != filteredData.numInstances()) {
                throw new IllegalArgumentException("FilteredNeighbourSearch: Filter has changed the number of instances!");
            }
            this.m_IndexOfID = filteredData.numAttributes();
            this.m_AddID.setIDIndex("" + (filteredData.numAttributes() + 1));
            this.m_AddID.setInputFormat(filteredData);
            filteredData = Filter.useFilter(filteredData, this.m_AddID);
            this.m_ModifiedSearchMethod = (NearestNeighbourSearch)new SerializedObject(this.getSearchMethod()).getObject();
            this.m_ModifiedSearchMethod.getDistanceFunction().setAttributeIndices("1-" + this.m_IndexOfID);
            this.m_ModifiedSearchMethod.getDistanceFunction().setInvertSelection(false);
            this.m_ModifiedSearchMethod.setInstances(filteredData);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String globalInfo() {
        return "Applies the given filter before calling the given neighbour search method. The filter must not change the size of the dataset or the order of the instances! Also, the range setting that is specified for the distance function is ignored: all attributes are used for the distance calculation.";
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String searchMethodTipText() {
        return "The search method to be used.";
    }

    public void setSearchMethod(NearestNeighbourSearch search) {
        this.m_SearchMethod = search;
    }

    public NearestNeighbourSearch getSearchMethod() {
        return this.m_SearchMethod;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tThe filter to use. (default: weka.filters.AllFilter", "F", 1, "-F"));
        result.addElement(new Option("\tThe search method to use. (default: weka.core.neighboursearch.LinearNNSearch)", "S", 0, "-S"));
        if (this.m_Filter instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.m_Filter.getClass().getName() + ":"));
            result.addAll(Collections.list(this.m_Filter.listOptions()));
        }
        if (this.m_SearchMethod instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to search method " + this.m_SearchMethod.getClass().getName() + ":"));
            result.addAll(Collections.list(this.m_SearchMethod.listOptions()));
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-F");
        result.add("" + this.getFilterSpec());
        result.add("-S");
        result.add("" + this.getSearchMethodSpec());
        return result.toArray(new String[result.size()]);
    }

    protected String getFilterSpec() {
        Filter c2 = this.getFilter();
        if (c2 instanceof OptionHandler) {
            return c2.getClass().getName() + " " + Utils.joinOptions(c2.getOptions());
        }
        return c2.getClass().getName();
    }

    protected String getSearchMethodSpec() {
        NearestNeighbourSearch c2 = this.getSearchMethod();
        if (c2 instanceof OptionHandler) {
            return c2.getClass().getName() + " " + Utils.joinOptions(c2.getOptions());
        }
        return c2.getClass().getName();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String searchMethod = Utils.getOption('S', options);
        if (searchMethod.length() != 0) {
            String[] searchMethodSpec = Utils.splitOptions(searchMethod);
            if (searchMethodSpec.length == 0) {
                throw new Exception("Invalid search method specification string.");
            }
            String className = searchMethodSpec[0];
            searchMethodSpec[0] = "";
            this.setSearchMethod((NearestNeighbourSearch)Utils.forName(NearestNeighbourSearch.class, className, searchMethodSpec));
        } else {
            this.setSearchMethod(new LinearNNSearch());
        }
        String filter = Utils.getOption('F', options);
        if (filter.length() != 0) {
            String[] filterSpec = Utils.splitOptions(filter);
            if (filterSpec.length == 0) {
                throw new Exception("Invalid filter specification string.");
            }
            String className = filterSpec[0];
            filterSpec[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, className, filterSpec));
        } else {
            this.setFilter(new AllFilter());
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11006 $");
    }

    @Override
    public Instance nearestNeighbour(Instance target) throws Exception {
        this.getFilter().input(target);
        this.m_AddID.input(this.getFilter().output());
        return this.getInstances().instance((int)this.m_ModifiedSearchMethod.nearestNeighbour(this.m_AddID.output()).value(this.m_IndexOfID) - 1);
    }

    @Override
    public Instances kNearestNeighbours(Instance target, int k) throws Exception {
        this.getFilter().input(target);
        this.m_AddID.input(this.getFilter().output());
        Instances neighboursInFilteredSpace = this.m_ModifiedSearchMethod.kNearestNeighbours(this.m_AddID.output(), k);
        Instances neighbours = new Instances(this.getInstances(), k);
        for (Instance inst : neighboursInFilteredSpace) {
            neighbours.add(this.getInstances().instance((int)inst.value(this.m_IndexOfID) - 1));
        }
        return neighbours;
    }

    @Override
    public double[] getDistances() throws Exception {
        return this.m_ModifiedSearchMethod.getDistances();
    }

    @Override
    public void update(Instance ins) throws Exception {
        this.getFilter().input(ins);
        this.m_AddID.input(this.getFilter().output());
        this.m_ModifiedSearchMethod.update(this.m_AddID.output());
    }

    @Override
    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            try {
                this.getFilter().input(ins);
                this.m_AddID.input(this.getFilter().output());
                this.m_ModifiedSearchMethod.addInstanceInfo(this.m_AddID.output());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

