/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import weka.core.Copyable;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;

public class PointsClosestToFurthestChildren
extends BallSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -2947177543565818260L;

    public String globalInfo() {
        return "Implements the Moore's method to split a node of a ball tree.\n\nFor more information please see section 2 of the 1st and 3.2.3 of the 2nd:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore");
        result.setValue(TechnicalInformation.Field.TITLE, "The Anchors Hierarchy: Using the Triangle Inequality to Survive High Dimensional Data");
        result.setValue(TechnicalInformation.Field.YEAR, "2000");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "UAI '00: Proceedings of the 16th Conference on Uncertainty in Artificial Intelligence");
        result.setValue(TechnicalInformation.Field.PAGES, "397-405");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers Inc.");
        result.setValue(TechnicalInformation.Field.ADDRESS, "San Francisco, CA, USA");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.MASTERSTHESIS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        additional.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        additional.setValue(TechnicalInformation.Field.YEAR, "2007");
        additional.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return result;
    }

    public PointsClosestToFurthestChildren() {
    }

    public PointsClosestToFurthestChildren(int[] instList, Instances insts, EuclideanDistance e2) {
        super(instList, insts, e2);
    }

    @Override
    public void splitNode(BallNode node, int numNodesCreated) throws Exception {
        Instance temp;
        int i;
        this.correctlyInitialized();
        double maxDist = Double.NEGATIVE_INFINITY;
        double dist = 0.0;
        Copyable furthest1 = null;
        Copyable furthest2 = null;
        Instance pivot = node.getPivot();
        double[] distList = new double[node.m_NumInstances];
        for (i = node.m_Start; i <= node.m_End; ++i) {
            temp = this.m_Instances.instance(this.m_Instlist[i]);
            dist = this.m_DistanceFunction.distance(pivot, temp, Double.POSITIVE_INFINITY);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
            furthest1 = temp;
        }
        maxDist = Double.NEGATIVE_INFINITY;
        furthest1 = (Instance)furthest1.copy();
        for (i = 0; i < node.m_NumInstances; ++i) {
            temp = this.m_Instances.instance(this.m_Instlist[i + node.m_Start]);
            distList[i] = this.m_DistanceFunction.distance((Instance)furthest1, temp, Double.POSITIVE_INFINITY);
            if (!(distList[i] > maxDist)) continue;
            maxDist = distList[i];
            furthest2 = temp;
        }
        furthest2 = (Instance)furthest2.copy();
        dist = 0.0;
        int numRight = 0;
        for (int i2 = 0; i2 < node.m_NumInstances - numRight; ++i2) {
            temp = this.m_Instances.instance(this.m_Instlist[i2 + node.m_Start]);
            dist = this.m_DistanceFunction.distance((Instance)furthest2, temp, Double.POSITIVE_INFINITY);
            if (!(dist < distList[i2])) continue;
            int t = this.m_Instlist[node.m_End - numRight];
            this.m_Instlist[node.m_End - numRight] = this.m_Instlist[i2 + node.m_Start];
            this.m_Instlist[i2 + node.m_Start] = t;
            double d2 = distList[distList.length - 1 - numRight];
            distList[distList.length - 1 - numRight] = distList[i2];
            distList[i2] = d2;
            ++numRight;
            --i2;
        }
        if (numRight <= 0 || numRight >= node.m_NumInstances) {
            throw new Exception("Illegal value for numRight: " + numRight);
        }
        pivot = BallNode.calcCentroidPivot(node.m_Start, node.m_End - numRight, this.m_Instlist, this.m_Instances);
        node.m_Left = new BallNode(node.m_Start, node.m_End - numRight, numNodesCreated + 1, pivot, BallNode.calcRadius(node.m_Start, node.m_End - numRight, this.m_Instlist, this.m_Instances, pivot, this.m_DistanceFunction));
        pivot = BallNode.calcCentroidPivot(node.m_End - numRight + 1, node.m_End, this.m_Instlist, this.m_Instances);
        node.m_Right = new BallNode(node.m_End - numRight + 1, node.m_End, numNodesCreated + 2, pivot, BallNode.calcRadius(node.m_End - numRight + 1, node.m_End, this.m_Instlist, this.m_Instances, pivot, this.m_DistanceFunction));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

