/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

public class Constant
extends Expression {
    private static final long serialVersionUID = -304829687822452424L;
    protected String m_categoricalConst = null;
    protected double m_continuousConst = Double.NaN;

    public Constant(Element constant, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs) throws Exception {
        super(opType, fieldDefs);
        NodeList constL = constant.getChildNodes();
        String c2 = constL.item(0).getNodeValue();
        if (this.m_opType == FieldMetaInfo.Optype.CATEGORICAL || this.m_opType == FieldMetaInfo.Optype.ORDINAL) {
            this.m_categoricalConst = c2;
        } else {
            try {
                this.m_continuousConst = Double.parseDouble(c2);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[Constant] Unable to parse continuous constant: " + c2);
            }
        }
    }

    @Override
    protected Attribute getOutputDef() {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            return new Attribute("Constant: " + this.m_continuousConst);
        }
        ArrayList<String> nom = new ArrayList<String>();
        nom.add(this.m_categoricalConst);
        return new Attribute("Constant: " + this.m_categoricalConst, nom);
    }

    @Override
    public double getResult(double[] incoming) {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            return this.m_continuousConst;
        }
        return 0.0;
    }

    @Override
    public String getResultCategorical(double[] incoming) throws Exception {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new IllegalArgumentException("[Constant] Cant't return result as categorical/ordinal as optype is continuous!");
        }
        return this.m_categoricalConst;
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(f);
            doc.getDocumentElement().normalize();
            NodeList constL = doc.getElementsByTagName("Constant");
            Node c2 = constL.item(0);
            if (c2.getNodeType() == 1) {
                Constant constC = new Constant((Element)c2, FieldMetaInfo.Optype.CONTINUOUS, null);
                System.err.println("Value of first constant: " + constC.getResult(null));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String toString(String pad) {
        return pad + "Constant: " + (this.m_categoricalConst != null ? this.m_categoricalConst : "" + this.m_continuousConst);
    }
}

