/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.pmml.DefineFunction;
import weka.core.pmml.DerivedFieldMetaInfo;

class TransformationDictionary
implements Serializable {
    private static final long serialVersionUID = -4649092421002319829L;
    protected ArrayList<DefineFunction> m_defineFunctions = new ArrayList();
    protected ArrayList<DerivedFieldMetaInfo> m_derivedFields = new ArrayList();

    protected TransformationDictionary(Element dictionary, Instances dataDictionary) throws Exception {
        NodeList derivedL = dictionary.getChildNodes();
        for (int i = 0; i < derivedL.getLength(); ++i) {
            Node child = derivedL.item(i);
            if (child.getNodeType() != 1) continue;
            String tagName = ((Element)child).getTagName();
            if (tagName.equals("DerivedField")) {
                DerivedFieldMetaInfo df = new DerivedFieldMetaInfo((Element)child, null, null);
                this.m_derivedFields.add(df);
                continue;
            }
            if (!tagName.equals("DefineFunction")) continue;
            DefineFunction defF = new DefineFunction((Element)child, null);
            this.m_defineFunctions.add(defF);
        }
    }

    protected void setFieldDefsForDerivedFields(ArrayList<Attribute> fieldDefs) throws Exception {
        int i;
        for (i = 0; i < this.m_derivedFields.size(); ++i) {
            this.m_derivedFields.get(i).setFieldDefs(fieldDefs);
        }
        for (i = 0; i < this.m_defineFunctions.size(); ++i) {
            this.m_defineFunctions.get(i).pushParameterDefs();
        }
    }

    protected void setFieldDefsForDerivedFields(Instances fieldDefs) throws Exception {
        ArrayList<Attribute> tempDefs = new ArrayList<Attribute>();
        for (int i = 0; i < fieldDefs.numAttributes(); ++i) {
            tempDefs.add(fieldDefs.attribute(i));
        }
        this.setFieldDefsForDerivedFields(tempDefs);
    }

    protected ArrayList<DerivedFieldMetaInfo> getDerivedFields() {
        return new ArrayList<DerivedFieldMetaInfo>(this.m_derivedFields);
    }

    protected DefineFunction getFunction(String functionName) throws Exception {
        DefineFunction copy = null;
        DefineFunction match = null;
        for (DefineFunction f : this.m_defineFunctions) {
            if (!f.getName().equals(functionName)) continue;
            match = f;
            break;
        }
        if (match != null) {
            SerializedObject so = new SerializedObject(match, false);
            copy = (DefineFunction)so.getObject();
        }
        return copy;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Transformation dictionary:\n");
        if (this.m_derivedFields.size() > 0) {
            buff.append("derived fields:\n");
            for (DerivedFieldMetaInfo d2 : this.m_derivedFields) {
                buff.append("" + d2.getFieldAsAttribute() + "\n");
            }
        }
        if (this.m_defineFunctions.size() > 0) {
            buff.append("\nfunctions:\n");
            for (DefineFunction f : this.m_defineFunctions) {
                buff.append(f.toString("  ") + "\n");
            }
        }
        buff.append("\n");
        return buff.toString();
    }
}

