/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class ResultMatrix
implements Serializable,
RevisionHandler,
OptionHandler {
    private static final long serialVersionUID = 4487179306428209739L;
    public static final int SIGNIFICANCE_TIE = 0;
    public static final int SIGNIFICANCE_WIN = 1;
    public static final int SIGNIFICANCE_LOSS = 2;
    public String TIE_STRING = " ";
    public String WIN_STRING = "v";
    public String LOSS_STRING = "*";
    public String LEFT_PARENTHESES = "(";
    public String RIGHT_PARENTHESES = ")";
    protected String[] m_ColNames = null;
    protected String[] m_RowNames = null;
    protected boolean[] m_ColHidden = null;
    protected boolean[] m_RowHidden = null;
    protected int[][] m_Significance = null;
    protected double[][] m_Mean = null;
    protected double[][] m_StdDev = null;
    protected double[] m_Counts = null;
    protected int m_MeanPrec;
    protected int m_StdDevPrec;
    protected boolean m_ShowStdDev;
    protected boolean m_ShowAverage;
    protected boolean m_PrintColNames;
    protected boolean m_PrintRowNames;
    protected boolean m_EnumerateColNames;
    protected boolean m_EnumerateRowNames;
    protected int m_ColNameWidth;
    protected int m_RowNameWidth;
    protected int m_MeanWidth;
    protected int m_StdDevWidth;
    protected int m_SignificanceWidth;
    protected int m_CountWidth;
    protected Vector<String> m_HeaderKeys = null;
    protected Vector<String> m_HeaderValues = null;
    protected int[][] m_NonSigWins = null;
    protected int[][] m_Wins = null;
    protected int[] m_RankingWins = null;
    protected int[] m_RankingLosses = null;
    protected int[] m_RankingDiff = null;
    protected int[] m_RowOrder = null;
    protected int[] m_ColOrder = null;
    protected boolean m_RemoveFilterName = false;

    public ResultMatrix() {
        this(1, 1);
    }

    public ResultMatrix(int cols, int rows) {
        this.setSize(cols, rows);
        this.clear();
    }

    public ResultMatrix(ResultMatrix matrix) {
        this.assign(matrix);
    }

    public abstract String globalInfo();

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe number of decimals after the decimal point for the mean.\n\t(default: " + this.getDefaultMeanPrec() + ")", "mean-prec", 1, "-mean-prec <int>"));
        result.addElement(new Option("\tThe number of decimals after the decimal point for the mean.\n\t(default: " + this.getDefaultStdDevPrec() + ")", "stddev-prec", 1, "-stddev-prec <int>"));
        result.addElement(new Option("\tThe maximum width for the column names (0 = optimal).\n\t(default: " + this.getDefaultColNameWidth() + ")", "col-name-width", 1, "-col-name-width <int>"));
        result.addElement(new Option("\tThe maximum width for the row names (0 = optimal).\n\t(default: " + this.getDefaultRowNameWidth() + ")", "row-name-width", 1, "-row-name-width <int>"));
        result.addElement(new Option("\tThe width of the mean (0 = optimal).\n\t(default: " + this.getDefaultMeanWidth() + ")", "mean-width", 1, "-mean-width <int>"));
        result.addElement(new Option("\tThe width of the standard deviation (0 = optimal).\n\t(default: " + this.getDefaultStdDevWidth() + ")", "stddev-width", 1, "-stddev-width <int>"));
        result.addElement(new Option("\tThe width of the significance indicator (0 = optimal).\n\t(default: " + this.getDefaultSignificanceWidth() + ")", "sig-width", 1, "-sig-width <int>"));
        result.addElement(new Option("\tThe width of the counts (0 = optimal).\n\t(default: " + this.getDefaultCountWidth() + ")", "count-width", 1, "-count-width <int>"));
        result.addElement(new Option("\tWhether to display the standard deviation column.\n\t(default: no)", "show-stddev", 0, "-show-stddev"));
        result.addElement(new Option("\tWhether to show the row with averages.\n\t(default: no)", "show-avg", 0, "-show-avg"));
        result.addElement(new Option("\tWhether to remove the classname package prefixes from the\n\tfilter names in datasets.\n\t(default: no)", "remove-filter", 0, "-remove-filter"));
        result.addElement(new Option("\tWhether to output column names or just numbers representing them.\n\t(default: no)", "print-col-names", 0, "-print-col-names"));
        result.addElement(new Option("\tWhether to output row names or just numbers representing them.\n\t(default: no)", "print-row-names", 0, "-print-row-names"));
        result.addElement(new Option("\tWhether to enumerate the column names (prefixing them with \n\t'(x)', with 'x' being the index).\n\t(default: no)", "enum-col-names", 0, "-enum-col-names"));
        result.addElement(new Option("\tWhether to enumerate the row names (prefixing them with \n\t'(x)', with 'x' being the index).\n\t(default: no)", "enum-row-names", 0, "-enum-row-names"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("mean-prec", options);
        if (tmpStr.length() > 0) {
            this.setMeanPrec(Integer.parseInt(tmpStr));
        } else {
            this.setMeanPrec(this.getDefaultMeanPrec());
        }
        tmpStr = Utils.getOption("stddev-prec", options);
        if (tmpStr.length() > 0) {
            this.setStdDevPrec(Integer.parseInt(tmpStr));
        } else {
            this.setStdDevPrec(this.getDefaultStdDevPrec());
        }
        tmpStr = Utils.getOption("col-name-width", options);
        if (tmpStr.length() > 0) {
            this.setColNameWidth(Integer.parseInt(tmpStr));
        } else {
            this.setColNameWidth(this.getDefaultColNameWidth());
        }
        tmpStr = Utils.getOption("row-name-width", options);
        if (tmpStr.length() > 0) {
            this.setRowNameWidth(Integer.parseInt(tmpStr));
        } else {
            this.setRowNameWidth(this.getDefaultRowNameWidth());
        }
        tmpStr = Utils.getOption("mean-width", options);
        if (tmpStr.length() > 0) {
            this.setMeanWidth(Integer.parseInt(tmpStr));
        } else {
            this.setMeanWidth(this.getDefaultMeanWidth());
        }
        tmpStr = Utils.getOption("stddev-width", options);
        if (tmpStr.length() > 0) {
            this.setStdDevWidth(Integer.parseInt(tmpStr));
        } else {
            this.setStdDevWidth(this.getDefaultStdDevWidth());
        }
        tmpStr = Utils.getOption("sig-width", options);
        if (tmpStr.length() > 0) {
            this.setSignificanceWidth(Integer.parseInt(tmpStr));
        } else {
            this.setSignificanceWidth(this.getDefaultSignificanceWidth());
        }
        tmpStr = Utils.getOption("count-width", options);
        if (tmpStr.length() > 0) {
            this.setStdDevPrec(Integer.parseInt(tmpStr));
        } else {
            this.setStdDevPrec(this.getDefaultCountWidth());
        }
        this.setShowStdDev(Utils.getFlag("show-stddev", options));
        this.setShowAverage(Utils.getFlag("show-avg", options));
        this.setRemoveFilterName(Utils.getFlag("remove-filter", options));
        this.setEnumerateColNames(Utils.getFlag("enum-col-names", options));
        this.setEnumerateRowNames(Utils.getFlag("enum-row-names", options));
        this.setPrintColNames(Utils.getFlag("print-col-names", options));
        this.setPrintRowNames(Utils.getFlag("print-row-names", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-mean-prec");
        result.add("" + this.getMeanPrec());
        result.add("-stddev-prec");
        result.add("" + this.getStdDevPrec());
        result.add("-col-name-width");
        result.add("" + this.getColNameWidth());
        result.add("-row-name-width");
        result.add("" + this.getRowNameWidth());
        result.add("-mean-width");
        result.add("" + this.getMeanWidth());
        result.add("-stddev-width");
        result.add("" + this.getStdDevWidth());
        result.add("-sig-width");
        result.add("" + this.getSignificanceWidth());
        result.add("-count-width");
        result.add("" + this.getCountWidth());
        if (this.getShowStdDev()) {
            result.add("-show-stddev");
        }
        if (this.getShowAverage()) {
            result.add("-show-avg");
        }
        if (this.getRemoveFilterName()) {
            result.add("-remove-filter");
        }
        if (this.getPrintColNames()) {
            result.add("-print-col-names");
        }
        if (this.getPrintRowNames()) {
            result.add("-print-row-names");
        }
        if (this.getEnumerateColNames()) {
            result.add("-enum-col-names");
        }
        if (this.getEnumerateRowNames()) {
            result.add("-enum-row-names");
        }
        return result.toArray(new String[result.size()]);
    }

    public abstract String getDisplayName();

    public void assign(ResultMatrix matrix) {
        int n;
        int i;
        this.setSize(matrix.getColCount(), matrix.getRowCount());
        this.TIE_STRING = matrix.TIE_STRING;
        this.WIN_STRING = matrix.WIN_STRING;
        this.LOSS_STRING = matrix.LOSS_STRING;
        this.LEFT_PARENTHESES = matrix.LEFT_PARENTHESES;
        this.RIGHT_PARENTHESES = matrix.RIGHT_PARENTHESES;
        this.m_MeanPrec = matrix.m_MeanPrec;
        this.m_StdDevPrec = matrix.m_StdDevPrec;
        this.m_ShowStdDev = matrix.m_ShowStdDev;
        this.m_ShowAverage = matrix.m_ShowAverage;
        this.m_PrintColNames = matrix.m_PrintColNames;
        this.m_PrintRowNames = matrix.m_PrintRowNames;
        this.m_EnumerateColNames = matrix.m_EnumerateColNames;
        this.m_EnumerateRowNames = matrix.m_EnumerateRowNames;
        this.m_RowNameWidth = matrix.m_RowNameWidth;
        this.m_MeanWidth = matrix.m_MeanWidth;
        this.m_StdDevWidth = matrix.m_StdDevWidth;
        this.m_SignificanceWidth = matrix.m_SignificanceWidth;
        this.m_CountWidth = matrix.m_CountWidth;
        this.m_RemoveFilterName = matrix.m_RemoveFilterName;
        this.m_HeaderKeys = (Vector)matrix.m_HeaderKeys.clone();
        this.m_HeaderValues = (Vector)matrix.m_HeaderValues.clone();
        for (i = 0; i < matrix.m_Mean.length; ++i) {
            for (n = 0; n < matrix.m_Mean[i].length; ++n) {
                this.m_Mean[i][n] = matrix.m_Mean[i][n];
                this.m_StdDev[i][n] = matrix.m_StdDev[i][n];
                this.m_Significance[i][n] = matrix.m_Significance[i][n];
            }
        }
        for (i = 0; i < matrix.m_ColNames.length; ++i) {
            this.m_ColNames[i] = matrix.m_ColNames[i];
            this.m_ColHidden[i] = matrix.m_ColHidden[i];
        }
        for (i = 0; i < matrix.m_RowNames.length; ++i) {
            this.m_RowNames[i] = matrix.m_RowNames[i];
            this.m_RowHidden[i] = matrix.m_RowHidden[i];
        }
        for (i = 0; i < matrix.m_Counts.length; ++i) {
            this.m_Counts[i] = matrix.m_Counts[i];
        }
        if (matrix.m_NonSigWins != null) {
            this.m_NonSigWins = new int[matrix.m_NonSigWins.length][];
            this.m_Wins = new int[matrix.m_NonSigWins.length][];
            for (i = 0; i < matrix.m_NonSigWins.length; ++i) {
                this.m_NonSigWins[i] = new int[matrix.m_NonSigWins[i].length];
                this.m_Wins[i] = new int[matrix.m_NonSigWins[i].length];
                for (n = 0; n < matrix.m_NonSigWins[i].length; ++n) {
                    this.m_NonSigWins[i][n] = matrix.m_NonSigWins[i][n];
                    this.m_Wins[i][n] = matrix.m_Wins[i][n];
                }
            }
        }
        if (matrix.m_RankingWins != null) {
            this.m_RankingWins = new int[matrix.m_RankingWins.length];
            this.m_RankingLosses = new int[matrix.m_RankingWins.length];
            this.m_RankingDiff = new int[matrix.m_RankingWins.length];
            for (i = 0; i < matrix.m_RankingWins.length; ++i) {
                this.m_RankingWins[i] = matrix.m_RankingWins[i];
                this.m_RankingLosses[i] = matrix.m_RankingLosses[i];
                this.m_RankingDiff[i] = matrix.m_RankingDiff[i];
            }
        }
    }

    public void clear() {
        this.m_MeanPrec = this.getDefaultMeanPrec();
        this.m_StdDevPrec = this.getDefaultStdDevPrec();
        this.m_ShowStdDev = this.getDefaultShowStdDev();
        this.m_ShowAverage = this.getDefaultShowAverage();
        this.m_RemoveFilterName = this.getDefaultRemoveFilterName();
        this.m_PrintColNames = this.getDefaultPrintColNames();
        this.m_PrintRowNames = this.getDefaultPrintRowNames();
        this.m_EnumerateColNames = this.getDefaultEnumerateColNames();
        this.m_EnumerateRowNames = this.getDefaultEnumerateRowNames();
        this.m_RowNameWidth = this.getDefaultRowNameWidth();
        this.m_ColNameWidth = this.getDefaultColNameWidth();
        this.m_MeanWidth = this.getDefaultMeanWidth();
        this.m_StdDevWidth = this.getDefaultStdDevWidth();
        this.m_SignificanceWidth = this.getDefaultSignificanceWidth();
        this.m_CountWidth = this.getDefaultCountWidth();
        this.setSize(this.getColCount(), this.getRowCount());
    }

    public void setSize(int cols, int rows) {
        int i;
        this.m_ColNames = new String[cols];
        this.m_RowNames = new String[rows];
        this.m_Counts = new double[rows];
        this.m_ColHidden = new boolean[cols];
        this.m_RowHidden = new boolean[rows];
        this.m_Mean = new double[rows][cols];
        this.m_Significance = new int[rows][cols];
        this.m_StdDev = new double[rows][cols];
        this.m_ColOrder = null;
        this.m_RowOrder = null;
        for (i = 0; i < this.m_Mean.length; ++i) {
            for (int n = 0; n < this.m_Mean[i].length; ++n) {
                this.m_Mean[i][n] = Double.NaN;
            }
        }
        for (i = 0; i < this.m_ColNames.length; ++i) {
            this.m_ColNames[i] = "col" + i;
        }
        for (i = 0; i < this.m_RowNames.length; ++i) {
            this.m_RowNames[i] = "row" + i;
        }
        this.clearHeader();
        this.clearSummary();
        this.clearRanking();
    }

    public void setMeanPrec(int prec) {
        if (prec >= 0) {
            this.m_MeanPrec = prec;
        }
    }

    public int getMeanPrec() {
        return this.m_MeanPrec;
    }

    public int getDefaultMeanPrec() {
        return 2;
    }

    public String meanPrecTipText() {
        return "The number of decimals after the decimal point for the mean.";
    }

    public void setStdDevPrec(int prec) {
        if (prec >= 0) {
            this.m_StdDevPrec = prec;
        }
    }

    public int getStdDevPrec() {
        return this.m_StdDevPrec;
    }

    public int getDefaultStdDevPrec() {
        return 2;
    }

    public String stdDevPrecTipText() {
        return "The number of decimals after the decimal point for the standard deviation.";
    }

    public void setColNameWidth(int width) {
        if (width >= 0) {
            this.m_ColNameWidth = width;
        }
    }

    public int getColNameWidth() {
        return this.m_ColNameWidth;
    }

    public int getDefaultColNameWidth() {
        return 0;
    }

    public String colNameWidthTipText() {
        return "The maximum width of the column names (0 = optimal).";
    }

    public void setRowNameWidth(int width) {
        if (width >= 0) {
            this.m_RowNameWidth = width;
        }
    }

    public int getRowNameWidth() {
        return this.m_RowNameWidth;
    }

    public int getDefaultRowNameWidth() {
        return 0;
    }

    public String rowNameWidthTipText() {
        return "The maximum width for the row names (0 = optimal).";
    }

    public void setMeanWidth(int width) {
        if (width >= 0) {
            this.m_MeanWidth = width;
        }
    }

    public int getMeanWidth() {
        return this.m_MeanWidth;
    }

    public int getDefaultMeanWidth() {
        return 0;
    }

    public String meanWidthTipText() {
        return "The width of the mean (0 = optimal).";
    }

    public void setStdDevWidth(int width) {
        if (width >= 0) {
            this.m_StdDevWidth = width;
        }
    }

    public int getStdDevWidth() {
        return this.m_StdDevWidth;
    }

    public int getDefaultStdDevWidth() {
        return 0;
    }

    public String stdDevWidthTipText() {
        return "The width of the standard deviation (0 = optimal).";
    }

    public void setSignificanceWidth(int width) {
        if (width >= 0) {
            this.m_SignificanceWidth = width;
        }
    }

    public int getSignificanceWidth() {
        return this.m_SignificanceWidth;
    }

    public int getDefaultSignificanceWidth() {
        return 0;
    }

    public String significanceWidthTipText() {
        return "The width of the significance indicator (0 = optimal).";
    }

    public void setCountWidth(int width) {
        if (width >= 0) {
            this.m_CountWidth = width;
        }
    }

    public int getCountWidth() {
        return this.m_CountWidth;
    }

    public int getDefaultCountWidth() {
        return 0;
    }

    public String countWidthTipText() {
        return "The width of the counts (0 = optimal).";
    }

    public void setShowStdDev(boolean show) {
        this.m_ShowStdDev = show;
    }

    public boolean getShowStdDev() {
        return this.m_ShowStdDev;
    }

    public boolean getDefaultShowStdDev() {
        return false;
    }

    public String showStdDevTipText() {
        return "Whether to display the standard deviation column.";
    }

    public void setShowAverage(boolean show) {
        this.m_ShowAverage = show;
    }

    public boolean getShowAverage() {
        return this.m_ShowAverage;
    }

    public boolean getDefaultShowAverage() {
        return false;
    }

    public String showAverageTipText() {
        return "Whether to show the row with averages.";
    }

    public void setRemoveFilterName(boolean remove) {
        this.m_RemoveFilterName = remove;
    }

    public boolean getRemoveFilterName() {
        return this.m_RemoveFilterName;
    }

    public boolean getDefaultRemoveFilterName() {
        return false;
    }

    public String removeFilterNameTipText() {
        return "Whether to remove the classname package prefixes from the filter names in datasets.";
    }

    public void setPrintColNames(boolean print) {
        this.m_PrintColNames = print;
        if (!print) {
            this.setEnumerateColNames(true);
        }
    }

    public boolean getPrintColNames() {
        return this.m_PrintColNames;
    }

    public boolean getDefaultPrintColNames() {
        return true;
    }

    public String printColNamesTipText() {
        return "Whether to output column names or just numbers representing them.";
    }

    public void setPrintRowNames(boolean print) {
        this.m_PrintRowNames = print;
        if (!print) {
            this.setEnumerateRowNames(true);
        }
    }

    public boolean getPrintRowNames() {
        return this.m_PrintRowNames;
    }

    public boolean getDefaultPrintRowNames() {
        return true;
    }

    public String printRowNamesTipText() {
        return "Whether to output row names or just numbers representing them.";
    }

    public void setEnumerateColNames(boolean enumerate) {
        this.m_EnumerateColNames = enumerate;
    }

    public boolean getEnumerateColNames() {
        return this.m_EnumerateColNames;
    }

    public boolean getDefaultEnumerateColNames() {
        return true;
    }

    public String enumerateColNamesTipText() {
        return "Whether to enumerate the column names (prefixing them with '(x)', with 'x' being the index).";
    }

    public void setEnumerateRowNames(boolean enumerate) {
        this.m_EnumerateRowNames = enumerate;
    }

    public boolean getEnumerateRowNames() {
        return this.m_EnumerateRowNames;
    }

    public boolean getDefaultEnumerateRowNames() {
        return false;
    }

    public String enumerateRowNamesTipText() {
        return "Whether to enumerate the row names (prefixing them with '(x)', with 'x' being the index).";
    }

    public int getColCount() {
        return this.m_ColNames.length;
    }

    public int getVisibleColCount() {
        int cols = 0;
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            ++cols;
        }
        return cols;
    }

    public int getRowCount() {
        return this.m_RowNames.length;
    }

    public int getVisibleRowCount() {
        int rows = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getRowHidden(i)) continue;
            ++rows;
        }
        return rows;
    }

    public void setColName(int index, String name) {
        if (index >= 0 && index < this.getColCount()) {
            this.m_ColNames[index] = name;
        }
    }

    public String getColName(int index) {
        String result = null;
        if (index >= 0 && index < this.getColCount()) {
            result = this.getPrintColNames() ? this.m_ColNames[index] : "";
            if (this.getEnumerateColNames()) {
                result = this.LEFT_PARENTHESES + Integer.toString(index + 1) + this.RIGHT_PARENTHESES + " " + result;
                result = result.trim();
            }
        }
        return result;
    }

    public void setRowName(int index, String name) {
        if (index >= 0 && index < this.getRowCount()) {
            this.m_RowNames[index] = name;
        }
    }

    public String getRowName(int index) {
        String result = null;
        if (index >= 0 && index < this.getRowCount()) {
            result = this.getPrintRowNames() ? this.m_RowNames[index] : "";
            if (this.getEnumerateRowNames()) {
                result = this.LEFT_PARENTHESES + Integer.toString(index + 1) + this.RIGHT_PARENTHESES + " " + result;
                result = result.trim();
            }
        }
        return result;
    }

    public void setColHidden(int index, boolean hidden) {
        if (index >= 0 && index < this.getColCount()) {
            this.m_ColHidden[index] = hidden;
        }
    }

    public boolean getColHidden(int index) {
        if (index >= 0 && index < this.getColCount()) {
            return this.m_ColHidden[index];
        }
        return false;
    }

    public void setRowHidden(int index, boolean hidden) {
        if (index >= 0 && index < this.getRowCount()) {
            this.m_RowHidden[index] = hidden;
        }
    }

    public boolean getRowHidden(int index) {
        if (index >= 0 && index < this.getRowCount()) {
            return this.m_RowHidden[index];
        }
        return false;
    }

    public void setCount(int index, double count) {
        if (index >= 0 && index < this.getRowCount()) {
            this.m_Counts[index] = count;
        }
    }

    public double getCount(int index) {
        if (index >= 0 && index < this.getRowCount()) {
            return this.m_Counts[index];
        }
        return 0.0;
    }

    public void setMean(int col, int row, double value) {
        if (col >= 0 && col < this.getColCount() && row >= 0 && row < this.getRowCount()) {
            this.m_Mean[row][col] = value;
        }
    }

    public double getMean(int col, int row) {
        if (col >= 0 && col < this.getColCount() && row >= 0 && row < this.getRowCount()) {
            return this.m_Mean[row][col];
        }
        return 0.0;
    }

    public double getAverage(int col) {
        if (col >= 0 && col < this.getColCount()) {
            double avg = 0.0;
            int count = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (Double.isNaN(this.getMean(col, i))) continue;
                avg += this.getMean(col, i);
                ++count;
            }
            return avg / (double)count;
        }
        return 0.0;
    }

    public void setStdDev(int col, int row, double value) {
        if (col >= 0 && col < this.getColCount() && row >= 0 && row < this.getRowCount()) {
            this.m_StdDev[row][col] = value;
        }
    }

    public double getStdDev(int col, int row) {
        if (col >= 0 && col < this.getColCount() && row >= 0 && row < this.getRowCount()) {
            return this.m_StdDev[row][col];
        }
        return 0.0;
    }

    public void setSignificance(int col, int row, int value) {
        if (col >= 0 && col < this.getColCount() && row >= 0 && row < this.getRowCount()) {
            this.m_Significance[row][col] = value;
        }
    }

    public int getSignificance(int col, int row) {
        if (col >= 0 && col < this.getColCount() && row >= 0 && row < this.getRowCount()) {
            return this.m_Significance[row][col];
        }
        return 0;
    }

    public int getSignificanceCount(int col, int type) {
        int result = 0;
        if (col >= 0 && col < this.getColCount()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getRowHidden(i) || Double.isNaN(this.getMean(col, i)) || this.getSignificance(col, i) != type) continue;
                ++result;
            }
        }
        return result;
    }

    public void setRowOrder(int[] order) {
        if (order == null) {
            this.m_RowOrder = null;
        } else if (order.length == this.getRowCount()) {
            this.m_RowOrder = new int[order.length];
            for (int i = 0; i < order.length; ++i) {
                this.m_RowOrder[i] = order[i];
            }
        } else {
            System.err.println("setRowOrder: length does not match (" + order.length + " <> " + this.getRowCount() + ") - ignored!");
        }
    }

    public int[] getRowOrder() {
        return this.m_RowOrder;
    }

    public int getDisplayRow(int index) {
        if (index >= 0 && index < this.getRowCount()) {
            if (this.getRowOrder() == null) {
                return index;
            }
            return this.getRowOrder()[index];
        }
        return -1;
    }

    public void setColOrder(int[] order) {
        if (order == null) {
            this.m_ColOrder = null;
        } else if (order.length == this.getColCount()) {
            this.m_ColOrder = new int[order.length];
            for (int i = 0; i < order.length; ++i) {
                this.m_ColOrder[i] = order[i];
            }
        } else {
            System.err.println("setColOrder: length does not match (" + order.length + " <> " + this.getColCount() + ") - ignored!");
        }
    }

    public int[] getColOrder() {
        return this.m_ColOrder;
    }

    public int getDisplayCol(int index) {
        if (index >= 0 && index < this.getColCount()) {
            if (this.getColOrder() == null) {
                return index;
            }
            return this.getColOrder()[index];
        }
        return -1;
    }

    protected String doubleToString(double d2, int prec) {
        int currentPrec;
        String result = Utils.doubleToString(d2, prec);
        if (prec <= 0 || Double.isInfinite(d2) || Double.isNaN(d2)) {
            return result;
        }
        if (result.indexOf(".") == -1) {
            result = result + ".";
        }
        for (int i = currentPrec = result.length() - result.indexOf(".") - 1; i < prec; ++i) {
            result = result + "0";
        }
        return result;
    }

    protected String trimString(String s, int length) {
        if (length > 0 && s.length() > length) {
            return s.substring(0, length);
        }
        return s;
    }

    protected String padString(String s, int length) {
        return this.padString(s, length, false);
    }

    protected String padString(String s, int length, boolean left) {
        String result = s;
        for (int i = s.length(); i < length; ++i) {
            result = left ? " " + result : result + " ";
        }
        if (length > 0 && result.length() > length) {
            result = result.substring(0, length);
        }
        return result;
    }

    protected int getColSize(String[][] data, int col) {
        return this.getColSize(data, col, false, false);
    }

    protected int getColSize(String[][] data, int col, boolean skipFirst, boolean skipLast) {
        int result = 0;
        if (col >= 0 && col < data[0].length) {
            for (int i = 0; i < data.length; ++i) {
                if (i == 0 && skipFirst || i == data.length - 1 && skipLast || data[i][col].length() <= result) continue;
                result = data[i][col].length();
            }
        }
        return result;
    }

    protected String removeFilterName(String s) {
        if (this.getRemoveFilterName()) {
            return s.replaceAll("-weka\\.filters\\..*", "").replaceAll("-unsupervised\\..*", "").replaceAll("-supervised\\..*", "");
        }
        return s;
    }

    protected String[][] toArray() {
        int n;
        int i;
        int ii;
        int rows = this.getVisibleRowCount();
        if (this.getShowAverage()) {
            ++rows;
        }
        int cols = this.getVisibleColCount();
        cols = this.getShowStdDev() ? (cols *= 3) : (cols *= 2);
        String[][] result = new String[rows + 2][cols + 1];
        result[0][0] = this.trimString("Dataset", this.getRowNameWidth());
        int x = 1;
        for (ii = 0; ii < this.getColCount(); ++ii) {
            i = this.getDisplayCol(ii);
            if (this.getColHidden(i)) continue;
            result[0][x] = this.trimString(this.removeFilterName(this.getColName(i)), this.getColNameWidth());
            ++x;
            if (this.getShowStdDev()) {
                result[0][x] = "";
                ++x;
            }
            result[0][x] = "";
            ++x;
        }
        int y = 1;
        for (ii = 0; ii < this.getRowCount(); ++ii) {
            i = this.getDisplayRow(ii);
            if (this.getRowHidden(i)) continue;
            result[y][0] = this.trimString(this.removeFilterName(this.getRowName(i)), this.getRowNameWidth());
            ++y;
        }
        y = 1;
        for (ii = 0; ii < this.getRowCount(); ++ii) {
            i = this.getDisplayRow(ii);
            if (this.getRowHidden(i)) continue;
            x = 1;
            for (int nn = 0; nn < this.getColCount(); ++nn) {
                n = this.getDisplayCol(nn);
                if (this.getColHidden(n)) continue;
                boolean valueExists = !Double.isNaN(this.getMean(n, i));
                result[y][x] = !valueExists ? "" : this.doubleToString(this.getMean(n, i), this.getMeanPrec());
                ++x;
                if (this.getShowStdDev()) {
                    result[y][x] = !valueExists ? "" : (Double.isInfinite(this.getStdDev(n, i)) ? "Inf" : this.doubleToString(this.getStdDev(n, i), this.getStdDevPrec()));
                    ++x;
                }
                if (!valueExists) {
                    result[y][x] = "";
                } else {
                    switch (this.getSignificance(n, i)) {
                        case 0: {
                            result[y][x] = this.TIE_STRING;
                            break;
                        }
                        case 1: {
                            result[y][x] = this.WIN_STRING;
                            break;
                        }
                        case 2: {
                            result[y][x] = this.LOSS_STRING;
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
        if (this.getShowAverage()) {
            y = result.length - 2;
            x = 0;
            result[y][0] = "Average";
            ++x;
            for (ii = 0; ii < this.getColCount(); ++ii) {
                i = this.getDisplayCol(ii);
                if (this.getColHidden(i)) continue;
                result[y][x] = this.doubleToString(this.getAverage(i), this.getMeanPrec());
                ++x;
                if (this.getShowStdDev()) {
                    result[y][x] = "";
                    ++x;
                }
                result[y][x] = "";
                ++x;
            }
        }
        y = result.length - 1;
        x = 0;
        result[y][0] = this.LEFT_PARENTHESES + this.WIN_STRING + "/" + this.TIE_STRING + "/" + this.LOSS_STRING + this.RIGHT_PARENTHESES;
        ++x;
        for (ii = 0; ii < this.getColCount(); ++ii) {
            i = this.getDisplayCol(ii);
            if (this.getColHidden(i)) continue;
            result[y][x] = "";
            ++x;
            if (this.getShowStdDev()) {
                result[y][x] = "";
                ++x;
            }
            result[y][x] = this.LEFT_PARENTHESES + this.getSignificanceCount(i, 1) + "/" + this.getSignificanceCount(i, 0) + "/" + this.getSignificanceCount(i, 2) + this.RIGHT_PARENTHESES;
            ++x;
        }
        String[][] tmpResult = new String[result.length][result[0].length - 1];
        x = 0;
        for (i = 0; i < result[0].length; ++i) {
            if (i == 3 && this.getShowStdDev() || i == 2 && !this.getShowStdDev()) continue;
            for (n = 0; n < result.length; ++n) {
                tmpResult[n][x] = result[n][i];
            }
            ++x;
        }
        result = tmpResult;
        return result;
    }

    protected boolean isRowName(int index) {
        return index == 0;
    }

    protected boolean isMean(int index) {
        if (--index == 0) {
            return true;
        }
        if (--index < 0) {
            return false;
        }
        if (this.getShowStdDev()) {
            return index % 3 == 1;
        }
        return index % 2 == 0;
    }

    protected boolean isAverage(int rowIndex) {
        if (this.getShowAverage()) {
            return this.getVisibleRowCount() + 1 == rowIndex;
        }
        return false;
    }

    protected boolean isStdDev(int index) {
        --index;
        --index;
        if (this.getShowStdDev()) {
            if (index == 0) {
                return true;
            }
            if (--index < 0) {
                return false;
            }
            return index % 3 == 1;
        }
        return false;
    }

    protected boolean isSignificance(int index) {
        --index;
        --index;
        if (this.getShowStdDev()) {
            if (--index < 0) {
                return false;
            }
            return index % 3 == 2;
        }
        if (index < 0) {
            return false;
        }
        return index % 2 == 1;
    }

    public abstract String toStringMatrix();

    public String toString() {
        return this.toStringMatrix();
    }

    public void clearHeader() {
        this.m_HeaderKeys = new Vector();
        this.m_HeaderValues = new Vector();
    }

    public void addHeader(String key, String value) {
        int pos = this.m_HeaderKeys.indexOf(key);
        if (pos > -1) {
            this.m_HeaderValues.set(pos, value);
        } else {
            this.m_HeaderKeys.add(key);
            this.m_HeaderValues.add(value);
        }
    }

    public String getHeader(String key) {
        int pos = this.m_HeaderKeys.indexOf(key);
        if (pos == 0) {
            return null;
        }
        return this.m_HeaderKeys.get(pos);
    }

    public Enumeration<String> headerKeys() {
        return this.m_HeaderKeys.elements();
    }

    public abstract String toStringHeader();

    public abstract String toStringKey();

    public void clearSummary() {
        this.m_NonSigWins = null;
        this.m_Wins = null;
    }

    public void setSummary(int[][] nonSigWins, int[][] wins) {
        this.m_NonSigWins = new int[nonSigWins.length][nonSigWins[0].length];
        this.m_Wins = new int[wins.length][wins[0].length];
        for (int i = 0; i < this.m_NonSigWins.length; ++i) {
            for (int n = 0; n < this.m_NonSigWins[i].length; ++n) {
                this.m_NonSigWins[i][n] = nonSigWins[i][n];
                this.m_Wins[i][n] = wins[i][n];
            }
        }
    }

    protected String getSummaryTitle(int col) {
        return "" + (char)(97 + col % 26);
    }

    public abstract String toStringSummary();

    public void clearRanking() {
        this.m_RankingWins = null;
        this.m_RankingLosses = null;
        this.m_RankingDiff = null;
    }

    public void setRanking(int[][] wins) {
        this.m_RankingWins = new int[wins.length];
        this.m_RankingLosses = new int[wins.length];
        this.m_RankingDiff = new int[wins.length];
        for (int i = 0; i < wins.length; ++i) {
            for (int j = 0; j < wins[i].length; ++j) {
                int n = j;
                this.m_RankingWins[n] = this.m_RankingWins[n] + wins[i][j];
                int n2 = j;
                this.m_RankingDiff[n2] = this.m_RankingDiff[n2] + wins[i][j];
                int n3 = i;
                this.m_RankingLosses[n3] = this.m_RankingLosses[n3] + wins[i][j];
                int n4 = i;
                this.m_RankingDiff[n4] = this.m_RankingDiff[n4] - wins[i][j];
            }
        }
    }

    public abstract String toStringRanking();
}

