/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class CloseableTabTitle
extends JPanel {
    private static final long serialVersionUID = 9178081197757118130L;
    private final JTabbedPane m_enclosingPane;
    private JLabel m_tabLabel;
    private TabButton m_tabButton;
    private ClosingCallback m_callback;
    private String m_closeAccelleratorText = "";

    public CloseableTabTitle(JTabbedPane pane, String closeAccelleratorText, ClosingCallback callback) {
        super(new FlowLayout(0, 0, 0));
        if (closeAccelleratorText != null) {
            this.m_closeAccelleratorText = closeAccelleratorText;
        }
        this.m_enclosingPane = pane;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.m_tabLabel = new JLabel(){
            private static final long serialVersionUID = 8515052190461050324L;

            @Override
            public String getText() {
                int index = CloseableTabTitle.this.m_enclosingPane.indexOfTabComponent(CloseableTabTitle.this);
                if (index >= 0) {
                    return CloseableTabTitle.this.m_enclosingPane.getTitleAt(index);
                }
                return null;
            }
        };
        this.add(this.m_tabLabel);
        this.m_tabLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.m_tabButton = new TabButton();
        this.add(this.m_tabButton);
        this.m_callback = callback;
        this.m_tabLabel.setEnabled(false);
    }

    public void setBold(boolean bold) {
        this.m_tabLabel.setEnabled(bold);
    }

    public void setButtonEnabled(boolean enabled) {
        this.m_tabButton.setEnabled(enabled);
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -4915800749132175968L;

        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e2) {
                    Component component = e2.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(true);
                        int i = CloseableTabTitle.this.m_enclosingPane.indexOfTabComponent(CloseableTabTitle.this);
                        if (i == CloseableTabTitle.this.m_enclosingPane.getSelectedIndex()) {
                            button.setToolTipText("close this tab " + CloseableTabTitle.this.m_closeAccelleratorText);
                        } else {
                            button.setToolTipText("close this tab");
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e2) {
                    Component component = e2.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(false);
                    }
                }
            });
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int i = CloseableTabTitle.this.m_enclosingPane.indexOfTabComponent(CloseableTabTitle.this);
            if (i >= 0 && CloseableTabTitle.this.m_callback != null) {
                CloseableTabTitle.this.m_callback.tabClosing(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (!this.isEnabled()) {
                g2.setColor(Color.GRAY);
            }
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }

    public static interface ClosingCallback {
        public void tabClosing(int var1);
    }
}

