/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import weka.classifiers.CostMatrix;
import weka.gui.ExtensionFileFilter;
import weka.gui.WekaFileChooser;

public class CostMatrixEditor
implements PropertyEditor {
    private CostMatrix m_matrix;
    private final PropertyChangeSupport m_propSupport;
    private final CustomEditor m_customEditor;
    private final WekaFileChooser m_fileChooser = new WekaFileChooser(new File(System.getProperty("user.dir")));

    public CostMatrixEditor() {
        this.m_matrix = new CostMatrix(2);
        this.m_propSupport = new PropertyChangeSupport(this);
        this.m_customEditor = new CustomEditor();
    }

    @Override
    public void setValue(Object value) {
        this.m_matrix = (CostMatrix)value;
        this.m_customEditor.matrixChanged();
    }

    @Override
    public Object getValue() {
        return this.m_matrix;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        gfx.drawString(this.m_matrix.size() + " x " + this.m_matrix.size() + " cost matrix", box.x, box.y + box.height);
    }

    @Override
    public String getJavaInitializationString() {
        return "new CostMatrix(" + this.m_matrix.size() + ")";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException("CostMatrixEditor: CostMatrix properties cannot be expressed as text");
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this.m_customEditor;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propSupport.removePropertyChangeListener(listener);
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    TableModelListener {
        static final long serialVersionUID = -2931593489871197274L;
        private final CostMatrixTableModel m_tableModel;
        private final JButton m_defaultButton;
        private final JButton m_openButton;
        private final JButton m_saveButton;
        private final JTextField m_classesField;
        private final JButton m_resizeButton;

        public CustomEditor() {
            CostMatrixEditor.this.m_fileChooser.setFileFilter(new ExtensionFileFilter(CostMatrix.FILE_EXTENSION, "Cost files"));
            CostMatrixEditor.this.m_fileChooser.setFileSelectionMode(0);
            this.m_defaultButton = new JButton("Defaults");
            this.m_openButton = new JButton("Open...");
            this.m_saveButton = new JButton("Save...");
            this.m_resizeButton = new JButton("Resize");
            this.m_classesField = new JTextField("" + CostMatrixEditor.this.m_matrix.size());
            this.m_defaultButton.addActionListener(this);
            this.m_openButton.addActionListener(this);
            this.m_saveButton.addActionListener(this);
            this.m_resizeButton.addActionListener(this);
            this.m_classesField.addActionListener(this);
            JPanel classesPanel = new JPanel();
            classesPanel.setLayout(new GridLayout(1, 2, 0, 0));
            classesPanel.add(new JLabel("Classes:", 4));
            classesPanel.add(this.m_classesField);
            JPanel rightPanel = new JPanel();
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            rightPanel.setLayout(gridBag);
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.insets = new Insets(2, 10, 2, 10);
            gbc.fill = 2;
            gridBag.setConstraints(this.m_defaultButton, gbc);
            rightPanel.add(this.m_defaultButton);
            gridBag.setConstraints(this.m_openButton, gbc);
            rightPanel.add(this.m_openButton);
            gridBag.setConstraints(this.m_saveButton, gbc);
            rightPanel.add(this.m_saveButton);
            gridBag.setConstraints(classesPanel, gbc);
            rightPanel.add(classesPanel);
            gridBag.setConstraints(this.m_resizeButton, gbc);
            rightPanel.add(this.m_resizeButton);
            JPanel fill = new JPanel();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gridBag.setConstraints(fill, gbc);
            rightPanel.add(fill);
            this.m_tableModel = new CostMatrixTableModel();
            this.m_tableModel.addTableModelListener(this);
            JTable matrixTable = new JTable(this.m_tableModel);
            this.setLayout(new BorderLayout());
            this.add((Component)matrixTable, "Center");
            this.add((Component)rightPanel, "East");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (e2.getSource() == this.m_defaultButton) {
                CostMatrixEditor.this.m_matrix.initialize();
                this.matrixChanged();
            } else if (e2.getSource() == this.m_openButton) {
                this.openMatrix();
            } else if (e2.getSource() == this.m_saveButton) {
                this.saveMatrix();
            } else if (e2.getSource() == this.m_classesField || e2.getSource() == this.m_resizeButton) {
                try {
                    int newNumClasses = Integer.parseInt(this.m_classesField.getText());
                    if (newNumClasses > 0 && newNumClasses != CostMatrixEditor.this.m_matrix.size()) {
                        CostMatrixEditor.this.setValue(new CostMatrix(newNumClasses));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent e2) {
            CostMatrixEditor.this.m_propSupport.firePropertyChange(null, null, null);
        }

        public void matrixChanged() {
            this.m_tableModel.fireTableStructureChanged();
            this.m_classesField.setText("" + CostMatrixEditor.this.m_matrix.size());
        }

        private void openMatrix() {
            int returnVal = CostMatrixEditor.this.m_fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File selectedFile = CostMatrixEditor.this.m_fileChooser.getSelectedFile();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(selectedFile));
                    CostMatrixEditor.this.m_matrix = new CostMatrix(reader);
                    ((Reader)reader).close();
                    this.matrixChanged();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error reading file '" + selectedFile.getName() + "':\n" + ex.getMessage(), "Load failed", 0);
                    System.out.println(ex.getMessage());
                }
            }
        }

        private void saveMatrix() {
            int returnVal = CostMatrixEditor.this.m_fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                File selectedFile = CostMatrixEditor.this.m_fileChooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(CostMatrix.FILE_EXTENSION)) {
                    selectedFile = new File(selectedFile.getParent(), selectedFile.getName() + CostMatrix.FILE_EXTENSION);
                }
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(selectedFile));
                    CostMatrixEditor.this.m_matrix.write(writer);
                    ((Writer)writer).close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error writing file '" + selectedFile.getName() + "':\n" + ex.getMessage(), "Save failed", 0);
                    System.out.println(ex.getMessage());
                }
            }
        }
    }

    private class CostMatrixTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = -2762326138357037181L;

        private CostMatrixTableModel() {
        }

        @Override
        public int getRowCount() {
            return CostMatrixEditor.this.m_matrix.size();
        }

        @Override
        public int getColumnCount() {
            return CostMatrixEditor.this.m_matrix.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                return CostMatrixEditor.this.m_matrix.getCell(row, column);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return new Double(0.0);
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Double val;
            try {
                val = new Double((String)aValue);
            }
            catch (Exception ex) {
                val = null;
            }
            if (val == null) {
                CostMatrixEditor.this.m_matrix.setCell(rowIndex, columnIndex, aValue);
            } else {
                CostMatrixEditor.this.m_matrix.setCell(rowIndex, columnIndex, val);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Object.class;
        }
    }
}

