/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.InheritanceUtils;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageManager;
import weka.gui.GPCIgnore;

public class GenericPropertiesCreator {
    public static final boolean VERBOSE = false;
    public static final String USE_DYNAMIC = "UseDynamic";
    protected static String CREATOR_FILE = "weka/gui/GenericPropertiesCreator.props";
    protected static String EXCLUDE_FILE = "weka/gui/GenericPropertiesCreator.excludes";
    protected static String EXCLUDE_INTERFACE = "I";
    protected static String EXCLUDE_CLASS = "C";
    protected static String EXCLUDE_SUPERCLASS = "S";
    protected static String PROPERTY_FILE = "weka/gui/GenericObjectEditor.props";
    protected String m_InputFilename;
    protected String m_OutputFilename;
    protected Properties m_InputProperties;
    protected Properties m_OutputProperties;
    protected static GenericPropertiesCreator GLOBAL_CREATOR;
    protected static Properties GLOBAL_INPUT_PROPERTIES;
    protected static Properties GLOBAL_OUTPUT_PROPERTIES;
    protected boolean m_ExplicitPropsFile;
    protected Hashtable<String, Hashtable<String, Vector<String>>> m_Excludes;

    public static Properties getGlobalOutputProperties() {
        return GLOBAL_OUTPUT_PROPERTIES;
    }

    public static Properties getGlobalInputProperties() {
        return GLOBAL_INPUT_PROPERTIES;
    }

    public static void regenerateGlobalOutputProperties() {
        if (GLOBAL_CREATOR != null) {
            try {
                GLOBAL_CREATOR.execute(false, false);
                GLOBAL_INPUT_PROPERTIES = GLOBAL_CREATOR.getInputProperties();
                GLOBAL_OUTPUT_PROPERTIES = GLOBAL_CREATOR.getOutputProperties();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public GenericPropertiesCreator() throws Exception {
        this(CREATOR_FILE);
        this.m_ExplicitPropsFile = false;
    }

    public GenericPropertiesCreator(String filename) throws Exception {
        this.m_InputFilename = filename;
        this.m_OutputFilename = PROPERTY_FILE;
        this.m_InputProperties = null;
        this.m_OutputProperties = null;
        this.m_ExplicitPropsFile = true;
        this.m_Excludes = new Hashtable();
    }

    public void setExplicitPropsFile(boolean value) {
        this.m_ExplicitPropsFile = value;
    }

    public boolean getExplicitPropsFile() {
        return this.m_ExplicitPropsFile;
    }

    public String getOutputFilename() {
        return this.m_OutputFilename;
    }

    public void setOutputFilename(String filename) {
        this.m_OutputFilename = filename;
    }

    public String getInputFilename() {
        return this.m_InputFilename;
    }

    public void setInputFilename(String filename) {
        this.m_InputFilename = filename;
        this.setExplicitPropsFile(true);
    }

    public Properties getInputProperties() {
        return this.m_InputProperties;
    }

    public Properties getOutputProperties() {
        return this.m_OutputProperties;
    }

    protected void loadInputProperties() {
        this.m_InputProperties = new Properties();
        try {
            File f = new File(this.getInputFilename());
            if (this.getExplicitPropsFile() && f.exists()) {
                this.m_InputProperties.load(new FileInputStream(this.getInputFilename()));
            } else {
                this.m_InputProperties = Utils.readProperties(this.getInputFilename());
            }
            this.m_Excludes.clear();
            Properties p = Utils.readProperties(EXCLUDE_FILE);
            Enumeration<?> enm = p.propertyNames();
            while (enm.hasMoreElements()) {
                String name = enm.nextElement().toString();
                Hashtable t = new Hashtable();
                this.m_Excludes.put(name, t);
                t.put(EXCLUDE_INTERFACE, new Vector());
                t.put(EXCLUDE_CLASS, new Vector());
                t.put(EXCLUDE_SUPERCLASS, new Vector());
                StringTokenizer tok = new StringTokenizer(p.getProperty(name), ",");
                while (tok.hasMoreTokens()) {
                    String item = tok.nextToken();
                    Vector list = new Vector();
                    if (item.startsWith(EXCLUDE_INTERFACE + ":")) {
                        list = (Vector)t.get(EXCLUDE_INTERFACE);
                    } else if (item.startsWith(EXCLUDE_CLASS + ":")) {
                        list = (Vector)t.get(EXCLUDE_CLASS);
                    } else if (item.startsWith(EXCLUDE_SUPERCLASS)) {
                        list = (Vector)t.get(EXCLUDE_SUPERCLASS);
                    }
                    list.add(item.substring(item.indexOf(":") + 1));
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public boolean useDynamic() {
        if (this.getInputProperties() == null) {
            this.loadInputProperties();
        }
        return Boolean.parseBoolean(this.getInputProperties().getProperty(USE_DYNAMIC, "true"));
    }

    protected boolean isValidClassname(String classname) {
        return classname.indexOf("$") == -1;
    }

    protected boolean isValidClassname(String key, String classname) {
        Class<?> clsCurrent;
        boolean result = true;
        try {
            clsCurrent = WekaPackageClassLoaderManager.forName(classname);
            for (Annotation a2 : clsCurrent.getAnnotations()) {
                if (!(a2 instanceof GPCIgnore)) continue;
                return false;
            }
        }
        catch (Exception ex) {
            clsCurrent = null;
        }
        if (this.m_Excludes.containsKey(key)) {
            Class<?> cls;
            int i;
            Vector<String> list;
            if (clsCurrent != null && result) {
                list = this.m_Excludes.get(key).get(EXCLUDE_INTERFACE);
                for (i = 0; i < list.size(); ++i) {
                    try {
                        cls = WekaPackageClassLoaderManager.forName(list.get(i).toString());
                        if (!InheritanceUtils.hasInterface(cls, clsCurrent)) continue;
                        result = false;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (clsCurrent != null && result) {
                list = this.m_Excludes.get(key).get(EXCLUDE_SUPERCLASS);
                for (i = 0; i < list.size(); ++i) {
                    try {
                        cls = WekaPackageClassLoaderManager.forName(list.get(i).toString());
                        if (!InheritanceUtils.isSubclass(cls, clsCurrent)) continue;
                        result = false;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (clsCurrent != null && result) {
                list = this.m_Excludes.get(key).get(EXCLUDE_CLASS);
                for (i = 0; i < list.size(); ++i) {
                    try {
                        cls = WekaPackageClassLoaderManager.forName(list.get(i).toString());
                        if (!cls.getName().equals(clsCurrent.getName())) continue;
                        result = false;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    protected void generateOutputProperties() throws Exception {
        this.m_OutputProperties = new Properties();
        Enumeration<?> keys = this.m_InputProperties.propertyNames();
        while (keys.hasMoreElements()) {
            int i;
            Vector<Object> classes;
            String key = keys.nextElement().toString();
            if (key.equals(USE_DYNAMIC)) continue;
            StringTokenizer tok = new StringTokenizer(this.m_InputProperties.getProperty(key), ",");
            HashSet<Object> names = new HashSet<Object>();
            while (tok.hasMoreTokens()) {
                String pkg = tok.nextToken().trim();
                try {
                    classes = ClassDiscovery.find(WekaPackageClassLoaderManager.forName(key), pkg);
                }
                catch (Exception e2) {
                    System.out.println("Problem with '" + key + "': " + e2);
                    classes = new Vector();
                }
                for (i = 0; i < classes.size(); ++i) {
                    if (!this.isValidClassname(((String)classes.get(i)).toString()) || !this.isValidClassname(key, ((String)classes.get(i)).toString())) continue;
                    names.add(classes.get(i));
                }
            }
            String value = "";
            classes = new Vector<Object>();
            classes.addAll(names);
            Collections.sort(classes, new ClassDiscovery.StringCompare());
            for (i = 0; i < classes.size(); ++i) {
                if (!value.equals("")) {
                    value = value + ",";
                }
                value = value + ((String)classes.get(i)).toString();
            }
            this.m_OutputProperties.setProperty(key, value);
        }
    }

    protected void storeOutputProperties() throws Exception {
        this.m_OutputProperties.store(new FileOutputStream(this.getOutputFilename()), " Customises the list of options given by the GenericObjectEditor\n# for various superclasses.");
    }

    public void execute() throws Exception {
        this.execute(true, true);
    }

    public void execute(boolean store) throws Exception {
        this.execute(store, true);
    }

    public void execute(boolean store, boolean loadInputProps) throws Exception {
        if (loadInputProps) {
            this.loadInputProperties();
        }
        this.generateOutputProperties();
        if (store) {
            this.storeOutputProperties();
        }
    }

    public static void main(String[] args) throws Exception {
        GenericPropertiesCreator c2 = null;
        if (args.length == 0) {
            c2 = new GenericPropertiesCreator();
        } else if (args.length == 1) {
            c2 = new GenericPropertiesCreator();
            c2.setOutputFilename(args[0]);
        } else if (args.length == 2) {
            c2 = new GenericPropertiesCreator(args[0]);
            c2.setOutputFilename(args[1]);
        } else {
            System.out.println("usage: " + GenericPropertiesCreator.class.getName() + " [<input.props>] [<output.props>]");
            System.exit(1);
        }
        c2.execute(true);
    }

    static {
        try {
            GenericPropertiesCreator creator;
            GLOBAL_CREATOR = creator = new GenericPropertiesCreator();
            if (creator.useDynamic() && !WekaPackageManager.m_initialPackageLoadingInProcess) {
                creator.execute(false, true);
                GLOBAL_INPUT_PROPERTIES = creator.getInputProperties();
                GLOBAL_OUTPUT_PROPERTIES = creator.getOutputProperties();
            } else {
                GLOBAL_OUTPUT_PROPERTIES = Utils.readProperties("weka/gui/GenericObjectEditor.props");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

