/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.CustomPanelSupplier;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericObjectEditorHistory;
import weka.gui.PropertyDialog;

public class PropertyPanel
extends JPanel {
    static final long serialVersionUID = 5370025273466728904L;
    private final PropertyEditor m_Editor;
    private PropertyDialog m_PD;
    private boolean m_HasCustomPanel = false;
    private JPanel m_CustomPanel;

    public PropertyPanel(PropertyEditor pe) {
        this(pe, false);
    }

    public PropertyPanel(PropertyEditor pe, boolean ignoreCustomPanel) {
        this.m_Editor = pe;
        if (!ignoreCustomPanel && this.m_Editor instanceof CustomPanelSupplier) {
            this.setLayout(new BorderLayout());
            this.m_CustomPanel = ((CustomPanelSupplier)((Object)this.m_Editor)).getCustomPanel();
            this.add((Component)this.m_CustomPanel, "Center");
            this.m_HasCustomPanel = true;
        } else {
            this.createDefaultPanel();
        }
    }

    protected void createDefaultPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setToolTipText("Left-click to edit properties for this object, right-click/Alt+Shift+left-click for menu");
        this.setOpaque(true);
        final PropertyPanel comp = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 1) {
                    if (evt.getButton() == 1 && !evt.isAltDown() && !evt.isShiftDown()) {
                        PropertyPanel.this.showPropertyDialog();
                    } else if (evt.getButton() == 3 || evt.getButton() == 1 && evt.isAltDown() && evt.isShiftDown()) {
                        JMenuItem item;
                        JPopupMenu menu = new JPopupMenu();
                        if (PropertyPanel.this.m_Editor.getValue() != null) {
                            item = new JMenuItem("Show properties...");
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e2) {
                                    PropertyPanel.this.showPropertyDialog();
                                }
                            });
                            menu.add(item);
                            item = new JMenuItem("Copy configuration to clipboard");
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e2) {
                                    Object value = PropertyPanel.this.m_Editor.getValue();
                                    String str = "";
                                    if (value.getClass().isArray()) {
                                        Object[] arr;
                                        str = str + value.getClass().getName();
                                        for (Object v : arr = (Object[])value) {
                                            String s = v.getClass().getName();
                                            if (v instanceof OptionHandler) {
                                                s = s + " " + Utils.joinOptions(((OptionHandler)v).getOptions());
                                            }
                                            str = str + " \"" + Utils.backQuoteChars(s.trim()) + "\"";
                                        }
                                    } else {
                                        str = str + value.getClass().getName();
                                        if (value instanceof OptionHandler) {
                                            str = str + " " + Utils.joinOptions(((OptionHandler)value).getOptions());
                                        }
                                    }
                                    StringSelection selection = new StringSelection(str.trim());
                                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                    clipboard.setContents(selection, selection);
                                }
                            });
                            menu.add(item);
                        }
                        item = new JMenuItem("Enter configuration...");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e2) {
                                String str = JOptionPane.showInputDialog(comp, (Object)"Configuration (<classname> [<options>])");
                                if (str != null && str.length() > 0) {
                                    try {
                                        String[] options = Utils.splitOptions(str);
                                        String classname = options[0];
                                        options[0] = "";
                                        Class<?> c2 = Utils.forName(Object.class, classname, null).getClass();
                                        if (c2.isArray()) {
                                            Object[] arr = (Object[])Array.newInstance(c2.getComponentType(), options.length - 1);
                                            for (int i = 1; i < options.length; ++i) {
                                                String[] ops = Utils.splitOptions(options[i]);
                                                String cname = ops[0];
                                                ops[0] = "";
                                                arr[i - 1] = Utils.forName(Object.class, cname, ops);
                                            }
                                            PropertyPanel.this.m_Editor.setValue(arr);
                                        } else {
                                            PropertyPanel.this.m_Editor.setValue(Utils.forName(Object.class, classname, options));
                                        }
                                    }
                                    catch (Exception ex) {
                                        JOptionPane.showMessageDialog(comp, "Error parsing commandline:\n" + ex, "Error...", 0);
                                    }
                                }
                            }
                        });
                        menu.add(item);
                        if (PropertyPanel.this.m_Editor.getValue() instanceof OptionHandler) {
                            item = new JMenuItem("Edit configuration...");
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e2) {
                                    String str = PropertyPanel.this.m_Editor.getValue().getClass().getName();
                                    str = str + " " + Utils.joinOptions(((OptionHandler)PropertyPanel.this.m_Editor.getValue()).getOptions());
                                    if ((str = JOptionPane.showInputDialog(comp, "Configuration", str)) != null && str.length() > 0) {
                                        try {
                                            String[] options = Utils.splitOptions(str);
                                            String classname = options[0];
                                            options[0] = "";
                                            PropertyPanel.this.m_Editor.setValue(Utils.forName(Object.class, classname, options));
                                        }
                                        catch (Exception ex) {
                                            JOptionPane.showMessageDialog(comp, "Error parsing commandline:\n" + ex, "Error...", 0);
                                        }
                                    }
                                }
                            });
                            menu.add(item);
                        }
                        if (PropertyPanel.this.m_Editor instanceof GenericObjectEditor) {
                            ((GenericObjectEditor)PropertyPanel.this.m_Editor).getHistory().customizePopupMenu(menu, PropertyPanel.this.m_Editor.getValue(), new GenericObjectEditorHistory.HistorySelectionListener(){

                                @Override
                                public void historySelected(GenericObjectEditorHistory.HistorySelectionEvent e2) {
                                    PropertyPanel.this.m_Editor.setValue(e2.getHistoryItem());
                                }
                            });
                        }
                        menu.show(comp, evt.getX(), evt.getY());
                    }
                }
            }
        });
        Dimension newPref = this.getPreferredSize();
        newPref.height = this.getFontMetrics(this.getFont()).getHeight() * 5 / 4;
        newPref.width = newPref.height * 5;
        this.setPreferredSize(newPref);
        this.m_Editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyPanel.this.repaint();
            }
        });
    }

    public void showPropertyDialog() {
        if (this.m_Editor.getValue() != null) {
            if (this.m_PD == null) {
                this.m_PD = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), this.m_Editor, -1, -1) : new PropertyDialog(PropertyDialog.getParentFrame(this), this.m_Editor, -1, -1);
                this.m_PD.setVisible(true);
            } else {
                if (PropertyDialog.getParentDialog(this) != null) {
                    this.m_PD.setLocationRelativeTo(PropertyDialog.getParentDialog(this));
                } else {
                    this.m_PD.setLocationRelativeTo(PropertyDialog.getParentFrame(this));
                }
                this.m_PD.setVisible(true);
            }
            this.m_Editor.setValue(this.m_Editor.getValue());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.m_PD != null) {
            this.m_PD.dispose();
            this.m_PD = null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_HasCustomPanel) {
            this.m_CustomPanel.setEnabled(enabled);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.m_HasCustomPanel) {
            Insets i = this.getInsets();
            Rectangle box = new Rectangle(i.left, i.top, this.getSize().width - i.left - i.right - 1, this.getSize().height - i.top - i.bottom - 1);
            g.clearRect(i.left, i.top, this.getSize().width - i.right - i.left, this.getSize().height - i.bottom - i.top);
            this.m_Editor.paintValue(g, box);
        }
    }

    public boolean addToHistory() {
        return this.addToHistory(this.m_Editor.getValue());
    }

    public boolean addToHistory(Object obj) {
        if (this.m_Editor instanceof GenericObjectEditor && obj != null) {
            ((GenericObjectEditor)this.m_Editor).getHistory().add(obj);
            return true;
        }
        return false;
    }
}

