/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.FlowByExpression;

public class FlowByExpressionCustomizer
extends JPanel
implements EnvironmentHandler,
BeanCustomizer,
CustomizerCloseRequester {
    private static final long serialVersionUID = -3574741335754017794L;
    protected Environment m_env = Environment.getSystemWide();
    protected BeanCustomizer.ModifyListener m_modifyL = null;
    protected FlowByExpression m_expression;
    protected JComboBox m_lhsField = new EnvironmentField.WideComboBox();
    protected JComboBox m_operatorCombo = new JComboBox();
    protected JComboBox m_rhsField = new EnvironmentField.WideComboBox();
    protected JCheckBox m_rhsIsAttribute = new JCheckBox("RHS is attribute");
    protected JLabel m_expressionLab = new JLabel();
    protected JComboBox m_trueData = new JComboBox();
    protected JComboBox m_falseData = new JComboBox();
    protected JTree m_expressionTree;
    protected DefaultMutableTreeNode m_treeRoot;
    protected JButton m_addExpressionNode = new JButton("Add Expression node");
    protected JButton m_addBracketNode = new JButton("Add bracket node");
    protected JButton m_toggleNegation = new JButton("Toggle negation");
    protected JButton m_andOr = new JButton("And/Or");
    protected JButton m_deleteNode = new JButton("Delete node");
    protected PropertySheetPanel m_tempEditor = new PropertySheetPanel();
    protected Window m_parent;

    public FlowByExpressionCustomizer() {
        this.setLayout(new BorderLayout());
    }

    private void setup() {
        JPanel aboutAndControlHolder = new JPanel();
        aboutAndControlHolder.setLayout(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        fieldHolder.setLayout(new GridLayout(0, 4));
        JPanel lhsP = new JPanel();
        lhsP.setLayout(new BorderLayout());
        lhsP.setBorder(BorderFactory.createTitledBorder("Attribute"));
        this.m_lhsField.setEditable(true);
        lhsP.add((Component)this.m_lhsField, "Center");
        lhsP.setToolTipText("<html>Name or index of attribute. also accepts<br>the special labels \"/first\" and \"/last\" to indicate<br>the first and last attribute respecitively</html>");
        this.m_lhsField.setToolTipText("<html>Name or index of attribute. also accepts<br>the special labels \"/first\" and \"/last\" to indicate<br>the first and last attribute respecitively</html>");
        JPanel operatorP = new JPanel();
        operatorP.setLayout(new BorderLayout());
        operatorP.setBorder(BorderFactory.createTitledBorder("Operator"));
        this.m_operatorCombo.addItem(" = ");
        this.m_operatorCombo.addItem(" != ");
        this.m_operatorCombo.addItem(" < ");
        this.m_operatorCombo.addItem(" <= ");
        this.m_operatorCombo.addItem(" > ");
        this.m_operatorCombo.addItem(" >= ");
        this.m_operatorCombo.addItem(" isMissing ");
        this.m_operatorCombo.addItem(" contains ");
        this.m_operatorCombo.addItem(" startsWith ");
        this.m_operatorCombo.addItem(" endsWith ");
        this.m_operatorCombo.addItem(" regex ");
        operatorP.add((Component)this.m_operatorCombo, "Center");
        JPanel rhsP = new JPanel();
        rhsP.setLayout(new BorderLayout());
        rhsP.setBorder(BorderFactory.createTitledBorder("Constant or attribute"));
        rhsP.setToolTipText("<html>Constant value to test/check for. If testing<br>against an attribute, then this specifiesan attribute index or name</html>");
        this.m_rhsField.setEditable(true);
        rhsP.add((Component)this.m_rhsField, "Center");
        fieldHolder.add(lhsP);
        fieldHolder.add(operatorP);
        fieldHolder.add(rhsP);
        fieldHolder.add(this.m_rhsIsAttribute);
        controlHolder.add((Component)fieldHolder, "South");
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BorderLayout());
        JPanel expressionP = new JPanel();
        expressionP.setLayout(new BorderLayout());
        expressionP.setBorder(BorderFactory.createTitledBorder("Expression"));
        JPanel tempE = new JPanel();
        tempE.setLayout(new BorderLayout());
        tempE.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        tempE.add((Component)this.m_expressionLab, "Center");
        JScrollPane expressionScroller = new JScrollPane(tempE);
        expressionP.add((Component)expressionScroller, "Center");
        tempPanel.add((Component)expressionP, "South");
        JPanel flowControlP = new JPanel();
        flowControlP.setLayout(new GridLayout(2, 2));
        flowControlP.add(new JLabel("Send true instances to node", 4));
        flowControlP.add(this.m_trueData);
        flowControlP.add(new JLabel("Send false instances to node", 4));
        flowControlP.add(this.m_falseData);
        tempPanel.add((Component)flowControlP, "North");
        String falseStepN = this.m_expression.getFalseStepName();
        String trueStepN = this.m_expression.getTrueStepName();
        Object[] connectedSteps = this.m_expression.m_downstream;
        this.m_trueData.addItem("<none>");
        this.m_falseData.addItem("<none>");
        if (connectedSteps != null && connectedSteps.length > 0) {
            if (connectedSteps[0] != null) {
                String first = ((BeanCommon)connectedSteps[0]).getCustomName();
                this.m_trueData.addItem(first);
                this.m_falseData.addItem(first);
            }
            if (connectedSteps.length > 1 && connectedSteps[1] != null) {
                String second = ((BeanCommon)connectedSteps[1]).getCustomName();
                this.m_trueData.addItem(second);
                this.m_falseData.addItem(second);
            }
        }
        if (falseStepN != null && falseStepN.length() > 0) {
            this.m_falseData.setSelectedItem(falseStepN);
        }
        if (trueStepN != null && trueStepN.length() > 0) {
            this.m_trueData.setSelectedItem(trueStepN);
        }
        controlHolder.add((Component)tempPanel, "North");
        aboutAndControlHolder.add((Component)controlHolder, "South");
        JPanel aboutP = this.m_tempEditor.getAboutPanel();
        aboutAndControlHolder.add((Component)aboutP, "North");
        this.add((Component)aboutAndControlHolder, "North");
        this.addButtons();
        this.m_rhsIsAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionCustomizer.this.m_expressionTree != null && (p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    ((FlowByExpression.ExpressionClause)thisNode).m_rhsIsAttribute = FlowByExpressionCustomizer.this.m_rhsIsAttribute.isSelected();
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionCustomizer.this.updateExpressionLabel();
                }
            }
        });
        this.m_operatorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionCustomizer.this.m_operatorCombo.getSelectedIndex() > 5) {
                    FlowByExpressionCustomizer.this.m_rhsIsAttribute.setSelected(false);
                    FlowByExpressionCustomizer.this.m_rhsIsAttribute.setEnabled(false);
                } else {
                    FlowByExpressionCustomizer.this.m_rhsIsAttribute.setEnabled(true);
                }
                if (FlowByExpressionCustomizer.this.m_expressionTree != null && (p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    String selection = FlowByExpressionCustomizer.this.m_operatorCombo.getSelectedItem().toString();
                    FlowByExpression.ExpressionClause.ExpressionType t = FlowByExpression.ExpressionClause.ExpressionType.EQUALS;
                    for (FlowByExpression.ExpressionClause.ExpressionType et : FlowByExpression.ExpressionClause.ExpressionType.values()) {
                        if (!et.toString().equals(selection)) continue;
                        t = et;
                        break;
                    }
                    ((FlowByExpression.ExpressionClause)thisNode).m_operator = t;
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionCustomizer.this.updateExpressionLabel();
                }
            }
        });
        this.m_lhsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object text;
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionCustomizer.this.m_expressionTree != null && (p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause && (text = FlowByExpressionCustomizer.this.m_lhsField.getSelectedItem()) != null) {
                    ((FlowByExpression.ExpressionClause)thisNode).m_lhsAttributeName = text.toString();
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionCustomizer.this.updateExpressionLabel();
                }
            }
        });
        this.m_lhsField.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionCustomizer.this.m_expressionTree != null && (p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    Component theEditor;
                    String text = "";
                    if (FlowByExpressionCustomizer.this.m_lhsField.getSelectedItem() != null) {
                        text = FlowByExpressionCustomizer.this.m_lhsField.getSelectedItem().toString();
                    }
                    if ((theEditor = FlowByExpressionCustomizer.this.m_lhsField.getEditor().getEditorComponent()) instanceof JTextField) {
                        text = ((JTextField)theEditor).getText();
                    }
                    ((FlowByExpression.ExpressionClause)thisNode).m_lhsAttributeName = text;
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionCustomizer.this.updateExpressionLabel();
                }
            }
        });
        this.m_rhsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object text;
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionCustomizer.this.m_expressionTree != null && (p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause && (text = FlowByExpressionCustomizer.this.m_rhsField.getSelectedItem()) != null) {
                    ((FlowByExpression.ExpressionClause)thisNode).m_rhsOperand = text.toString();
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionCustomizer.this.updateExpressionLabel();
                }
            }
        });
        this.m_rhsField.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionCustomizer.this.m_expressionTree != null && (p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    Component theEditor;
                    String text = "";
                    if (FlowByExpressionCustomizer.this.m_rhsField.getSelectedItem() != null) {
                        text = FlowByExpressionCustomizer.this.m_rhsField.getSelectedItem().toString();
                    }
                    if ((theEditor = FlowByExpressionCustomizer.this.m_rhsField.getEditor().getEditorComponent()) instanceof JTextField) {
                        text = ((JTextField)theEditor).getText();
                    }
                    if (FlowByExpressionCustomizer.this.m_rhsField.getSelectedItem() != null) {
                        ((FlowByExpression.ExpressionClause)thisNode).m_rhsOperand = text;
                        DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                        tmodel.nodeStructureChanged(tNode);
                        FlowByExpressionCustomizer.this.updateExpressionLabel();
                    }
                }
            }
        });
        if (this.m_expression.getConnectedFormat() != null) {
            Instances incoming = this.m_expression.getConnectedFormat();
            this.m_lhsField.removeAllItems();
            this.m_rhsField.removeAllItems();
            for (int i = 0; i < incoming.numAttributes(); ++i) {
                this.m_lhsField.addItem(incoming.attribute(i).name());
                this.m_rhsField.addItem(incoming.attribute(i).name());
            }
        }
        Dimension d2 = operatorP.getPreferredSize();
        lhsP.setPreferredSize(d2);
        rhsP.setPreferredSize(d2);
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FlowByExpressionCustomizer.this.closingOK();
                FlowByExpressionCustomizer.this.m_parent.dispose();
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FlowByExpressionCustomizer.this.closingCancel();
                FlowByExpressionCustomizer.this.m_parent.dispose();
            }
        });
    }

    private void updateExpressionLabel() {
        StringBuffer buff = new StringBuffer();
        FlowByExpression.ExpressionNode root = (FlowByExpression.ExpressionNode)this.m_treeRoot.getUserObject();
        root.toStringDisplay(buff);
        this.m_expressionLab.setText(buff.toString());
    }

    private void setExpressionEditor(FlowByExpression.ExpressionClause node) {
        String rhs;
        String lhs = node.m_lhsAttributeName;
        if (lhs != null) {
            this.m_lhsField.setSelectedItem(lhs);
        }
        if ((rhs = node.m_rhsOperand) != null) {
            this.m_rhsField.setSelectedItem(rhs);
        }
        FlowByExpression.ExpressionClause.ExpressionType opp = node.m_operator;
        int oppIndex = opp.ordinal();
        this.m_operatorCombo.setSelectedIndex(oppIndex);
        this.m_rhsIsAttribute.setSelected(node.m_rhsIsAttribute);
    }

    private void setupTree() {
        JPanel treeHolder = new JPanel();
        treeHolder.setLayout(new BorderLayout());
        treeHolder.setBorder(BorderFactory.createTitledBorder("Expression tree"));
        String expressionString = this.m_expression.getExpressionString();
        if (expressionString == null || expressionString.length() == 0) {
            expressionString = "()";
        }
        FlowByExpression.BracketNode root = new FlowByExpression.BracketNode();
        root.parseFromInternal(expressionString);
        root.setShowAndOr(false);
        this.m_treeRoot = root.toJTree(null);
        DefaultTreeModel model = new DefaultTreeModel(this.m_treeRoot);
        this.m_expressionTree = new JTree(model);
        this.m_expressionTree.setEnabled(true);
        this.m_expressionTree.setRootVisible(true);
        this.m_expressionTree.setShowsRootHandles(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.m_expressionTree.setSelectionModel(selectionModel);
        this.m_expressionTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath();
                if (p != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    FlowByExpressionCustomizer.this.setExpressionEditor((FlowByExpression.ExpressionClause)thisNode);
                }
            }
        });
        this.updateExpressionLabel();
        JScrollPane treeView = new JScrollPane(this.m_expressionTree);
        treeHolder.add((Component)treeView, "Center");
        JPanel butHolder = new JPanel();
        butHolder.add(this.m_addExpressionNode);
        butHolder.add(this.m_addBracketNode);
        butHolder.add(this.m_toggleNegation);
        butHolder.add(this.m_andOr);
        butHolder.add(this.m_deleteNode);
        treeHolder.add((Component)butHolder, "North");
        this.add((Component)treeHolder, "Center");
        Dimension d2 = treeHolder.getPreferredSize();
        treeHolder.setPreferredSize(new Dimension(d2.width, d2.height / 2));
        this.m_andOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TreePath p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        FlowByExpression.ExpressionNode thisNode;
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        thisNode.setIsOr(!(thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject()).isOr());
                        DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                        tmodel.nodeStructureChanged(tNode);
                        FlowByExpressionCustomizer.this.updateExpressionLabel();
                    }
                } else {
                    JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "Please select a node in the tree to alter the boolean operator of", "And/Or", 1);
                }
            }
        });
        this.m_toggleNegation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TreePath p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        FlowByExpression.ExpressionNode thisNode;
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        thisNode.setNegated(!(thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject()).isNegated());
                        DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                        tmodel.nodeStructureChanged(tNode);
                        FlowByExpressionCustomizer.this.updateExpressionLabel();
                    }
                } else {
                    JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "Please select a node in the tree to toggle its negation", "Toggle negation", 1);
                }
            }
        });
        this.m_deleteNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TreePath p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        if (tNode == FlowByExpressionCustomizer.this.m_treeRoot) {
                            JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "You can't delete the root of the tree!", "Delete node", 1);
                        } else {
                            FlowByExpression.ExpressionNode thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject();
                            FlowByExpression.BracketNode parentNode = (FlowByExpression.BracketNode)((DefaultMutableTreeNode)tNode.getParent()).getUserObject();
                            parentNode.removeChild(thisNode);
                            DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                            tmodel.removeNodeFromParent(tNode);
                            FlowByExpressionCustomizer.this.updateExpressionLabel();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "Please select a node in the tree to delete.", "Delete node", 1);
                }
            }
        });
        this.m_addExpressionNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TreePath p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        FlowByExpression.ExpressionNode thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject();
                        if (thisNode instanceof FlowByExpression.BracketNode) {
                            FlowByExpression.ExpressionClause newNode = new FlowByExpression.ExpressionClause(FlowByExpression.ExpressionClause.ExpressionType.EQUALS, "<att name>", "<value>", false, false);
                            ((FlowByExpression.BracketNode)thisNode).addChild(newNode);
                            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newNode);
                            DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                            tNode.add(childNode);
                            tmodel.nodeStructureChanged(tNode);
                            FlowByExpressionCustomizer.this.updateExpressionLabel();
                        } else {
                            JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "An expression can only be added to a bracket node.", "Add expression", 1);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "You must select a bracket node in the tree view to add a new expression to.", "Add expression", 1);
                }
            }
        });
        this.m_addBracketNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TreePath p = FlowByExpressionCustomizer.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        FlowByExpression.ExpressionNode thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject();
                        if (thisNode instanceof FlowByExpression.BracketNode) {
                            FlowByExpression.BracketNode newNode = new FlowByExpression.BracketNode();
                            ((FlowByExpression.BracketNode)thisNode).addChild(newNode);
                            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newNode);
                            DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionCustomizer.this.m_expressionTree.getModel();
                            tNode.add(childNode);
                            tmodel.nodeStructureChanged(tNode);
                            FlowByExpressionCustomizer.this.updateExpressionLabel();
                        } else {
                            JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "An new bracket node can only be added to an existing bracket node.", "Add bracket", 1);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(FlowByExpressionCustomizer.this, "You must select an existing bracket node in the tree in order to add a new bracket node.", "Add bracket", 1);
                }
            }
        });
    }

    @Override
    public void setObject(Object o) {
        if (o instanceof FlowByExpression) {
            this.m_expression = (FlowByExpression)o;
            this.m_tempEditor.setTarget(o);
            this.setup();
            this.setupTree();
        }
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyL = l;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    private void closingOK() {
        if (this.m_treeRoot != null) {
            FlowByExpression.ExpressionNode en = (FlowByExpression.ExpressionNode)this.m_treeRoot.getUserObject();
            StringBuffer buff = new StringBuffer();
            en.toStringInternal(buff);
            this.m_expression.setExpressionString(buff.toString());
            if (this.m_trueData.getSelectedItem() != null && this.m_trueData.getSelectedItem().toString().length() > 0) {
                this.m_expression.setTrueStepName(this.m_trueData.getSelectedItem().toString());
            }
            if (this.m_falseData.getSelectedItem() != null && this.m_falseData.getSelectedItem().toString().length() > 0) {
                this.m_expression.setFalseStepName(this.m_falseData.getSelectedItem().toString());
            }
        }
    }

    private void closingCancel() {
    }
}

