/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.SerializedObject;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.StreamThroughput;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.Visible;

@KFStep(category="Flow", toolTipText="Inner join on one or more key fields")
public class Join
extends JPanel
implements BeanCommon,
Visible,
Serializable,
DataSource,
DataSourceListener,
TrainingSetListener,
TestSetListener,
InstanceListener,
EventConstraints,
StructureProducer,
EnvironmentHandler {
    protected static final String KEY_SPEC_SEPARATOR = "@@KS@@";
    private static final long serialVersionUID = 398021880509558185L;
    protected transient Logger m_log;
    protected transient Environment m_env;
    protected boolean m_incomingBatchConnections;
    protected Object m_firstInput;
    protected Object m_secondInput;
    protected transient boolean m_firstFinished;
    protected transient boolean m_secondFinished;
    protected String m_firstInputConnectionType = "";
    protected String m_secondInputConnectionType = "";
    protected transient Queue<InstanceHolder> m_firstBuffer;
    protected transient Queue<InstanceHolder> m_secondBuffer;
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected transient Instances m_headerOne;
    protected transient Instances m_headerTwo;
    protected transient Instances m_mergedHeader;
    protected transient List<Instances> m_headerPool;
    protected transient AtomicInteger m_count;
    protected boolean m_stringAttsPresent;
    protected boolean m_runningIncrementally;
    protected int[] m_keyIndexesOne;
    protected int[] m_keyIndexesTwo;
    protected String m_keySpec = "";
    protected boolean m_busy;
    protected AtomicBoolean m_stopRequested;
    protected Map<String, Integer> m_stringAttIndexesOne;
    protected Map<String, Integer> m_stringAttIndexesTwo;
    protected boolean m_firstIsWaiting;
    protected boolean m_secondIsWaiting;
    protected BeanVisual m_visual = new BeanVisual("Join", "weka/gui/beans/icons/Join.gif", "weka/gui/beans/icons/Join.gif");
    protected ArrayList<DataSourceListener> m_dataListeners = new ArrayList();
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();
    protected transient StreamThroughput m_throughput;

    public Join() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
        this.m_stopRequested = new AtomicBoolean(false);
    }

    public String globalInfo() {
        return "Performs an inner join on two incoming datasets/instance streams (IMPORTANT: assumes that both datasets are sorted in ascending order of the key fields). If data is not sorted then usea Sorter step to sort both into ascending order of the key fields. Does not handle the case wherekeys are not unique in one or both inputs.";
    }

    public void setKeySpec(String ks) {
        this.m_keySpec = ks;
    }

    public String getKeySpec() {
        return this.m_keySpec;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_firstInput == null || this.m_secondInput == null) {
            return false;
        }
        if (eventName.equals("instance") && this.m_incomingBatchConnections) {
            return false;
        }
        return eventName.equals("instance") || this.m_incomingBatchConnections;
    }

    protected void generateMergedHeader() {
        int i;
        int i2;
        if ((this.m_keySpec == null || this.m_keySpec.length() == 0) && this.m_log != null) {
            String msg = this.statusMessagePrefix() + "ERROR: Key fields are null!";
            this.m_log.statusMessage(msg);
            this.m_log.logMessage(msg);
            this.stop();
            this.m_busy = false;
            return;
        }
        String resolvedKeySpec = this.m_keySpec;
        try {
            resolvedKeySpec = this.m_env.substitute(this.m_keySpec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] parts = resolvedKeySpec.split(KEY_SPEC_SEPARATOR);
        if (parts.length != 2 && this.m_log != null) {
            String msg = this.statusMessagePrefix() + "ERROR: Invalid key specification: " + this.m_keySpec;
            this.m_log.statusMessage(msg);
            this.m_log.logMessage(msg);
            this.stop();
            this.m_busy = false;
            return;
        }
        for (i2 = 0; i2 < 2; ++i2) {
            String rangeS = parts[i2].trim();
            Range r = new Range();
            r.setUpper(i2 == 0 ? this.m_headerOne.numAttributes() : this.m_headerTwo.numAttributes());
            try {
                r.setRanges(rangeS);
                if (i2 == 0) {
                    this.m_keyIndexesOne = r.getSelection();
                    continue;
                }
                this.m_keyIndexesTwo = r.getSelection();
                continue;
            }
            catch (IllegalArgumentException e2) {
                String[] names = rangeS.split(",");
                if (i2 == 0) {
                    this.m_keyIndexesOne = new int[names.length];
                } else {
                    this.m_keyIndexesTwo = new int[names.length];
                }
                for (int j = 0; j < names.length; ++j) {
                    Attribute anAtt;
                    String aName = names[j].trim();
                    Attribute attribute = anAtt = i2 == 0 ? this.m_headerOne.attribute(aName) : this.m_headerTwo.attribute(aName);
                    if (anAtt == null) {
                        String msg = this.statusMessagePrefix() + "ERROR: Invalid key attribute name: " + aName;
                        if (this.m_log != null) {
                            this.m_log.statusMessage(msg);
                            this.m_log.logMessage(msg);
                        } else {
                            System.err.println(msg);
                        }
                        this.stop();
                        this.m_busy = false;
                        return;
                    }
                    if (i2 == 0) {
                        this.m_keyIndexesOne[j] = anAtt.index();
                        continue;
                    }
                    this.m_keyIndexesTwo[j] = anAtt.index();
                }
            }
        }
        if ((this.m_keyIndexesOne == null || this.m_keyIndexesTwo == null) && this.m_log != null) {
            String msg = this.statusMessagePrefix() + "ERROR: Key fields are null!";
            this.m_log.statusMessage(msg);
            this.m_log.logMessage(msg);
            this.stop();
            this.m_busy = false;
            return;
        }
        if (this.m_keyIndexesOne.length != this.m_keyIndexesTwo.length && this.m_log != null) {
            String msg = this.statusMessagePrefix() + "ERROR: number of key fields are different for each input!";
            this.m_log.statusMessage(msg);
            this.m_log.logMessage(msg);
            this.stop();
            this.m_busy = false;
            return;
        }
        for (i2 = 0; i2 < this.m_keyIndexesOne.length; ++i2) {
            if (this.m_headerOne.attribute(this.m_keyIndexesOne[i2]).type() == this.m_headerTwo.attribute(this.m_keyIndexesTwo[i2]).type() || this.m_log == null) continue;
            String msg = this.statusMessagePrefix() + "ERROR: type of key corresponding key fields differ: input 1 - " + Attribute.typeToStringShort(this.m_headerOne.attribute(this.m_keyIndexesOne[i2])) + " input 2 - " + Attribute.typeToStringShort(this.m_headerTwo.attribute(this.m_keyIndexesTwo[i2]));
            this.m_log.statusMessage(msg);
            this.m_log.logMessage(msg);
            this.stop();
            this.m_busy = false;
            return;
        }
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>();
        HashSet<String> nameLookup = new HashSet<String>();
        for (i = 0; i < this.m_headerOne.numAttributes(); ++i) {
            newAtts.add((Attribute)this.m_headerOne.attribute(i).copy());
            nameLookup.add(this.m_headerOne.attribute(i).name());
        }
        for (i = 0; i < this.m_headerTwo.numAttributes(); ++i) {
            String name = this.m_headerTwo.attribute(i).name();
            if (nameLookup.contains(name)) {
                name = name + "_2";
            }
            newAtts.add(this.m_headerTwo.attribute(i).copy(name));
        }
        this.m_mergedHeader = new Instances(this.m_headerOne.relationName() + "+" + this.m_headerTwo.relationName(), newAtts, 0);
        this.m_ie.setStructure(this.m_mergedHeader);
        this.notifyInstanceListeners(this.m_ie);
        this.m_stringAttsPresent = false;
        if (this.m_mergedHeader.checkForStringAttributes()) {
            this.m_stringAttsPresent = true;
            this.m_headerPool = new ArrayList<Instances>();
            this.m_count = new AtomicInteger();
            for (i = 0; i < 10; ++i) {
                try {
                    this.m_headerPool.add((Instances)new SerializedObject(this.m_mergedHeader).getObject());
                    continue;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    protected synchronized Instance generateMergedInstance(InstanceHolder one, InstanceHolder two) {
        String valToSetInHeader;
        int i;
        double[] vals = new double[this.m_mergedHeader.numAttributes()];
        int count = 0;
        Instances currentStructure = this.m_mergedHeader;
        if (this.m_runningIncrementally && this.m_stringAttsPresent) {
            currentStructure = this.m_headerPool.get(this.m_count.getAndIncrement() % 10);
        }
        for (i = 0; i < this.m_headerOne.numAttributes(); ++i) {
            vals[count] = one.m_instance.value(i);
            if (one.m_stringVals != null && one.m_stringVals.size() > 0 && this.m_mergedHeader.attribute(count).isString()) {
                valToSetInHeader = one.m_stringVals.get(one.m_instance.attribute(i).name());
                currentStructure.attribute(count).setStringValue(valToSetInHeader);
                vals[count] = 0.0;
            }
            ++count;
        }
        for (i = 0; i < this.m_headerTwo.numAttributes(); ++i) {
            vals[count] = two.m_instance.value(i);
            if (two.m_stringVals != null && two.m_stringVals.size() > 0 && this.m_mergedHeader.attribute(count).isString()) {
                valToSetInHeader = one.m_stringVals.get(two.m_instance.attribute(i).name());
                currentStructure.attribute(count).setStringValue(valToSetInHeader);
                vals[count] = 0.0;
            }
            ++count;
        }
        DenseInstance newInst = new DenseInstance(1.0, vals);
        newInst.setDataset(currentStructure);
        return newInst;
    }

    @Override
    public synchronized void acceptInstance(InstanceEvent e2) {
        if (e2.m_formatNotificationOnly) {
            return;
        }
        this.m_busy = true;
        Object source = e2.getSource();
        if (e2.getStatus() == 0) {
            int i;
            this.m_runningIncrementally = true;
            this.m_stopRequested.set(false);
            if (!this.m_stopRequested.get() && source == this.m_firstInput && this.m_firstBuffer == null) {
                System.err.println("Allocating first buffer");
                this.m_firstFinished = false;
                this.m_firstBuffer = new LinkedList<InstanceHolder>();
                this.m_headerOne = e2.getStructure();
                this.m_stringAttIndexesOne = new HashMap<String, Integer>();
                for (i = 0; i < this.m_headerOne.numAttributes(); ++i) {
                    if (!this.m_headerOne.attribute(i).isString()) continue;
                    this.m_stringAttIndexesOne.put(this.m_headerOne.attribute(i).name(), new Integer(i));
                }
            }
            if (!this.m_stopRequested.get() && source == this.m_secondInput && this.m_secondBuffer == null) {
                System.err.println("Allocating second buffer");
                this.m_secondFinished = false;
                this.m_secondBuffer = new LinkedList<InstanceHolder>();
                this.m_headerTwo = e2.getStructure();
                this.m_stringAttIndexesTwo = new HashMap<String, Integer>();
                for (i = 0; i < this.m_headerTwo.numAttributes(); ++i) {
                    if (!this.m_headerTwo.attribute(i).isString()) continue;
                    this.m_stringAttIndexesTwo.put(this.m_headerTwo.attribute(i).name(), new Integer(i));
                }
            }
            if (this.m_stopRequested.get()) {
                return;
            }
            if (this.m_mergedHeader == null) {
                this.m_throughput = new StreamThroughput(this.statusMessagePrefix());
                if (this.m_headerOne != null && this.m_headerTwo != null && this.m_keySpec != null && this.m_keySpec.length() > 0) {
                    this.generateMergedHeader();
                }
            }
        } else {
            if (this.m_stopRequested.get()) {
                return;
            }
            Instance current = e2.getInstance();
            if (current == null || e2.getStatus() == 2) {
                if (source == this.m_firstInput) {
                    System.err.println("Finished first");
                    this.m_firstFinished = true;
                }
                if (source == this.m_secondInput) {
                    System.err.println("Finished second");
                    this.m_secondFinished = true;
                }
            }
            if (current != null) {
                if (source == this.m_firstInput) {
                    this.addToFirstBuffer(current);
                } else if (source == this.m_secondInput) {
                    this.addToSecondBuffer(current);
                }
            }
            if (source == this.m_firstInput && this.m_secondBuffer != null && this.m_secondBuffer.size() <= 100 && this.m_secondIsWaiting) {
                this.notifyAll();
                this.m_secondIsWaiting = false;
            } else if (source == this.m_secondInput && this.m_firstBuffer != null && this.m_firstBuffer.size() <= 100 && this.m_firstIsWaiting) {
                this.notifyAll();
                this.m_firstIsWaiting = false;
            }
            if (this.m_firstFinished && this.m_secondFinished && !this.m_stopRequested.get()) {
                this.clearBuffers();
                return;
            }
            if (this.m_stopRequested.get()) {
                return;
            }
            this.m_throughput.updateStart();
            Instance outputI = this.processBuffers();
            this.m_throughput.updateEnd(this.m_log);
            if (outputI != null && !this.m_stopRequested.get()) {
                this.m_ie.setStatus(1);
                this.m_ie.setInstance(outputI);
                this.notifyInstanceListeners(this.m_ie);
            }
        }
    }

    private static void copyStringAttVals(InstanceHolder holder, Map<String, Integer> stringAttIndexes) {
        for (String attName : stringAttIndexes.keySet()) {
            Attribute att = holder.m_instance.dataset().attribute(attName);
            String val = holder.m_instance.stringValue(att);
            if (holder.m_stringVals == null) {
                holder.m_stringVals = new HashMap<String, String>();
            }
            holder.m_stringVals.put(attName, val);
        }
    }

    protected synchronized void addToFirstBuffer(Instance inst) {
        if (this.m_stopRequested.get()) {
            return;
        }
        InstanceHolder newH = new InstanceHolder();
        newH.m_instance = inst;
        Join.copyStringAttVals(newH, this.m_stringAttIndexesOne);
        if (this.m_stopRequested.get()) {
            return;
        }
        this.m_firstBuffer.add(newH);
        if (this.m_firstBuffer.size() > 100 && !this.m_secondFinished) {
            try {
                this.m_firstIsWaiting = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected synchronized void addToSecondBuffer(Instance inst) {
        if (this.m_stopRequested.get()) {
            return;
        }
        InstanceHolder newH = new InstanceHolder();
        newH.m_instance = inst;
        Join.copyStringAttVals(newH, this.m_stringAttIndexesTwo);
        if (this.m_stopRequested.get()) {
            return;
        }
        this.m_secondBuffer.add(newH);
        if (this.m_secondBuffer.size() > 100 && !this.m_firstFinished) {
            try {
                this.m_secondIsWaiting = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected synchronized void clearBuffers() {
        while (this.m_firstBuffer.size() > 0 && this.m_secondBuffer.size() > 0) {
            this.m_throughput.updateStart();
            Instance newInst = this.processBuffers();
            this.m_throughput.updateEnd(this.m_log);
            if (newInst == null) continue;
            this.m_ie.setInstance(newInst);
            this.m_ie.setStatus(1);
            this.notifyInstanceListeners(this.m_ie);
        }
        this.m_ie.setInstance(null);
        this.m_ie.setStatus(2);
        this.notifyInstanceListeners(this.m_ie);
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Finished");
        }
        this.m_headerOne = null;
        this.m_headerTwo = null;
        this.m_mergedHeader = null;
        this.m_firstBuffer = null;
        this.m_secondBuffer = null;
        this.m_firstFinished = false;
        this.m_secondFinished = false;
        this.m_busy = false;
    }

    protected synchronized Instance processBuffers() {
        if (this.m_firstBuffer != null && this.m_secondBuffer != null && this.m_firstBuffer.size() > 0 && this.m_secondBuffer.size() > 0) {
            InstanceHolder secondH;
            InstanceHolder firstH;
            if (this.m_stopRequested.get()) {
                return null;
            }
            Instance first = firstH.m_instance;
            Instance second = secondH.m_instance;
            firstH = this.m_firstBuffer.peek();
            int cmp = this.compare(first, second, firstH, secondH = this.m_secondBuffer.peek());
            if (cmp == 0) {
                Instance newInst = this.generateMergedInstance(this.m_firstBuffer.remove(), this.m_secondBuffer.remove());
                return newInst;
            }
            if (cmp < 0) {
                do {
                    this.m_firstBuffer.remove();
                    if (this.m_firstBuffer.size() <= 0) continue;
                    firstH = this.m_firstBuffer.peek();
                    first = firstH.m_instance;
                    cmp = this.compare(first, second, firstH, secondH);
                } while (cmp < 0 && this.m_firstBuffer.size() > 0);
            } else {
                do {
                    this.m_secondBuffer.remove();
                    if (this.m_secondBuffer.size() <= 0) continue;
                    secondH = this.m_secondBuffer.peek();
                    second = secondH.m_instance;
                    cmp = this.compare(first, second, firstH, secondH);
                } while (cmp > 0 && this.m_secondBuffer.size() > 0);
            }
        }
        return null;
    }

    protected int compare(Instance one, Instance two, InstanceHolder oneH, InstanceHolder twoH) {
        for (int i = 0; i < this.m_keyIndexesOne.length; ++i) {
            String twoS;
            if (one.isMissing(this.m_keyIndexesOne[i]) && two.isMissing(this.m_keyIndexesTwo[i])) continue;
            if (one.isMissing(this.m_keyIndexesOne[i]) || two.isMissing(this.m_keyIndexesTwo[i])) {
                if (one.isMissing(this.m_keyIndexesOne[i])) {
                    return -1;
                }
                return 1;
            }
            if (this.m_mergedHeader.attribute(this.m_keyIndexesOne[i]).isNumeric()) {
                double v2;
                double v1 = one.value(this.m_keyIndexesOne[i]);
                if (v1 == (v2 = two.value(this.m_keyIndexesTwo[i]))) continue;
                return v1 < v2 ? -1 : 1;
            }
            if (this.m_mergedHeader.attribute(this.m_keyIndexesOne[i]).isNominal()) {
                String twoS2;
                String oneS = one.stringValue(this.m_keyIndexesOne[i]);
                int cmp = oneS.compareTo(twoS2 = two.stringValue(this.m_keyIndexesTwo[i]));
                if (cmp == 0) continue;
                return cmp;
            }
            if (!this.m_mergedHeader.attribute(this.m_keyIndexesOne[i]).isString()) continue;
            String attNameOne = this.m_mergedHeader.attribute(this.m_keyIndexesOne[i]).name();
            String attNameTwo = this.m_mergedHeader.attribute(this.m_keyIndexesTwo[i]).name();
            String oneS = oneH.m_stringVals == null || oneH.m_stringVals.size() == 0 ? one.stringValue(this.m_keyIndexesOne[i]) : oneH.m_stringVals.get(attNameOne);
            int cmp = oneS.compareTo(twoS = twoH.m_stringVals == null || twoH.m_stringVals.size() == 0 ? two.stringValue(this.m_keyIndexesTwo[i]) : twoH.m_stringVals.get(attNameTwo));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public void acceptTestSet(TestSetEvent e2) {
        DataSetEvent de = new DataSetEvent(e2.getSource(), e2.getTestSet());
        this.acceptDataSet(de);
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e2) {
        DataSetEvent de = new DataSetEvent(e2.getSource(), e2.getTrainingSet());
        this.acceptDataSet(de);
    }

    @Override
    public synchronized void acceptDataSet(DataSetEvent e2) {
        InstanceHolder tempH;
        int i;
        this.m_runningIncrementally = false;
        this.m_stopRequested.set(false);
        if (e2.getSource() == this.m_firstInput) {
            if (e2.isStructureOnly() || e2.getDataSet().numInstances() == 0) {
                this.m_headerOne = e2.getDataSet();
                return;
            }
            if (this.m_headerOne == null) {
                this.m_headerOne = new Instances(e2.getDataSet(), 0);
            }
            this.m_firstBuffer = new LinkedList<InstanceHolder>();
            for (i = 0; i < e2.getDataSet().numInstances() && !this.m_stopRequested.get(); ++i) {
                tempH = new InstanceHolder();
                tempH.m_instance = e2.getDataSet().instance(i);
                this.m_firstBuffer.add(tempH);
            }
        } else if (e2.getSource() == this.m_secondInput) {
            if (e2.isStructureOnly() || e2.getDataSet().numInstances() == 0) {
                this.m_headerTwo = e2.getDataSet();
                return;
            }
            if (this.m_headerTwo == null) {
                this.m_headerTwo = new Instances(e2.getDataSet(), 0);
            }
            this.m_secondBuffer = new LinkedList<InstanceHolder>();
            for (i = 0; i < e2.getDataSet().numInstances() && !this.m_stopRequested.get(); ++i) {
                tempH = new InstanceHolder();
                tempH.m_instance = e2.getDataSet().instance(i);
                this.m_secondBuffer.add(tempH);
            }
        }
        if (this.m_firstBuffer != null && this.m_firstBuffer.size() > 0 && this.m_secondBuffer != null && this.m_secondBuffer.size() > 0) {
            this.m_busy = true;
            this.generateMergedHeader();
            DataSetEvent dse = new DataSetEvent(this, this.m_mergedHeader);
            this.notifyDataListeners(dse);
            Instances newData = new Instances(this.m_mergedHeader, 0);
            while (!this.m_stopRequested.get() && this.m_firstBuffer.size() > 0 && this.m_secondBuffer.size() > 0) {
                Instance newI = this.processBuffers();
                if (newI == null) continue;
                newData.add(newI);
            }
            if (!this.m_stopRequested.get()) {
                dse = new DataSetEvent(this, newData);
                this.notifyDataListeners(dse);
            }
            this.m_busy = false;
            this.m_headerOne = null;
            this.m_headerTwo = null;
            this.m_mergedHeader = null;
            this.m_firstBuffer = null;
            this.m_secondBuffer = null;
        }
    }

    @Override
    public void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.add(dsl);
    }

    @Override
    public void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.remove(dsl);
    }

    @Override
    public void addInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.add(dsl);
    }

    @Override
    public void removeInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.remove(dsl);
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/Join.gif", "weka/gui/beans/icons/Join.gif");
        this.m_visual.setText("Join");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
        if (this.m_firstInput != null && this.m_firstInput instanceof BeanCommon) {
            ((BeanCommon)this.m_firstInput).stop();
        }
        if (this.m_secondInput != null && this.m_secondInput instanceof BeanCommon) {
            ((BeanCommon)this.m_secondInput).stop();
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Stopped");
        }
        this.m_busy = false;
        this.m_stopRequested.set(true);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.m_firstIsWaiting || this.m_secondIsWaiting) {
            this.notifyAll();
        }
        this.m_firstBuffer = null;
        this.m_secondBuffer = null;
        this.m_headerOne = null;
        this.m_headerTwo = null;
        this.m_firstFinished = false;
        this.m_secondFinished = false;
        this.m_mergedHeader = null;
    }

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        if (this.m_firstInput != null && this.m_secondInput != null) {
            return false;
        }
        if (this.m_firstInput == null || this.m_secondInput == null) {
            if (this.m_firstInput != null) {
                if (this.m_firstInputConnectionType.equals("instance") && !eventName.equals("instance")) {
                    return false;
                }
                return this.m_firstInputConnectionType.equals("instance") || !eventName.equals("instance");
            }
            if (this.m_secondInput != null) {
                if (this.m_secondInputConnectionType.equals("instance") && !eventName.equals("instance")) {
                    return false;
                }
                return this.m_secondInputConnectionType.equals("instance") || !eventName.equals("instance");
            }
            return true;
        }
        return false;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            if (this.m_firstInput == null) {
                this.m_firstInput = source;
                this.m_firstInputConnectionType = eventName;
            } else {
                this.m_secondInput = source;
                this.m_secondInputConnectionType = eventName;
            }
        }
        if (this.m_firstInput != null && this.m_secondInput != null) {
            this.m_incomingBatchConnections = this.m_firstInputConnectionType.length() > 0 || this.m_secondInputConnectionType.length() > 0 ? !this.m_firstInputConnectionType.equals("instance") && !this.m_secondInputConnectionType.equals("instance") : false;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (source == this.m_firstInput) {
            this.m_firstInput = null;
            this.m_firstInputConnectionType = "";
        } else if (source == this.m_secondInput) {
            this.m_secondInput = null;
            this.m_secondInputConnectionType = "";
        }
        if (this.m_firstInput != null && this.m_secondInput != null) {
            this.m_incomingBatchConnections = this.m_firstInputConnectionType.length() > 0 || this.m_secondInputConnectionType.length() > 0 ? !this.m_firstInputConnectionType.equals("instance") && !this.m_secondInputConnectionType.equals("instance") : false;
        }
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    private void notifyInstanceListeners(InstanceEvent e2) {
        for (InstanceListener il : this.m_instanceListeners) {
            il.acceptInstance(e2);
        }
    }

    private void notifyDataListeners(DataSetEvent e2) {
        for (DataSourceListener l : this.m_dataListeners) {
            l.acceptDataSet(e2);
        }
    }

    protected Instances getUpstreamStructureFirst() {
        if (this.m_firstInput != null && this.m_firstInput instanceof StructureProducer) {
            return ((StructureProducer)this.m_firstInput).getStructure(this.m_firstInputConnectionType);
        }
        return null;
    }

    protected Instances getUpstreamStructureSecond() {
        if (this.m_secondInput != null && this.m_secondInput instanceof StructureProducer) {
            return ((StructureProducer)this.m_secondInput).getStructure(this.m_secondInputConnectionType);
        }
        return null;
    }

    protected Object getFirstInput() {
        return this.m_firstInput;
    }

    protected Instances getFirstInputStructure() {
        Instances result = null;
        if (this.m_firstInput instanceof StructureProducer) {
            result = ((StructureProducer)this.m_firstInput).getStructure(this.m_firstInputConnectionType);
        }
        return result;
    }

    protected Object getSecondInput() {
        return this.m_secondInput;
    }

    protected Instances getSecondInputStructure() {
        Instances result = null;
        if (this.m_secondInput instanceof StructureProducer) {
            result = ((StructureProducer)this.m_secondInput).getStructure(this.m_secondInputConnectionType);
        }
        return result;
    }

    @Override
    public Instances getStructure(String eventName) {
        if (!eventName.equals("dataSet") && !eventName.equals("instance")) {
            return null;
        }
        if (eventName.equals("dataSet") && this.m_dataListeners.size() == 0) {
            return null;
        }
        if (eventName.equals("instance") && this.m_instanceListeners.size() == 0) {
            return null;
        }
        if (this.m_mergedHeader == null) {
            this.generateMergedHeader();
        }
        return this.m_mergedHeader;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    protected static class InstanceHolder
    implements Serializable {
        private static final long serialVersionUID = -2554438923824758088L;
        protected Instance m_instance;
        protected Map<String, String> m_stringVals;

        protected InstanceHolder() {
        }
    }
}

