/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.gui.JListHelper;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.Join;

public class JoinCustomizer
extends JPanel
implements EnvironmentHandler,
BeanCustomizer,
CustomizerCloseRequester {
    private static final long serialVersionUID = 5797383368777382010L;
    protected Environment m_env = Environment.getSystemWide();
    protected BeanCustomizer.ModifyListener m_modifyL = null;
    protected Join m_join;
    protected JComboBox m_firstKeyFields = new EnvironmentField.WideComboBox();
    protected JComboBox m_secondKeyFields = new EnvironmentField.WideComboBox();
    protected JList m_firstList = new JList();
    protected JList m_secondList = new JList();
    protected DefaultListModel m_firstListModel;
    protected DefaultListModel m_secondListModel;
    protected JButton m_addOneBut = new JButton("Add");
    protected JButton m_deleteOneBut = new JButton("Delete");
    protected JButton m_upOneBut = new JButton("Up");
    protected JButton m_downOneBut = new JButton("Down");
    protected JButton m_addTwoBut = new JButton("Add");
    protected JButton m_deleteTwoBut = new JButton("Delete");
    protected JButton m_upTwoBut = new JButton("Up");
    protected JButton m_downTwoBut = new JButton("Down");
    protected Window m_parent;
    protected PropertySheetPanel m_tempEditor = new PropertySheetPanel();

    public JoinCustomizer() {
        this.setLayout(new BorderLayout());
    }

    private void setup() {
        int i;
        Instances incoming;
        JPanel aboutAndControlHolder = new JPanel();
        aboutAndControlHolder.setLayout(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        JPanel firstSourceP = new JPanel();
        firstSourceP.setLayout(new BorderLayout());
        firstSourceP.add((Component)new JLabel("First input ", 4), "Center");
        Object firstInput = this.m_join.getFirstInput();
        String firstName = "<not connected>";
        if (firstInput != null && firstInput instanceof BeanCommon) {
            firstName = ((BeanCommon)firstInput).getCustomName();
        }
        firstSourceP.add((Component)new JLabel(firstName, 2), "East");
        JPanel secondSourceP = new JPanel();
        secondSourceP.setLayout(new BorderLayout());
        secondSourceP.add((Component)new JLabel("Second input ", 4), "Center");
        Object secondInput = this.m_join.getSecondInput();
        String secondName = "<not connected>";
        if (secondInput != null && secondInput instanceof BeanCommon) {
            secondName = ((BeanCommon)secondInput).getCustomName();
        }
        secondSourceP.add((Component)new JLabel(secondName, 2), "East");
        JPanel sourcePHolder = new JPanel();
        sourcePHolder.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        sourcePHolder.setLayout(new BorderLayout());
        sourcePHolder.add((Component)firstSourceP, "North");
        sourcePHolder.add((Component)secondSourceP, "South");
        controlHolder.add((Component)sourcePHolder, "North");
        this.m_firstList.setVisibleRowCount(5);
        this.m_secondList.setVisibleRowCount(5);
        this.m_firstKeyFields.setEditable(true);
        JPanel listOneP = new JPanel();
        this.m_deleteOneBut.setEnabled(false);
        listOneP.setLayout(new BorderLayout());
        JPanel butOneHolder = new JPanel();
        butOneHolder.setLayout(new GridLayout(1, 0));
        butOneHolder.add(this.m_addOneBut);
        butOneHolder.add(this.m_deleteOneBut);
        butOneHolder.add(this.m_upOneBut);
        butOneHolder.add(this.m_downOneBut);
        this.m_upOneBut.setEnabled(false);
        this.m_downOneBut.setEnabled(false);
        JPanel fieldsAndButsOne = new JPanel();
        fieldsAndButsOne.setLayout(new BorderLayout());
        fieldsAndButsOne.add((Component)this.m_firstKeyFields, "North");
        fieldsAndButsOne.add((Component)butOneHolder, "South");
        listOneP.add((Component)fieldsAndButsOne, "North");
        JScrollPane js1 = new JScrollPane(this.m_firstList);
        js1.setBorder(BorderFactory.createTitledBorder("First input key fields"));
        listOneP.add((Component)js1, "Center");
        controlHolder.add((Component)listOneP, "West");
        this.m_secondKeyFields.setEditable(true);
        JPanel listTwoP = new JPanel();
        this.m_deleteTwoBut.setEnabled(false);
        listTwoP.setLayout(new BorderLayout());
        JPanel butTwoHolder = new JPanel();
        butTwoHolder.setLayout(new GridLayout(1, 0));
        butTwoHolder.add(this.m_addTwoBut);
        butTwoHolder.add(this.m_deleteTwoBut);
        butTwoHolder.add(this.m_upTwoBut);
        butTwoHolder.add(this.m_downTwoBut);
        this.m_upTwoBut.setEnabled(false);
        this.m_downTwoBut.setEnabled(false);
        JPanel fieldsAndButsTwo = new JPanel();
        fieldsAndButsTwo.setLayout(new BorderLayout());
        fieldsAndButsTwo.add((Component)this.m_secondKeyFields, "North");
        fieldsAndButsTwo.add((Component)butTwoHolder, "South");
        listTwoP.add((Component)fieldsAndButsTwo, "North");
        JScrollPane js2 = new JScrollPane(this.m_secondList);
        js2.setBorder(BorderFactory.createTitledBorder("Second input key fields"));
        listTwoP.add((Component)js2, "Center");
        controlHolder.add((Component)listTwoP, "East");
        aboutAndControlHolder.add((Component)controlHolder, "South");
        JPanel aboutP = this.m_tempEditor.getAboutPanel();
        aboutAndControlHolder.add((Component)aboutP, "North");
        this.add((Component)aboutAndControlHolder, "North");
        if (this.m_join.getFirstInputStructure() != null) {
            this.m_firstKeyFields.removeAllItems();
            incoming = this.m_join.getFirstInputStructure();
            for (i = 0; i < incoming.numAttributes(); ++i) {
                this.m_firstKeyFields.addItem(incoming.attribute(i).name());
            }
        }
        if (this.m_join.getSecondInputStructure() != null) {
            this.m_secondKeyFields.removeAllItems();
            incoming = this.m_join.getSecondInputStructure();
            for (i = 0; i < incoming.numAttributes(); ++i) {
                this.m_secondKeyFields.addItem(incoming.attribute(i).name());
            }
        }
        this.m_firstList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting() && !JoinCustomizer.this.m_deleteOneBut.isEnabled()) {
                    JoinCustomizer.this.m_deleteOneBut.setEnabled(true);
                }
            }
        });
        this.m_secondList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting() && !JoinCustomizer.this.m_deleteTwoBut.isEnabled()) {
                    JoinCustomizer.this.m_deleteTwoBut.setEnabled(true);
                }
            }
        });
        this.m_addOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (JoinCustomizer.this.m_firstKeyFields.getSelectedItem() != null && JoinCustomizer.this.m_firstKeyFields.getSelectedItem().toString().length() > 0) {
                    JoinCustomizer.this.m_firstListModel.addElement(JoinCustomizer.this.m_firstKeyFields.getSelectedItem());
                    if (JoinCustomizer.this.m_firstListModel.size() > 1) {
                        JoinCustomizer.this.m_upOneBut.setEnabled(true);
                        JoinCustomizer.this.m_downOneBut.setEnabled(true);
                    }
                }
            }
        });
        this.m_addTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (JoinCustomizer.this.m_secondKeyFields.getSelectedItem() != null && JoinCustomizer.this.m_secondKeyFields.getSelectedItem().toString().length() > 0) {
                    JoinCustomizer.this.m_secondListModel.addElement(JoinCustomizer.this.m_secondKeyFields.getSelectedItem());
                    if (JoinCustomizer.this.m_secondListModel.size() > 1) {
                        JoinCustomizer.this.m_upTwoBut.setEnabled(true);
                        JoinCustomizer.this.m_downTwoBut.setEnabled(true);
                    }
                }
            }
        });
        this.m_deleteOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selected = JoinCustomizer.this.m_firstList.getSelectedIndex();
                if (selected >= 0) {
                    JoinCustomizer.this.m_firstListModel.remove(selected);
                }
                if (JoinCustomizer.this.m_firstListModel.size() <= 1) {
                    JoinCustomizer.this.m_upOneBut.setEnabled(false);
                    JoinCustomizer.this.m_downOneBut.setEnabled(false);
                }
            }
        });
        this.m_deleteTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selected = JoinCustomizer.this.m_secondList.getSelectedIndex();
                if (selected >= 0) {
                    JoinCustomizer.this.m_secondListModel.remove(selected);
                }
                if (JoinCustomizer.this.m_secondListModel.size() <= 1) {
                    JoinCustomizer.this.m_upTwoBut.setEnabled(false);
                    JoinCustomizer.this.m_downTwoBut.setEnabled(false);
                }
            }
        });
        this.m_upOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JListHelper.moveUp(JoinCustomizer.this.m_firstList);
            }
        });
        this.m_upTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JListHelper.moveUp(JoinCustomizer.this.m_secondList);
            }
        });
        this.m_downOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JListHelper.moveDown(JoinCustomizer.this.m_firstList);
            }
        });
        this.m_downTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JListHelper.moveDown(JoinCustomizer.this.m_secondList);
            }
        });
        this.addButtons();
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JoinCustomizer.this.closingOK();
                JoinCustomizer.this.m_parent.dispose();
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JoinCustomizer.this.closingCancel();
                JoinCustomizer.this.m_parent.dispose();
            }
        });
    }

    protected void initialize() {
        this.m_firstListModel = new DefaultListModel();
        this.m_secondListModel = new DefaultListModel();
        this.m_firstList.setModel(this.m_firstListModel);
        this.m_secondList.setModel(this.m_secondListModel);
        String keySpec = this.m_join.getKeySpec();
        if (keySpec != null && keySpec.length() > 0) {
            try {
                keySpec = this.m_env.substitute(keySpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] parts = keySpec.split("@@KS@@");
            if (parts.length > 0) {
                String[] firstParts;
                for (String s : firstParts = parts[0].trim().split(",")) {
                    this.m_firstListModel.addElement(s);
                }
            }
            if (parts.length > 1) {
                String[] secondParts;
                for (String s : secondParts = parts[1].trim().split(",")) {
                    this.m_secondListModel.addElement(s);
                }
            }
        }
    }

    @Override
    public void setObject(Object bean) {
        if (bean instanceof Join) {
            this.m_join = (Join)bean;
            this.m_tempEditor.setTarget(bean);
            this.setup();
            this.initialize();
        }
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyL = l;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    private void closingOK() {
        int i;
        StringBuilder b2 = new StringBuilder();
        for (i = 0; i < this.m_firstListModel.size(); ++i) {
            if (i != 0) {
                b2.append(",");
            }
            b2.append(this.m_firstListModel.get(i));
        }
        b2.append("@@KS@@");
        for (i = 0; i < this.m_secondListModel.size(); ++i) {
            if (i != 0) {
                b2.append(",");
            }
            b2.append(this.m_secondListModel.get(i));
        }
        this.m_join.setKeySpec(b2.toString());
    }

    private void closingCancel() {
    }
}

