/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import weka.core.Defaults;
import weka.core.Settings;
import weka.gui.SettingsEditor;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.gui.knowledgeflow.StepInteractiveViewer;
import weka.knowledgeflow.steps.Step;

public abstract class BaseInteractiveViewer
extends JPanel
implements StepInteractiveViewer {
    private static final long serialVersionUID = -1191494001428785466L;
    protected Step m_step;
    protected JButton m_closeBut = new JButton("Close");
    protected JPanel m_buttonHolder = new JPanel(new GridLayout());
    protected Window m_parent;
    protected MainKFPerspective m_mainPerspective;

    public BaseInteractiveViewer() {
        this.setLayout(new BorderLayout());
        JPanel tempP = new JPanel(new BorderLayout());
        tempP.add((Component)this.m_buttonHolder, "West");
        this.add((Component)tempP, "South");
        this.m_closeBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                BaseInteractiveViewer.this.close();
            }
        });
        this.addButton(this.m_closeBut);
        if (this.getDefaultSettings() != null) {
            JButton editSettings = new JButton("Settings");
            editSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        if (SettingsEditor.showSingleSettingsEditor(BaseInteractiveViewer.this.getMainKFPerspective().getMainApplication().getApplicationSettings(), BaseInteractiveViewer.this.getDefaultSettings().getID(), BaseInteractiveViewer.this.getViewerName(), BaseInteractiveViewer.this) == 0) {
                            BaseInteractiveViewer.this.applySettings(BaseInteractiveViewer.this.getSettings());
                        }
                    }
                    catch (IOException ex) {
                        BaseInteractiveViewer.this.getMainKFPerspective().getMainApplication().showErrorDialog(ex);
                    }
                }
            });
            this.addButton(editSettings);
        }
    }

    @Override
    public Settings getSettings() {
        return this.m_mainPerspective.getMainApplication().getApplicationSettings();
    }

    public void applySettings(Settings settings) {
    }

    @Override
    public void setMainKFPerspective(MainKFPerspective perspective) {
        this.m_mainPerspective = perspective;
        this.m_mainPerspective.getMainApplication().getApplicationSettings().applyDefaults(this.getDefaultSettings());
    }

    @Override
    public MainKFPerspective getMainKFPerspective() {
        return this.m_mainPerspective;
    }

    @Override
    public void setStep(Step step) {
        this.m_step = step;
    }

    public Step getStep() {
        return this.m_step;
    }

    @Override
    public void nowVisible() {
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
        this.m_parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                BaseInteractiveViewer.this.close();
            }
        });
    }

    public void addButton(JButton button) {
        this.m_buttonHolder.add(button);
    }

    private void close() {
        if (this.m_parent != null) {
            this.m_parent.dispose();
        }
        this.closePressed();
    }

    public void closePressed() {
        this.m_step = null;
        this.m_closeBut = null;
        this.m_buttonHolder = null;
        this.m_mainPerspective = null;
        this.m_parent = null;
    }

    public Defaults getDefaultSettings() {
        return null;
    }
}

