/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Defaults;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.ResultHistoryPanel;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.VisualizeUtils;
import weka.knowledgeflow.steps.DataVisualizer;

public class DataVisualizerInteractiveView
extends BaseInteractiveViewer {
    private static final long serialVersionUID = 5345799787154266282L;
    protected ResultHistoryPanel m_history;
    protected VisualizePanel m_visPanel = new VisualizePanel();
    protected JButton m_clearButton = new JButton("Clear results");
    protected JSplitPane m_splitPane;
    protected PlotData2D m_currentPlot;
    protected static final String ID = "weka.gui.knowledgeflow.steps.DataVisualizerInteractiveView";

    @Override
    public String getViewerName() {
        return "Data Visualizer";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.m_history = new ResultHistoryPanel(null);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.setDeleteListener(new ResultHistoryPanel.RDeleteListener(){

            @Override
            public void entryDeleted(String name, int index) {
                ((DataVisualizer)DataVisualizerInteractiveView.this.getStep()).getPlots().remove(index);
            }

            @Override
            public void entriesDeleted(List<String> names, List<Integer> indexes) {
                List<PlotData2D> ds = ((DataVisualizer)DataVisualizerInteractiveView.this.getStep()).getPlots();
                ArrayList<PlotData2D> toRemove = new ArrayList<PlotData2D>();
                for (int i : indexes) {
                    toRemove.add(ds.get(i));
                }
                ds.removeAll(toRemove);
            }
        });
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -5174882230278923704L;

            @Override
            public void mouseClicked(MouseEvent e2) {
                String name;
                Object plotD;
                int index = DataVisualizerInteractiveView.this.m_history.getList().locationToIndex(e2.getPoint());
                if (index != -1 && (plotD = DataVisualizerInteractiveView.this.m_history.getNamedObject(name = DataVisualizerInteractiveView.this.m_history.getNameAtIndex(index))) instanceof PlotData2D) {
                    try {
                        if (DataVisualizerInteractiveView.this.m_currentPlot != null && DataVisualizerInteractiveView.this.m_currentPlot != plotD) {
                            DataVisualizerInteractiveView.this.m_currentPlot.setXindex(DataVisualizerInteractiveView.this.m_visPanel.getXIndex());
                            DataVisualizerInteractiveView.this.m_currentPlot.setYindex(DataVisualizerInteractiveView.this.m_visPanel.getYIndex());
                            DataVisualizerInteractiveView.this.m_currentPlot.setCindex(DataVisualizerInteractiveView.this.m_visPanel.getCIndex());
                        }
                        DataVisualizerInteractiveView.this.m_currentPlot = (PlotData2D)plotD;
                        int x = DataVisualizerInteractiveView.this.m_currentPlot.getXindex();
                        int y = DataVisualizerInteractiveView.this.m_currentPlot.getYindex();
                        int c2 = DataVisualizerInteractiveView.this.m_currentPlot.getCindex();
                        if (x == y && x == 0 && DataVisualizerInteractiveView.this.m_currentPlot.getPlotInstances().numAttributes() > 1) {
                            ++y;
                        }
                        DataVisualizerInteractiveView.this.m_visPanel.setMasterPlot((PlotData2D)plotD);
                        DataVisualizerInteractiveView.this.m_visPanel.setXIndex(x);
                        DataVisualizerInteractiveView.this.m_visPanel.setYIndex(y);
                        DataVisualizerInteractiveView.this.m_visPanel.setColourIndex(c2, true);
                        DataVisualizerInteractiveView.this.m_visPanel.repaint();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e2.getSource();
                    for (int i = e2.getFirstIndex(); i <= e2.getLastIndex(); ++i) {
                        String name;
                        Object plotD;
                        if (!lm.isSelectedIndex(i)) continue;
                        if (i == -1 || (plotD = DataVisualizerInteractiveView.this.m_history.getNamedObject(name = DataVisualizerInteractiveView.this.m_history.getNameAtIndex(i))) == null || !(plotD instanceof PlotData2D)) break;
                        try {
                            if (DataVisualizerInteractiveView.this.m_currentPlot != null && DataVisualizerInteractiveView.this.m_currentPlot != plotD) {
                                DataVisualizerInteractiveView.this.m_currentPlot.setXindex(DataVisualizerInteractiveView.this.m_visPanel.getXIndex());
                                DataVisualizerInteractiveView.this.m_currentPlot.setYindex(DataVisualizerInteractiveView.this.m_visPanel.getYIndex());
                                DataVisualizerInteractiveView.this.m_currentPlot.setCindex(DataVisualizerInteractiveView.this.m_visPanel.getCIndex());
                            }
                            DataVisualizerInteractiveView.this.m_currentPlot = (PlotData2D)plotD;
                            int x = DataVisualizerInteractiveView.this.m_currentPlot.getXindex();
                            int y = DataVisualizerInteractiveView.this.m_currentPlot.getYindex();
                            int c2 = DataVisualizerInteractiveView.this.m_currentPlot.getCindex();
                            if (x == y && x == 0 && DataVisualizerInteractiveView.this.m_currentPlot.getPlotInstances().numAttributes() > 1) {
                                ++y;
                            }
                            DataVisualizerInteractiveView.this.m_visPanel.setMasterPlot((PlotData2D)plotD);
                            DataVisualizerInteractiveView.this.m_visPanel.setXIndex(x);
                            DataVisualizerInteractiveView.this.m_visPanel.setYIndex(y);
                            DataVisualizerInteractiveView.this.m_visPanel.setColourIndex(c2, true);
                            DataVisualizerInteractiveView.this.m_visPanel.repaint();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
        this.m_visPanel.setPreferredSize(new Dimension(800, 600));
        this.m_splitPane = new JSplitPane(1, this.m_history, this.m_visPanel);
        this.add((Component)this.m_splitPane, "Center");
        this.m_splitPane.setDividerLocation(200 + this.m_splitPane.getInsets().left);
        boolean first = true;
        for (PlotData2D pd : ((DataVisualizer)this.getStep()).getPlots()) {
            this.m_history.addResult(pd.getPlotName(), new StringBuffer());
            this.m_history.addObject(pd.getPlotName(), pd);
            if (first) {
                try {
                    int x = pd.getXindex();
                    int y = pd.getYindex();
                    int c2 = pd.getCindex();
                    if (x == 0 && y == 0 && pd.getPlotInstances().numAttributes() > 1) {
                        ++y;
                    }
                    this.m_visPanel.setMasterPlot(pd);
                    this.m_currentPlot = pd;
                    this.m_visPanel.setXIndex(x);
                    this.m_visPanel.setYIndex(y);
                    if (pd.getPlotInstances().classIndex() >= 0) {
                        this.m_visPanel.setColourIndex(pd.getPlotInstances().classIndex(), true);
                    } else {
                        this.m_visPanel.setColourIndex(c2, true);
                    }
                    this.m_visPanel.repaint();
                    first = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.applySettings(this.getSettings());
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DataVisualizerInteractiveView.this.m_history.clearResults();
                ((DataVisualizer)DataVisualizerInteractiveView.this.getStep()).getPlots().clear();
                DataVisualizerInteractiveView.this.m_splitPane.remove(DataVisualizerInteractiveView.this.m_visPanel);
            }
        });
    }

    @Override
    public Defaults getDefaultSettings() {
        VisualizeUtils.VisualizeDefaults d2 = new VisualizeUtils.VisualizeDefaults();
        d2.setID(ID);
        return d2;
    }

    @Override
    public void applySettings(Settings settings) {
        this.m_visPanel.applySettings(settings, ID);
        this.m_visPanel.repaint();
    }
}

