/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Settings;
import weka.core.Utils;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.gui.visualize.PrintableComponent;
import weka.knowledgeflow.steps.StripChart;

public class StripChartInteractiveView
extends BaseInteractiveViewer
implements StripChart.PlotNotificationListener {
    private static final long serialVersionUID = 7697752421621805402L;
    protected Color[] m_colorList = new Color[]{Color.green, Color.red, new Color(6, 80, 255), Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected Color m_BackgroundColor = Color.BLACK;
    protected Color m_LegendPanelBorderColor = new Color(253, 255, 61);
    protected StripPlotter m_plotPanel;
    protected final ScalePanel m_scalePanel = new ScalePanel();
    protected transient Image m_osi = null;
    protected int m_iheight;
    protected int m_iwidth;
    protected double m_max = 1.0;
    protected double m_min = 0.0;
    protected boolean m_yScaleUpdate = false;
    protected double m_oldMax;
    protected double m_oldMin;
    protected int m_xCount = 0;
    private int m_refreshWidth = 1;
    protected final Font m_labelFont = new Font("Monospaced", 0, 10);
    protected FontMetrics m_labelMetrics;
    protected final LegendPanel m_legendPanel = new LegendPanel();
    protected List<String> m_legendText = new ArrayList<String>();
    private double[] m_previousY = new double[1];

    @Override
    public void init() {
        this.m_plotPanel = new StripPlotter();
        this.m_plotPanel.setBackground(this.m_BackgroundColor);
        this.m_scalePanel.setBackground(this.m_BackgroundColor);
        this.m_legendPanel.setBackground(this.m_BackgroundColor);
        this.m_xCount = 0;
        JPanel panel = new JPanel(new BorderLayout());
        new PrintableComponent(panel);
        this.add((Component)panel, "Center");
        panel.add((Component)this.m_legendPanel, "West");
        panel.add((Component)this.m_plotPanel, "Center");
        panel.add((Component)this.m_scalePanel, "East");
        this.m_legendPanel.setMinimumSize(new Dimension(100, this.getHeight()));
        this.m_legendPanel.setPreferredSize(new Dimension(100, this.getHeight()));
        this.m_scalePanel.setMinimumSize(new Dimension(30, this.getHeight()));
        this.m_scalePanel.setPreferredSize(new Dimension(30, this.getHeight()));
        this.m_parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                super.windowClosing(e2);
                ((StripChart)StripChartInteractiveView.this.getStep()).removePlotNotificationListener(StripChartInteractiveView.this);
            }
        });
        ((StripChart)this.getStep()).addPlotNotificationListener(this);
        this.applySettings(this.getSettings());
    }

    @Override
    public void closePressed() {
        ((StripChart)this.getStep()).removePlotNotificationListener(this);
    }

    @Override
    public void nowVisible() {
        this.m_parent.setSize(600, 180);
        ((JFrame)this.m_parent).setResizable(false);
        this.m_parent.setAlwaysOnTop(true);
        this.m_parent.validate();
        int iwidth = this.m_plotPanel.getWidth();
        int iheight = this.m_plotPanel.getHeight();
        this.m_osi = this.m_plotPanel.createImage(iwidth, iheight);
        Graphics m = this.m_osi.getGraphics();
        m.setColor(this.m_BackgroundColor);
        m.fillRect(0, 0, iwidth, iheight);
        this.m_previousY[0] = -1.0;
        this.setRefreshWidth();
    }

    private int convertToPanelY(double yval) {
        int height = this.m_plotPanel.getHeight();
        double temp = (yval - this.m_min) / (this.m_max - this.m_min);
        temp *= (double)height;
        temp = (double)height - temp;
        return (int)temp;
    }

    @Override
    public String getViewerName() {
        return "Strip Chart";
    }

    @Override
    public void setLegend(List<String> legendEntries, double min, double max) {
        this.m_legendText = legendEntries;
        this.m_max = max;
        this.m_min = min;
        this.m_xCount = 0;
        this.m_legendPanel.repaint();
    }

    protected double[] preProcessDataPoint(double[] dataPoint) {
        for (double element : dataPoint) {
            if (element < this.m_min) {
                this.m_oldMin = this.m_min;
                this.m_min = element;
                this.m_yScaleUpdate = true;
            }
            if (!(element > this.m_max)) continue;
            this.m_oldMax = this.m_max;
            this.m_max = element;
            this.m_yScaleUpdate = true;
        }
        if (this.m_yScaleUpdate) {
            this.m_scalePanel.repaint();
            this.m_yScaleUpdate = false;
        }
        return dataPoint;
    }

    @Override
    public void acceptDataPoint(double[] dataPoint) {
        if (this.m_xCount % ((StripChart)this.getStep()).getRefreshFreq() != 0) {
            ++this.m_xCount;
            return;
        }
        dataPoint = this.preProcessDataPoint(dataPoint);
        if (this.m_previousY[0] == -1.0) {
            int iw = this.m_plotPanel.getWidth();
            int ih = this.m_plotPanel.getHeight();
            this.m_osi = this.m_plotPanel.createImage(iw, ih);
            Graphics m = this.m_osi.getGraphics();
            m.setColor(this.m_BackgroundColor);
            m.fillRect(0, 0, iw, ih);
            this.m_previousY[0] = this.convertToPanelY(0.0);
            this.m_iheight = ih;
            this.m_iwidth = iw;
        }
        if (dataPoint.length != this.m_previousY.length) {
            this.m_previousY = new double[dataPoint.length];
            for (int i = 0; i < dataPoint.length; ++i) {
                this.m_previousY[i] = this.convertToPanelY(0.0);
            }
        }
        Graphics osg = this.m_osi.getGraphics();
        Graphics g = this.m_plotPanel.getGraphics();
        if (g == null) {
            return;
        }
        osg.copyArea(this.m_refreshWidth, 0, this.m_iwidth - this.m_refreshWidth, this.m_iheight, -this.m_refreshWidth, 0);
        osg.setColor(this.m_BackgroundColor);
        osg.fillRect(this.m_iwidth - this.m_refreshWidth, 0, this.m_iwidth, this.m_iheight);
        if (this.m_yScaleUpdate) {
            String maxVal = StripChartInteractiveView.numToString(this.m_oldMax);
            String minVal = StripChartInteractiveView.numToString(this.m_oldMin);
            String midVal = StripChartInteractiveView.numToString((this.m_oldMax - this.m_oldMin) / 2.0);
            if (this.m_labelMetrics == null) {
                this.m_labelMetrics = g.getFontMetrics(this.m_labelFont);
            }
            osg.setFont(this.m_labelFont);
            int wmx = this.m_labelMetrics.stringWidth(maxVal);
            int wmn = this.m_labelMetrics.stringWidth(minVal);
            int wmd = this.m_labelMetrics.stringWidth(midVal);
            int hf = this.m_labelMetrics.getAscent();
            osg.setColor(this.m_colorList[this.m_colorList.length - 1]);
            osg.drawString(maxVal, this.m_iwidth - wmx, hf - 2);
            osg.drawString(midVal, this.m_iwidth - wmd, this.m_iheight / 2 + hf / 2);
            osg.drawString(minVal, this.m_iwidth - wmn, this.m_iheight - 1);
            this.m_yScaleUpdate = false;
        }
        for (int i = 0; i < dataPoint.length; ++i) {
            int hf;
            if (Utils.isMissingValue(dataPoint[i])) continue;
            osg.setColor(this.m_colorList[i % this.m_colorList.length]);
            double pos = this.convertToPanelY(dataPoint[i]);
            osg.drawLine(this.m_iwidth - this.m_refreshWidth, (int)this.m_previousY[i], this.m_iwidth - 1, (int)pos);
            this.m_previousY[i] = pos;
            if (this.m_xCount % ((StripChart)this.getStep()).getXLabelFreq() != 0) continue;
            String val = StripChartInteractiveView.numToString(dataPoint[i]);
            if (this.m_labelMetrics == null) {
                this.m_labelMetrics = g.getFontMetrics(this.m_labelFont);
            }
            if (pos - (double)(hf = this.m_labelMetrics.getAscent()) < 0.0) {
                pos += (double)hf;
            }
            int w = this.m_labelMetrics.stringWidth(val);
            osg.setFont(this.m_labelFont);
            osg.drawString(val, this.m_iwidth - w, (int)pos);
        }
        if (this.m_xCount % ((StripChart)this.getStep()).getXLabelFreq() == 0) {
            String xVal = "" + this.m_xCount;
            osg.setColor(this.m_colorList[this.m_colorList.length - 1]);
            int w = this.m_labelMetrics.stringWidth(xVal);
            osg.setFont(this.m_labelFont);
            osg.drawString(xVal, this.m_iwidth - w, this.m_iheight - 1);
        }
        g.drawImage(this.m_osi, 0, 0, this.m_plotPanel);
        ++this.m_xCount;
    }

    private void setRefreshWidth() {
        this.m_refreshWidth = ((StripChart)this.getStep()).getRefreshWidth();
        if (this.m_labelMetrics == null) {
            this.getGraphics().setFont(this.m_labelFont);
            this.m_labelMetrics = this.getGraphics().getFontMetrics(this.m_labelFont);
        }
        int refWidth = this.m_labelMetrics.stringWidth("99000");
        int z = ((StripChart)this.getStep()).getXLabelFreq() / ((StripChart)this.getStep()).getRefreshFreq();
        if (z < 1) {
            z = 1;
        }
        if (z * this.m_refreshWidth < refWidth + 5) {
            this.m_refreshWidth *= (refWidth + 5) / z + 1;
        }
    }

    private static String numToString(double num) {
        int precision = 1;
        int whole = (int)Math.abs(num);
        double decimal = Math.abs(num) - (double)whole;
        int nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
        int n = precision = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(num)) / Math.log(10.0)) + 2 : 1;
        if (precision > 5) {
            precision = 1;
        }
        String numString = Utils.doubleToString(num, nondecimal + 1 + precision, precision);
        return numString;
    }

    @Override
    public Defaults getDefaultSettings() {
        return new StripChartInteractiveViewDefaults();
    }

    @Override
    public void applySettings(Settings settings) {
        this.m_BackgroundColor = settings.getSetting("weka.gui.knowledgeflow.steps.stripchart", StripChartInteractiveViewDefaults.BACKGROUND_COLOR_KEY, StripChartInteractiveViewDefaults.BACKGROUND_COLOR, Environment.getSystemWide());
        this.m_plotPanel.setBackground(this.m_BackgroundColor);
        this.m_scalePanel.setBackground(this.m_BackgroundColor);
        this.m_legendPanel.setBackground(this.m_BackgroundColor);
        this.m_LegendPanelBorderColor = settings.getSetting("weka.gui.knowledgeflow.steps.stripchart", StripChartInteractiveViewDefaults.LEGEND_BORDER_COLOR_KEY, StripChartInteractiveViewDefaults.LEGEND_BORDER_COLOR, Environment.getSystemWide());
        Font lf = new Font("Monospaced", 0, 12);
        this.m_legendPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.gray, Color.darkGray), "Legend", 2, 0, lf, this.m_LegendPanelBorderColor));
        this.m_colorList[this.m_colorList.length - 1] = settings.getSetting("weka.gui.knowledgeflow.steps.stripchart", StripChartInteractiveViewDefaults.X_LABEL_COLOR_KEY, StripChartInteractiveViewDefaults.X_LABEL_COLOR, Environment.getSystemWide());
    }

    protected static final class StripChartInteractiveViewDefaults
    extends Defaults {
        public static final String ID = "weka.gui.knowledgeflow.steps.stripchart";
        protected static final Settings.SettingKey BACKGROUND_COLOR_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.stripchart.outputBackgroundColor", "Output background color", "Output background color");
        protected static final Color BACKGROUND_COLOR = Color.black;
        protected static final Settings.SettingKey LEGEND_BORDER_COLOR_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.stripchart.legendBorderColor", "Legend border color", "Legend border color");
        protected static final Color LEGEND_BORDER_COLOR = new Color(253, 255, 61);
        protected static final Settings.SettingKey X_LABEL_COLOR_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.stripchart.xLabelColor", "Color for x label text", "Color for x label text");
        protected static final Color X_LABEL_COLOR = Color.white;
        private static final long serialVersionUID = 2247370679260844812L;

        public StripChartInteractiveViewDefaults() {
            super(ID);
            this.m_defaults.put(BACKGROUND_COLOR_KEY, BACKGROUND_COLOR);
            this.m_defaults.put(LEGEND_BORDER_COLOR_KEY, LEGEND_BORDER_COLOR);
            this.m_defaults.put(X_LABEL_COLOR_KEY, X_LABEL_COLOR);
        }
    }

    protected class LegendPanel
    extends JPanel {
        private static final long serialVersionUID = 7713986576833797583L;

        protected LegendPanel() {
        }

        @Override
        public void paintComponent(Graphics gx) {
            super.paintComponent(gx);
            if (StripChartInteractiveView.this.m_labelMetrics == null) {
                StripChartInteractiveView.this.m_labelMetrics = gx.getFontMetrics(StripChartInteractiveView.this.m_labelFont);
            }
            int hf = StripChartInteractiveView.this.m_labelMetrics.getAscent();
            int x = 10;
            int y = hf + 15;
            gx.setFont(StripChartInteractiveView.this.m_labelFont);
            for (int i = 0; i < StripChartInteractiveView.this.m_legendText.size(); ++i) {
                String temp = StripChartInteractiveView.this.m_legendText.get(i);
                gx.setColor(StripChartInteractiveView.this.m_colorList[i % StripChartInteractiveView.this.m_colorList.length]);
                gx.drawString(temp, x, y);
                y += hf;
            }
            StripChartInteractiveView.this.revalidate();
        }
    }

    private class ScalePanel
    extends JPanel {
        private static final long serialVersionUID = 6416998474984829434L;

        private ScalePanel() {
        }

        @Override
        public void paintComponent(Graphics gx) {
            super.paintComponent(gx);
            if (StripChartInteractiveView.this.m_labelMetrics == null) {
                StripChartInteractiveView.this.m_labelMetrics = gx.getFontMetrics(StripChartInteractiveView.this.m_labelFont);
            }
            gx.setFont(StripChartInteractiveView.this.m_labelFont);
            int hf = StripChartInteractiveView.this.m_labelMetrics.getAscent();
            String temp = "" + StripChartInteractiveView.this.m_max;
            gx.setColor(StripChartInteractiveView.this.m_colorList[StripChartInteractiveView.this.m_colorList.length - 1]);
            gx.drawString(temp, 1, hf - 2);
            temp = "" + (StripChartInteractiveView.this.m_min + (StripChartInteractiveView.this.m_max - StripChartInteractiveView.this.m_min) / 2.0);
            gx.drawString(temp, 1, this.getHeight() / 2 + hf / 2);
            temp = "" + StripChartInteractiveView.this.m_min;
            gx.drawString(temp, 1, this.getHeight() - 1);
        }
    }

    private class StripPlotter
    extends JPanel {
        private static final long serialVersionUID = -7056271598761675879L;

        private StripPlotter() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (StripChartInteractiveView.this.m_osi != null) {
                g.drawImage(StripChartInteractiveView.this.m_osi, 0, 0, this);
            }
        }
    }
}

