/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.simplecli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weka.core.PluginManager;
import weka.core.Utils;
import weka.gui.SimpleCLIPanel;

public abstract class AbstractCommand
implements Serializable,
Comparable<AbstractCommand> {
    protected SimpleCLIPanel m_Owner;
    protected static List<AbstractCommand> m_Commands;

    public void setOwner(SimpleCLIPanel value) {
        this.m_Owner = value;
    }

    public SimpleCLIPanel getOwner() {
        return this.m_Owner;
    }

    public abstract String getName();

    public abstract String getHelp();

    public abstract String getParameterHelp();

    protected abstract void doExecute(String[] var1) throws Exception;

    protected String expandVars(String s) throws Exception {
        int lastPos;
        String result = s;
        int pos = -1;
        while ((pos = result.indexOf("${", lastPos = pos)) != -1) {
            if (lastPos == pos) {
                throw new Exception("Failed to expand variables in string: " + s);
            }
            int endPos = result.indexOf("}", pos);
            if (endPos == -1) {
                throw new Exception("Failed to expand variables in string: " + s);
            }
            String var = result.substring(pos + 2, endPos);
            if (var.startsWith("env.")) {
                if (System.getenv(var = var.substring(4)) != null) {
                    result = result.substring(0, pos) + System.getenv(var) + result.substring(endPos + 1);
                    continue;
                }
                throw new Exception("Unknown environment variable: " + var);
            }
            if (this.m_Owner.getVariables().containsKey(var)) {
                result = result.substring(0, pos) + this.m_Owner.getVariables().get(var) + result.substring(endPos + 1);
                continue;
            }
            throw new Exception("Unknown variable: " + var);
        }
        return result;
    }

    public void execute(String[] params) throws Exception {
        if (this.m_Owner == null) {
            throw new Exception("No SimpleCLI owner set!");
        }
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.expandVars(params[i]);
        }
        this.doExecute(params);
        this.m_Owner = null;
    }

    @Override
    public int compareTo(AbstractCommand o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractCommand && this.compareTo((AbstractCommand)obj) == 0;
    }

    public static synchronized List<AbstractCommand> getCommands() {
        if (m_Commands == null) {
            List<String> classes = PluginManager.getPluginNamesOfTypeList(AbstractCommand.class.getName());
            ArrayList<AbstractCommand> cmds = new ArrayList<AbstractCommand>();
            for (String cls : classes) {
                try {
                    AbstractCommand cmd = (AbstractCommand)Utils.forName(AbstractCommand.class, cls, new String[0]);
                    cmds.add(cmd);
                }
                catch (Exception e2) {
                    System.err.println("Failed to instantiate SimpleCLI command: " + cls);
                    e2.printStackTrace();
                }
            }
            Collections.sort(cmds);
            m_Commands = cmds;
        }
        return m_Commands;
    }

    public static AbstractCommand getCommand(String name) {
        AbstractCommand result = null;
        for (AbstractCommand c2 : AbstractCommand.getCommands()) {
            if (!c2.getName().equals(name)) continue;
            result = c2;
            break;
        }
        return result;
    }
}

