/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;

public class InstanceTable
extends JPanel
implements InstanceListener {
    private static final long serialVersionUID = -2462533698100834803L;
    private final JTable m_InstanceTable;
    private boolean m_Debug;
    private Instances m_Instances;

    public void inputFormat(Instances instanceInfo) {
        if (this.m_Debug) {
            System.err.println("InstanceTable::inputFormat()\n" + instanceInfo.toString());
        }
        this.m_Instances = instanceInfo;
    }

    public void input(Instance instance) throws Exception {
        if (this.m_Debug) {
            System.err.println("InstanceTable::input(" + instance + ")");
        }
        this.m_Instances.add(instance);
    }

    public void batchFinished() {
        AbstractTableModel newModel = new AbstractTableModel(){
            private static final long serialVersionUID = 5447106383000555291L;

            @Override
            public String getColumnName(int col) {
                return InstanceTable.this.m_Instances.attribute(col).name();
            }

            @Override
            public Class<?> getColumnClass(int col) {
                return "".getClass();
            }

            @Override
            public int getColumnCount() {
                return InstanceTable.this.m_Instances.numAttributes();
            }

            @Override
            public int getRowCount() {
                return InstanceTable.this.m_Instances.numInstances();
            }

            @Override
            public Object getValueAt(int row, int col) {
                return new String(InstanceTable.this.m_Instances.instance(row).toString(col));
            }
        };
        this.m_InstanceTable.setModel(newModel);
        if (this.m_Debug) {
            System.err.println("InstanceTable::batchFinished()");
        }
    }

    public InstanceTable() {
        this.setLayout(new BorderLayout());
        this.m_InstanceTable = new JTable();
        this.add("Center", new JScrollPane(this.m_InstanceTable));
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    @Override
    public void instanceProduced(InstanceEvent e2) {
        Object source = e2.getSource();
        if (source instanceof InstanceProducer) {
            try {
                InstanceProducer a2 = (InstanceProducer)source;
                switch (e2.getID()) {
                    case 1: {
                        this.inputFormat(a2.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(a2.outputPeek());
                        break;
                    }
                    case 3: {
                        this.batchFinished();
                        break;
                    }
                    default: {
                        System.err.println("InstanceTable::instanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            System.err.println("InstanceTable::instanceProduced() - Unknown source object type");
        }
    }
}

