/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.io.File;
import javax.swing.JComponent;

public abstract class JComponentWriter {
    protected static final boolean DEBUG = false;
    private JComponent component;
    private File outputFile;
    protected double m_xScale;
    protected double m_yScale;
    protected boolean m_ScalingEnabled;
    protected boolean m_UseCustomDimensions;
    protected int m_CustomWidth;
    protected int m_CustomHeight;

    public JComponentWriter() {
        this(null);
    }

    public JComponentWriter(JComponent c2) {
        this(c2, null);
    }

    public JComponentWriter(JComponent c2, File f) {
        this.component = c2;
        this.outputFile = f;
        this.initialize();
    }

    protected void initialize() {
        this.m_xScale = 1.0;
        this.m_yScale = 1.0;
        this.m_ScalingEnabled = true;
        this.m_UseCustomDimensions = false;
        this.m_CustomWidth = -1;
        this.m_CustomHeight = -1;
    }

    public void setComponent(JComponent c2) {
        this.component = c2;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setFile(File f) {
        this.outputFile = f;
    }

    public File getFile() {
        return this.outputFile;
    }

    public abstract String getDescription();

    public abstract String getExtension();

    public boolean getScalingEnabled() {
        return this.m_ScalingEnabled;
    }

    public void setScalingEnabled(boolean enabled) {
        this.m_ScalingEnabled = enabled;
    }

    public void setScale(double x, double y) {
        if (this.getScalingEnabled()) {
            this.m_xScale = x;
            this.m_yScale = y;
        } else {
            this.m_xScale = 1.0;
            this.m_yScale = 1.0;
        }
    }

    public double getXScale() {
        return this.m_xScale;
    }

    public double getYScale() {
        return this.m_xScale;
    }

    public boolean getUseCustomDimensions() {
        return this.m_UseCustomDimensions;
    }

    public void setUseCustomDimensions(boolean value) {
        this.m_UseCustomDimensions = value;
    }

    public void setCustomWidth(int value) {
        this.m_CustomWidth = value;
    }

    public int getCustomWidth() {
        return this.m_CustomWidth;
    }

    public void setCustomHeight(int value) {
        this.m_CustomHeight = value;
    }

    public int getCustomHeight() {
        return this.m_CustomHeight;
    }

    protected abstract void generateOutput() throws Exception;

    public void toOutput() throws Exception {
        if (this.getFile() == null) {
            throw new Exception("The file is not set!");
        }
        if (this.getComponent() == null) {
            throw new Exception("The component is not set!");
        }
        int oldWidth = this.getComponent().getWidth();
        int oldHeight = this.getComponent().getHeight();
        if (this.getUseCustomDimensions()) {
            this.getComponent().setSize(this.getCustomWidth(), this.getCustomHeight());
        }
        this.generateOutput();
        if (this.getUseCustomDimensions()) {
            this.getComponent().setSize(oldWidth, oldHeight);
        }
    }

    public static void toOutput(JComponentWriter writer, JComponent comp, File file) throws Exception {
        JComponentWriter.toOutput(writer, comp, file, -1, -1);
    }

    public static void toOutput(JComponentWriter writer, JComponent comp, File file, int width, int height) throws Exception {
        writer.setComponent(comp);
        writer.setFile(file);
        if (width != -1 && height != -1) {
            writer.setUseCustomDimensions(true);
            writer.setCustomWidth(width);
            writer.setCustomHeight(height);
        }
        writer.toOutput();
    }
}

