/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import weka.core.Instances;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.PlotData2D;

public class LegendPanel
extends JScrollPane {
    private static final long serialVersionUID = -1262384440543001505L;
    protected ArrayList<PlotData2D> m_plots;
    protected JPanel m_span = null;
    protected ArrayList<Component> m_Repainters = new ArrayList();

    public LegendPanel() {
        this.setBackground(Color.blue);
        this.setVerticalScrollBarPolicy(22);
    }

    public void setPlotList(ArrayList<PlotData2D> pl) {
        this.m_plots = pl;
        this.updateLegends();
    }

    public void addRepaintNotify(Component c2) {
        this.m_Repainters.add(c2);
    }

    private void updateLegends() {
        if (this.m_span == null) {
            this.m_span = new JPanel();
        }
        JPanel padder = new JPanel();
        JPanel padd2 = new JPanel();
        this.m_span.setPreferredSize(new Dimension(this.m_span.getPreferredSize().width, (this.m_plots.size() + 1) * 20));
        this.m_span.setMaximumSize(new Dimension(this.m_span.getPreferredSize().width, (this.m_plots.size() + 1) * 20));
        GridBagLayout gb = new GridBagLayout();
        GridBagLayout gb2 = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_span.removeAll();
        padder.setLayout(gb);
        this.m_span.setLayout(gb2);
        constraints.anchor = 10;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        padder.add((Component)this.m_span, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 5.0;
        constraints.fill = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weighty = 5.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        padder.add((Component)padd2, constraints);
        constraints.weighty = 0.0;
        this.setViewportView(padder);
        constraints.anchor = 10;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weighty = 5.0;
        constraints.insets = new Insets(2, 4, 2, 4);
        int i = 0;
        while (i < this.m_plots.size()) {
            LegendEntry tmp = new LegendEntry(this.m_plots.get(i), i);
            constraints.gridy = i++;
            this.m_span.add((Component)tmp, constraints);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("Usage : weka.gui.visualize.LegendPanel <dataset> [dataset2], [dataset3],...");
                System.exit(1);
            }
            final JFrame jf = new JFrame("Weka Explorer: Legend");
            jf.setSize(100, 100);
            jf.getContentPane().setLayout(new BorderLayout());
            LegendPanel p2 = new LegendPanel();
            jf.getContentPane().add((Component)p2, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            ArrayList<PlotData2D> plotList = new ArrayList<PlotData2D>();
            for (int j = 0; j < args.length; ++j) {
                System.err.println("Loading instances from " + args[j]);
                BufferedReader r = new BufferedReader(new FileReader(args[j]));
                Instances i = new Instances(r);
                PlotData2D tmp = new PlotData2D(i);
                if (j != 1) {
                    tmp.m_useCustomColour = true;
                    tmp.m_customColour = Color.red;
                }
                tmp.setPlotName(i.relationName());
                plotList.add(tmp);
            }
            p2.setPlotList(plotList);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected class LegendEntry
    extends JPanel {
        private static final long serialVersionUID = 3879990289042935670L;
        private PlotData2D m_plotData = null;
        private final int m_dataIndex;
        private final JLabel m_legendText;
        private final JPanel m_pointShape;

        public LegendEntry(PlotData2D data, int dataIndex) {
            ToolTipManager.sharedInstance().setDismissDelay(5000);
            this.m_plotData = data;
            this.m_dataIndex = dataIndex;
            if (this.m_plotData.m_useCustomColour) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e2) {
                        Color tmp;
                        if ((e2.getModifiers() & 0x10) == 16 && (tmp = JColorChooser.showDialog(LegendPanel.this, "Select new Color", ((LegendEntry)LegendEntry.this).m_plotData.m_customColour)) != null) {
                            ((LegendEntry)LegendEntry.this).m_plotData.m_customColour = tmp;
                            LegendEntry.this.m_legendText.setForeground(tmp);
                            if (LegendPanel.this.m_Repainters.size() > 0) {
                                for (int i = 0; i < LegendPanel.this.m_Repainters.size(); ++i) {
                                    LegendPanel.this.m_Repainters.get(i).repaint();
                                }
                            }
                            LegendPanel.this.repaint();
                        }
                    }
                });
            }
            this.m_legendText = new JLabel(this.m_plotData.m_plotName);
            this.m_legendText.setToolTipText(this.m_plotData.getPlotNameHTML());
            if (this.m_plotData.m_useCustomColour) {
                this.m_legendText.setForeground(this.m_plotData.m_customColour);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_legendText, "Center");
            this.m_pointShape = new JPanel(){
                private static final long serialVersionUID = -7048435221580488238L;

                @Override
                public void paintComponent(Graphics gx) {
                    super.paintComponent(gx);
                    if (!((LegendEntry)LegendEntry.this).m_plotData.m_useCustomColour) {
                        gx.setColor(Color.black);
                    } else {
                        gx.setColor(((LegendEntry)LegendEntry.this).m_plotData.m_customColour);
                    }
                    Plot2D.drawDataPoint(10.0, 10.0, 3, LegendEntry.this.m_dataIndex, gx);
                }
            };
            this.m_pointShape.setPreferredSize(new Dimension(20, 20));
            this.m_pointShape.setMinimumSize(new Dimension(20, 20));
            this.add((Component)this.m_pointShape, "West");
        }
    }
}

