/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;

public class PNGWriter
extends JComponentWriter {
    protected Color m_Background;

    public PNGWriter() {
    }

    public PNGWriter(JComponent c2) {
        super(c2);
    }

    public PNGWriter(JComponent c2, File f) {
        super(c2, f);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setScalingEnabled(false);
    }

    @Override
    public String getDescription() {
        return "PNG-Image";
    }

    @Override
    public String getExtension() {
        return ".png";
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public void setBackground(Color c2) {
        this.m_Background = c2;
    }

    @Override
    public void generateOutput() throws Exception {
        BufferedImage bi = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.setPaintMode();
        g.setColor(this.getBackground());
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.getXScale(), this.getYScale());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().printAll(g);
        ImageIO.write((RenderedImage)bi, "png", this.getFile());
    }

    public static void main(String[] args) throws Exception {
        System.out.println("building TreeVisualizer...");
        TreeBuild builder = new TreeBuild();
        PlaceNode2 arrange = new PlaceNode2();
        Node top = builder.create(new StringReader("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }"));
        TreeVisualizer tv = new TreeVisualizer(null, top, (NodePlace)arrange);
        tv.setSize(800, 600);
        String filename = System.getProperty("java.io.tmpdir") + File.separator + "test.png";
        System.out.println("outputting to '" + filename + "'...");
        PNGWriter.toOutput(new PNGWriter(), tv, new File(filename));
        System.out.println("done!");
    }
}

