/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import weka.core.Environment;
import weka.core.OptionMetadata;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.FilePropertyMetadata;
import weka.knowledgeflow.BaseExecutionEnvironment;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.Flow;
import weka.knowledgeflow.FlowExecutor;
import weka.knowledgeflow.FlowLoader;
import weka.knowledgeflow.FlowRunner;
import weka.knowledgeflow.JSONFlowLoader;
import weka.knowledgeflow.JobEnvironment;
import weka.knowledgeflow.KFDefaults;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="Job", category="Flow", toolTipText="Execute a flow as a 'job' and wait for it to finish", iconPath="weka/gui/knowledgeflow/icons/Job.gif")
public class Job
extends BaseStep {
    private static final long serialVersionUID = -8684065684979500325L;
    protected File m_flowToRun = new File("--NONE--");
    protected transient FlowExecutor m_flowExecutor;
    protected LoggingLevel m_logLevel = LoggingLevel.BASIC;

    @FilePropertyMetadata(fileChooserDialogType=0, directoriesOnly=false)
    @OptionMetadata(displayName="Flow file", description="The flow to execute", displayOrder=0)
    public void setFlowFile(File flowFile) {
        this.m_flowToRun = flowFile;
    }

    public File getFlowFile() {
        return this.m_flowToRun;
    }

    @Override
    public void stepInit() throws WekaException {
        String fileName = this.m_flowToRun.toString();
        if (fileName.equals("--NONE--")) {
            throw new WekaException("No flow to execute specified!");
        }
        fileName = this.getStepManager().environmentSubstitute(fileName);
        this.m_flowExecutor = ((BaseExecutionEnvironment)this.getStepManager().getExecutionEnvironment()).getDefaultFlowExecutor();
        Settings settings = new Settings("weka", "knowledgeflow");
        try {
            settings.loadSettings();
        }
        catch (IOException ex) {
            throw new WekaException(ex);
        }
        settings.applyDefaults(new KFDefaults());
        this.m_flowExecutor.setSettings(settings);
        Environment env = new Environment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
        this.m_flowExecutor.getExecutionEnvironment().setEnvironmentVariables(env);
        Flow flowToRun = null;
        if (new File(fileName).exists()) {
            flowToRun = Flow.loadFlow(new File(fileName), this.getStepManager().getLog());
        } else {
            String fileNameWithCorrectSeparators = fileName.replace(File.separatorChar, '/');
            if (this.getClass().getClassLoader().getResource(fileNameWithCorrectSeparators) != null) {
                flowToRun = Flow.loadFlow(this.getClass().getClassLoader().getResourceAsStream(fileNameWithCorrectSeparators), (FlowLoader)new JSONFlowLoader());
            }
        }
        this.m_flowExecutor.setFlow(flowToRun);
        final String flowToRunName = flowToRun.getFlowName();
        this.m_flowExecutor.setLogger(new FlowRunner.SimpleLogger(){

            @Override
            public void logMessage(String lm) {
                if (lm.contains("[Low]")) {
                    Job.this.getStepManager().logLow(lm.replace("[Low]", "<sub-flow:" + flowToRunName + ">"));
                } else if (lm.contains("[Basic]")) {
                    Job.this.getStepManager().logBasic(lm.replace("[Basic]", "<sub-flow:" + flowToRunName + ">"));
                } else if (lm.contains("[Detailed]")) {
                    Job.this.getStepManager().logDetailed(lm.replace("[Detailed]", "<sub-flow:" + flowToRunName + ">"));
                } else if (lm.contains("[Debugging]")) {
                    Job.this.getStepManager().logDebug(lm.replace("[Debugging]", "<sub-flow:" + flowToRunName + ">"));
                } else if (lm.contains("[Warning]")) {
                    Job.this.getStepManager().logWarning(lm.replace("[Warning]", "<sub-flow:" + flowToRunName + ">"));
                } else {
                    Job.this.getStepManager().logBasic("<sub-flow>" + lm);
                }
            }
        });
    }

    @Override
    public void start() throws WekaException {
        if (this.getStepManager().numIncomingConnections() == 0) {
            this.getStepManager().logBasic("Launching as a start point");
            this.runFlow(null, null, null);
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (!this.getStepManager().isStreamFinished(data)) {
            Map varsToSet = (Map)data.getPayloadElement("env_variables");
            Map propsToSet = (Map)data.getPayloadElement("env_properties");
            Map results = (Map)data.getPayloadElement("env_results");
            if (varsToSet != null) {
                this.getStepManager().logBasic("Received variables (" + varsToSet.size() + " key-value pairs)");
            }
            if (propsToSet != null) {
                this.getStepManager().logBasic("Received properties (" + propsToSet.size() + " target steps)");
            }
            if (results != null) {
                this.getStepManager().logBasic("Received results containing " + results.size() + " connection types");
            }
            this.getStepManager().logBasic("Launching sub-flow");
            this.runFlow(varsToSet, propsToSet, results);
        }
    }

    protected void runFlow(Map<String, String> varsToSet, Map<String, Map<String, String>> propsToSet, Map<String, LinkedHashSet<Data>> results) throws WekaException {
        this.getStepManager().processing();
        JobEnvironment env = new JobEnvironment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
        this.m_flowExecutor.getExecutionEnvironment().setEnvironmentVariables(env);
        if (varsToSet != null) {
            for (Map.Entry<String, String> e2 : varsToSet.entrySet()) {
                env.addVariable(e2.getKey(), e2.getValue());
            }
        }
        if (propsToSet != null) {
            env.addToStepProperties(propsToSet);
        }
        if (results != null) {
            env.addAllResults(results);
        }
        this.getStepManager().statusMessage("Executing flow '" + this.m_flowExecutor.getFlow().getFlowName() + "'");
        try {
            JobEnvironment flowEnv;
            this.m_flowExecutor.runParallel();
            this.m_flowExecutor.waitUntilFinished();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Data success = new Data("jobSuccess", this.getName() + " completed successfully.");
            success.setPayloadElement("incremental_stream", true);
            if (varsToSet != null) {
                success.setPayloadElement("env_variables", varsToSet);
            }
            if (propsToSet != null) {
                success.setPayloadElement("env_properties", propsToSet);
            }
            if ((flowEnv = (JobEnvironment)this.m_flowExecutor.getExecutionEnvironment().getEnvironmentVariables()).getResultData() != null) {
                success.setPayloadElement("env_results", flowEnv.getResultData());
            }
            this.getStepManager().outputData(success);
        }
        catch (WekaException ex) {
            Data failure = new Data("jobFailure", LogManager.stackTraceToString(ex));
            failure.setPayloadElement("incremental_stream", true);
            if (varsToSet != null) {
                failure.setPayloadElement("env_variables", varsToSet);
            }
            if (propsToSet != null) {
                failure.setPayloadElement("env_properties", propsToSet);
            }
            this.getStepManager().outputData(failure);
        }
        this.getStepManager().finished();
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("environment", "jobSuccess", "jobFailure");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return Arrays.asList("jobSuccess", "jobFailure");
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.JobStepEditorDialog";
    }
}

