/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import weka.core.Defaults;
import weka.core.OptionMetadata;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.FilePropertyMetadata;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="TextSaver", category="DataSinks", toolTipText="Save text output to a file", iconPath="weka/gui/knowledgeflow/icons/DefaultText.gif")
public class TextSaver
extends BaseStep {
    private static final long serialVersionUID = -1434752243260858338L;
    protected File m_file = new File("");
    protected boolean m_append = true;
    protected boolean m_writeTitleString;
    protected String m_defaultFile = "";

    @OptionMetadata(displayName="File to save to", description="The file to save textual results to", displayOrder=1)
    @FilePropertyMetadata(fileChooserDialogType=0, directoriesOnly=false)
    public void setFile(File f) {
        this.m_file = f;
    }

    public File getFile() {
        return this.m_file;
    }

    @OptionMetadata(displayName="Append to file", description="Append to file, rather than re-create for each incoming texual result", displayOrder=2)
    public void setAppend(boolean append) {
        this.m_append = append;
    }

    public boolean getAppend() {
        return this.m_append;
    }

    @OptionMetadata(displayName="Write title string", description="Whether to output the title string associated with each textual result", displayOrder=3)
    public void setWriteTitleString(boolean w) {
        this.m_writeTitleString = w;
    }

    public boolean getWriteTitleString() {
        return this.m_writeTitleString;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_defaultFile = this.getFile().toString();
        if (this.m_defaultFile == null || this.m_defaultFile.length() == 0) {
            File defaultF = this.getStepManager().getSettings().getSetting("weka.knowledgeflow.steps.textsaver", TextSaverDefaults.DEFAULT_FILE_KEY, TextSaverDefaults.DEFAULT_FILE, this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
            this.m_defaultFile = defaultF.toString();
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("text");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return null;
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        String content = (String)data.getPrimaryPayload();
        String title = (String)data.getPayloadElement("aux_textTitle");
        String fileName = this.getFile().toString();
        if (fileName == null || fileName.length() == 0) {
            fileName = this.m_defaultFile;
        }
        fileName = this.environmentSubstitute(fileName);
        title = title != null && title.length() > 0 ? this.environmentSubstitute(title) : null;
        if (!new File(fileName).isDirectory()) {
            if (!fileName.toLowerCase().endsWith(".txt")) {
                fileName = fileName + ".txt";
            }
            File file = new File(fileName);
            this.getStepManager().logDetailed("Writing " + (title != null ? title : "file to " + file.toString()));
            Writer writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, this.m_append), "utf-8"));
                if (title != null && this.getWriteTitleString()) {
                    writer.write(title + "\n\n");
                }
                writer.write(content);
            }
            catch (IOException e2) {
                throw new WekaException(e2);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException e3) {
                        throw new WekaException(e3);
                    }
                }
            }
        }
        this.getStepManager().logWarning("Supplied file is a directory! Unable to write.");
        if (!this.isStopRequested()) {
            this.getStepManager().finished();
        } else {
            this.getStepManager().interrupted();
        }
    }

    @Override
    public Defaults getDefaultSettings() {
        return new TextSaverDefaults();
    }

    public static final class TextSaverDefaults
    extends Defaults {
        public static final String ID = "weka.knowledgeflow.steps.textsaver";
        public static final Settings.SettingKey DEFAULT_FILE_KEY = new Settings.SettingKey("weka.knowledgeflow.steps.textsaver.defaultFile", "Default file to save to", "Save to this file if the user has not explicitly set one in the step");
        public static final File DEFAULT_FILE = new File("${user.dir}/textout.txt");
        private static final long serialVersionUID = -2739579935119189195L;

        public TextSaverDefaults() {
            super(ID);
            this.m_defaults.put(DEFAULT_FILE_KEY, DEFAULT_FILE);
        }
    }
}

