/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.sequencesolution.impl.CharSequenceSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class CharSequenceRandomMutation
implements MutationOperator<CharSequenceSolution> {
    private double mutationProbability;
    private final char[] alphabet;

    public CharSequenceRandomMutation(double mutationProbability, char[] alphabet) {
        Check.probabilityIsValid(mutationProbability);
        this.mutationProbability = mutationProbability;
        this.alphabet = alphabet;
    }

    @Override
    public double mutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public CharSequenceSolution execute(CharSequenceSolution solution) {
        Check.notNull(solution);
        this.doMutation(solution);
        return solution;
    }

    public void doMutation(CharSequenceSolution solution) {
        int sequenceLength = solution.variables().size();
        for (int i = 0; i < sequenceLength; ++i) {
            if (!(JMetalRandom.getInstance().nextDouble() < this.mutationProbability)) continue;
            int positionToChange = JMetalRandom.getInstance().nextInt(0, sequenceLength - 1);
            char newCharValue = this.alphabet[JMetalRandom.getInstance().nextInt(0, this.alphabet.length - 1)];
            solution.variables().set(positionToChange, Character.valueOf(newCharValue));
        }
    }
}

