/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.doubleproblem.impl;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;

public abstract class AbstractDoubleProblem
implements DoubleProblem {
    protected List<Bounds<Double>> bounds;
    protected int numberOfObjectives;
    protected int numberOfConstraints;
    protected String name;

    @Override
    public int numberOfVariables() {
        return this.bounds.size();
    }

    @Override
    public int numberOfObjectives() {
        return this.numberOfObjectives;
    }

    @Override
    public int numberOfConstraints() {
        return this.numberOfConstraints;
    }

    public void numberOfObjectives(int numberOfObjectives) {
        this.numberOfObjectives = numberOfObjectives;
    }

    public void numberOfConstraints(int numberOfConstraints) {
        this.numberOfConstraints = numberOfConstraints;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public void variableBounds(List<Double> lowerBounds, List<Double> upperBounds) {
        Check.notNull(lowerBounds);
        Check.notNull(upperBounds);
        Check.that(lowerBounds.size() == upperBounds.size(), "The size of the lower bound list is not equal to the size of the upper bound list");
        this.bounds = IntStream.range(0, lowerBounds.size()).mapToObj(i -> Bounds.create((Double)lowerBounds.get(i), (Double)upperBounds.get(i))).collect(Collectors.toList());
    }

    @Override
    public DoubleSolution createSolution() {
        return new DefaultDoubleSolution(this.bounds, this.numberOfObjectives(), this.numberOfConstraints());
    }

    @Override
    public List<Bounds<Double>> variableBounds() {
        return this.bounds;
    }
}

