/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GeneralizedSpread;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.NormalizedHypervolume;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class QualityIndicatorUtils {
    private QualityIndicatorUtils() {
        throw new IllegalArgumentException();
    }

    public static List<QualityIndicator> getAvailableIndicators(double[][] referenceFront) {
        ArrayList<QualityIndicator> list = new ArrayList<QualityIndicator>();
        list.add(new Epsilon(referenceFront));
        list.add(new PISAHypervolume(referenceFront));
        list.add(new NormalizedHypervolume(referenceFront));
        list.add(new GenerationalDistance(referenceFront));
        list.add(new InvertedGenerationalDistance(referenceFront));
        list.add(new InvertedGenerationalDistancePlus(referenceFront));
        list.add(new Spread(referenceFront));
        list.add(new GeneralizedSpread(referenceFront));
        return list;
    }

    public static List<QualityIndicator> getAvailableIndicators() {
        ArrayList<QualityIndicator> list = new ArrayList<QualityIndicator>();
        list.add(new Epsilon());
        list.add(new PISAHypervolume());
        list.add(new NormalizedHypervolume());
        list.add(new GenerationalDistance());
        list.add(new InvertedGenerationalDistance());
        list.add(new InvertedGenerationalDistancePlus());
        list.add(new Spread());
        list.add(new GeneralizedSpread());
        return list;
    }

    public static QualityIndicator getIndicatorFromName(String indicatorName) {
        return QualityIndicatorUtils.getIndicatorFromName(indicatorName, QualityIndicatorUtils.getAvailableIndicators());
    }

    public static QualityIndicator getIndicatorFromName(String indicatorName, List<QualityIndicator> indicatorList) {
        QualityIndicator result = indicatorList.stream().filter(indicator -> indicator.name().equals(indicatorName)).findFirst().orElse(null);
        if (null == result) {
            throw new JMetalException("The indicator " + indicatorName + " does not exist");
        }
        return result;
    }

    public static List<QualityIndicator> getIndicatorsFromNames(List<String> indicatorNames) {
        return indicatorNames.stream().map(QualityIndicatorUtils::getIndicatorFromName).collect(Collectors.toList());
    }

    public static void printQualityIndicators(double[][] front, double[][] referenceFront) {
        double[][] normalizedReferenceFront = NormalizeUtils.normalize(referenceFront);
        double[][] normalizedFront = NormalizeUtils.normalize(front, NormalizeUtils.getMinValuesOfTheColumnsOfAMatrix(referenceFront), NormalizeUtils.getMaxValuesOfTheColumnsOfAMatrix(referenceFront));
        List<QualityIndicator> qualityIndicators = QualityIndicatorUtils.getAvailableIndicators(normalizedReferenceFront);
        for (QualityIndicator indicator : qualityIndicators) {
            JMetalLogger.logger.info(() -> indicator.name() + ": " + indicator.compute(normalizedFront));
        }
    }
}

