/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.Arrays;
import java.util.Comparator;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.comparator.LexicographicalVectorComparator;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenVectors;
import org.uma.jmetal.util.errorchecking.Check;

public class GeneralizedSpread
extends QualityIndicator {
    public GeneralizedSpread() {
    }

    public GeneralizedSpread(double[][] referenceFront) {
        super(referenceFront);
    }

    @Override
    public double compute(double[][] front) {
        Check.notNull(front);
        return this.generalizedSpread(front, this.referenceFront);
    }

    public double generalizedSpread(double[][] front, double[][] referenceFront) {
        int numberOfObjectives = front[0].length;
        double[][] extremeValues = new double[numberOfObjectives][];
        for (int i = 0; i < numberOfObjectives; ++i) {
            int finalI = i;
            Arrays.sort(referenceFront, Comparator.comparingDouble(x -> x[finalI]));
            double[] newPoint = new double[numberOfObjectives];
            for (int j = 0; j < numberOfObjectives; ++j) {
                newPoint[j] = referenceFront[referenceFront.length - 1][j];
            }
            extremeValues[i] = newPoint;
        }
        int numberOfPoints = front.length;
        Arrays.sort(front, new LexicographicalVectorComparator());
        if (new EuclideanDistanceBetweenVectors().compute(front[0], front[front.length - 1]) == 0.0) {
            return 1.0;
        }
        double dmean = 0.0;
        for (int i = 0; i < front.length; ++i) {
            dmean += VectorUtils.distanceToNearestVector(front[i], front);
        }
        dmean /= (double)numberOfPoints;
        double dExtrems = 0.0;
        for (int i = 0; i < extremeValues.length; ++i) {
            dExtrems += VectorUtils.distanceToClosestVector(extremeValues[i], front);
        }
        double mean = 0.0;
        for (int i = 0; i < front.length; ++i) {
            mean += Math.abs(VectorUtils.distanceToNearestVector(front[i], front) - dmean);
        }
        return (dExtrems + mean) / (dExtrems + (double)numberOfPoints * dmean);
    }

    @Override
    public String description() {
        return "Generalized Spread quality indicator";
    }

    @Override
    public String name() {
        return "GSPREAD";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

