/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl.hypervolume.impl;

import org.uma.jmetal.qualityindicator.impl.hypervolume.Hypervolume;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.Check;

public class PISAHypervolume
extends Hypervolume {
    public PISAHypervolume() {
    }

    public PISAHypervolume(double[] referencePoint) {
        super(referencePoint);
    }

    public PISAHypervolume(double[][] referenceFront) {
        super(referenceFront);
    }

    @Override
    public double compute(double[][] front) {
        return this.hypervolume(front, this.referenceFront);
    }

    @Override
    public String description() {
        return "PISA Hypervolume quality indicator";
    }

    private boolean dominates(double[] point1, double[] point2, int noObjectives) {
        int i;
        int betterInAnyObjective = 0;
        for (i = 0; i < noObjectives && point1[i] >= point2[i]; ++i) {
            if (!(point1[i] > point2[i])) continue;
            betterInAnyObjective = 1;
        }
        return i >= noObjectives && betterInAnyObjective > 0;
    }

    private void swap(double[][] front, int i, int j) {
        double[] temp = front[i];
        front[i] = front[j];
        front[j] = temp;
    }

    private int filterNondominatedSet(double[][] front, int noPoints, int noObjectives) {
        int n = noPoints;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (this.dominates(front[i], front[j], noObjectives)) {
                    this.swap(front, j, --n);
                    continue;
                }
                if (this.dominates(front[j], front[i], noObjectives)) {
                    this.swap(front, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    private double surfaceUnchangedTo(double[][] front, int noPoints, int objective) {
        Check.that(noPoints >= 1, "The number of points is lower than 1");
        double minValue = front[0][objective];
        for (int i = 1; i < noPoints; ++i) {
            double value = front[i][objective];
            if (!(value < minValue)) continue;
            minValue = value;
        }
        return minValue;
    }

    private int reduceNondominatedSet(double[][] front, int noPoints, int objective, double threshold) {
        int n = noPoints;
        for (int i = 0; i < n; ++i) {
            if (!(front[i][objective] <= threshold)) continue;
            this.swap(front, i, --n);
        }
        return n;
    }

    public double calculateHypervolume(double[][] front, int noPoints, int noObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        int n = noPoints;
        while (n > 0) {
            double tempVolume;
            int nonDominatedPoints = this.filterNondominatedSet(front, n, noObjectives - 1);
            if (noObjectives < 3) {
                Check.that(nonDominatedPoints >= 1, "The number of non-dominated points is lower than 1");
                tempVolume = front[0][0];
            } else {
                tempVolume = this.calculateHypervolume(front, nonDominatedPoints, noObjectives - 1);
            }
            double tempDistance = this.surfaceUnchangedTo(front, n, noObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            n = this.reduceNondominatedSet(front, n, noObjectives - 1, distance);
        }
        return volume;
    }

    private double hypervolume(double[][] front, double[][] referenceFront) {
        double[][] invertedFront = VectorUtils.getInvertedFront(front);
        int numberOfObjectives = referenceFront[0].length;
        return this.calculateHypervolume(invertedFront, invertedFront.length, numberOfObjectives);
    }

    @Override
    public String name() {
        return "HV";
    }
}

