/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.densityestimator.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.legacy.front.impl.ArrayFront;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.Hypervolume;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.impl.PISAHypervolume;

public class HypervolumeContributionDensityEstimator<S extends Solution<?>>
implements DensityEstimator<S> {
    private String attributeId = this.getClass().getName();
    private Hypervolume<S> hypervolume;

    public HypervolumeContributionDensityEstimator(List<S> referenceFront) {
        this.hypervolume = new PISAHypervolume(new ArrayFront(referenceFront));
    }

    public HypervolumeContributionDensityEstimator(double[] referencePoint) {
        this.hypervolume = new PISAHypervolume(referencePoint);
    }

    @Override
    public void compute(List<S> solutionList) {
        int size = solutionList.size();
        if (size == 0) {
            return;
        }
        this.hypervolume.computeHypervolumeContribution(solutionList);
    }

    @Override
    public Double value(S solution) {
        Check.notNull(solution);
        Double result = 0.0;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Double)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Comparator<S> comparator() {
        return Comparator.comparing(this::value);
    }
}

