/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.densityestimator.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.distance.Distance;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenVectors;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class KnnDensityEstimator<S extends Solution<?>>
implements DensityEstimator<S> {
    private final String attributeId = this.getClass().getName();
    private Distance<double[], double[]> distance = new EuclideanDistanceBetweenVectors();
    private int k;
    private double[][] distanceMatrix;
    private boolean normalize;

    public KnnDensityEstimator(int k) {
        this(k, false);
    }

    public KnnDensityEstimator(int k, boolean normalize) {
        this.k = k;
        this.normalize = normalize;
    }

    @Override
    public void compute(List<S> solutionList) {
        int i;
        int size = solutionList.size();
        Check.that(size > 0, "The solution list size must be greater than zero");
        if (size <= this.k) {
            return;
        }
        this.distanceMatrix = new double[solutionList.size()][solutionList.size()];
        double[][] solutionMatrix = null;
        if (this.normalize) {
            try {
                double[][] m = SolutionListUtils.getMatrixWithObjectiveValues(solutionList);
                solutionMatrix = NormalizeUtils.normalize(m);
            }
            catch (JMetalException e) {
                e.printStackTrace();
            }
        } else {
            solutionMatrix = SolutionListUtils.getMatrixWithObjectiveValues(solutionList);
        }
        for (i = 0; i < solutionList.size(); ++i) {
            for (int j = i + 1; j < solutionList.size(); ++j) {
                this.distanceMatrix[i][j] = this.distance.compute(solutionMatrix[i], solutionMatrix[j]);
                this.distanceMatrix[j][i] = this.distanceMatrix[i][j];
            }
        }
        for (i = 0; i < solutionList.size(); ++i) {
            ArrayList<Double> distances = new ArrayList<Double>();
            for (int j = 0; j < solutionList.size(); ++j) {
                distances.add(this.distanceMatrix[i][j]);
            }
            distances.sort(Comparator.naturalOrder());
            ((Solution)solutionList.get(i)).attributes().put(this.attributeId, distances.get(this.k));
        }
    }

    private boolean checkMatrixRowsAreEqual(double[][] matrix) {
        int numberOfColumns = matrix[0].length;
        for (int i = 1; i < numberOfColumns; ++i) {
            if (this.checkColumnValuesAreEqual(matrix, i)) continue;
            return false;
        }
        return true;
    }

    private boolean checkColumnValuesAreEqual(double[][] matrix, int column) {
        double columnValue = matrix[0][column];
        for (int i = 1; i < matrix.length; ++i) {
            if (matrix[i][column] == columnValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public Double value(S solution) {
        Check.notNull(solution);
        Double result = 0.0;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Double)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Comparator<S> comparator() {
        return Comparator.comparing(this::value);
    }
}

