/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.grouping.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.grouping.impl.ListGrouping;

public class ListOrderedGrouping<C extends Comparable<C>>
extends ListGrouping<C> {
    public ListOrderedGrouping(int numberOfGroups) {
        super(numberOfGroups);
    }

    @Override
    public void computeGroups(List<C> list) {
        Check.notNull(list);
        this.indices = new ArrayList(list.size());
        IntStream.range(0, list.size()).forEach(i -> this.indices.add(i));
        this.indices = this.indices.stream().sorted(Comparator.comparing(list::get)).collect(Collectors.toList());
        this.createGroups();
    }
}

