/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.measure.impl;

import org.uma.jmetal.util.measure.impl.SimplePullMeasure;

public class DurationMeasure
extends SimplePullMeasure<Long> {
    private long previousRoundsDuration = 0L;
    private Long roundStart = null;

    public DurationMeasure() {
        super("duration", "Provide the duration of execution of an algorithm.");
    }

    public void start() {
        if (this.roundStart == null) {
            this.roundStart = System.currentTimeMillis();
        }
    }

    public void stop() {
        if (this.roundStart != null) {
            this.previousRoundsDuration += this.getCurrentRoundDuration();
            this.roundStart = null;
        }
    }

    @Override
    public Long get() {
        return this.previousRoundsDuration + this.getCurrentRoundDuration();
    }

    private long getCurrentRoundDuration() {
        if (this.roundStart == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return now - this.roundStart;
    }

    public void reset() {
        this.previousRoundsDuration = 0L;
        if (this.roundStart != null) {
            this.roundStart = System.currentTimeMillis();
        }
    }
}

