/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.measure.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.uma.jmetal.util.measure.Measure;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.PullMeasure;
import org.uma.jmetal.util.measure.PushMeasure;

public class SimpleMeasureManager
implements MeasureManager {
    private Map<Object, PullMeasure<?>> pullers = new HashMap();
    private Map<Object, PushMeasure<?>> pushers = new HashMap();

    @Override
    public Collection<Object> getMeasureKeys() {
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(this.pullers.keySet());
        keys.addAll(this.pushers.keySet());
        return keys;
    }

    public void setPullMeasure(Object key, PullMeasure<?> measure) {
        if (measure == null) {
            this.removePullMeasure(key);
        } else {
            this.pullers.put(key, measure);
        }
    }

    @Override
    public <T> PullMeasure<T> getPullMeasure(Object key) {
        return this.pullers.get(key);
    }

    public void removePullMeasure(Object key) {
        this.pullers.remove(key);
    }

    public void setPushMeasure(Object key, PushMeasure<?> measure) {
        if (measure == null) {
            this.removePushMeasure(key);
        } else {
            this.pushers.put(key, measure);
        }
    }

    @Override
    public <T> PushMeasure<T> getPushMeasure(Object key) {
        return this.pushers.get(key);
    }

    public void removePushMeasure(Object key) {
        this.pushers.remove(key);
    }

    public void setMeasure(Object key, Measure<?> measure) {
        if (measure instanceof PullMeasure) {
            this.setPullMeasure(key, (PullMeasure)measure);
        }
        if (measure instanceof PushMeasure) {
            this.setPushMeasure(key, (PushMeasure)measure);
        }
    }

    public void removeMeasure(Object key) {
        this.removePullMeasure(key);
        this.removePushMeasure(key);
    }

    public void setAllMeasures(Map<? extends Object, ? extends Measure<?>> measures) {
        for (Map.Entry<Object, Measure<?>> entry : measures.entrySet()) {
            this.setMeasure(entry.getKey(), entry.getValue());
        }
    }

    public void removeAllMeasures(Iterable<? extends Object> keys) {
        for (Object object : keys) {
            this.removeMeasure(object);
        }
    }
}

