/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.neighborhood.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.distance.Distance;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenSolutionsInObjectiveSpace;
import org.uma.jmetal.util.neighborhood.Neighborhood;

public class KNearestNeighborhood<S extends Solution<?>>
implements Neighborhood<S> {
    private int neighborSize;
    private Distance<S, S> distance;

    public KNearestNeighborhood(int neighborSize) {
        this(neighborSize, new EuclideanDistanceBetweenSolutionsInObjectiveSpace());
    }

    public KNearestNeighborhood(int neighborSize, Distance<S, S> distance) {
        this.neighborSize = neighborSize;
        this.distance = distance;
    }

    @Override
    public List<S> getNeighbors(List<S> solutionList, int solutionIndex) {
        int i;
        ArrayList<Solution> neighbourSolutions = new ArrayList<Solution>();
        double[] distances = new double[solutionList.size()];
        int[] indexes = new int[solutionList.size()];
        for (i = 0; i < solutionList.size(); ++i) {
            distances[i] = this.distance.compute((Solution)solutionList.get(i), (Solution)solutionList.get(solutionIndex));
            indexes[i] = i;
        }
        this.minFastSort(distances, indexes, solutionList.size(), this.neighborSize);
        for (i = 1; i <= this.neighborSize; ++i) {
            neighbourSolutions.add((Solution)solutionList.get(indexes[i]));
        }
        return neighbourSolutions;
    }

    private void minFastSort(double[] x, int[] idx, int n, int m) {
        for (int i = 0; i < m; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(x[i] > x[j])) continue;
                double temp = x[i];
                x[i] = x[j];
                x[j] = temp;
                int id = idx[i];
                idx[i] = idx[j];
                idx[j] = id;
            }
        }
    }
}

