/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.util.Map;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.plot.SingleValueScatterPlot;

public class FitnessPlotObserver<S extends Solution<?>>
implements Observer<Map<String, Object>> {
    private final SingleValueScatterPlot chart;
    private Integer evaluations;
    private final int plotUpdateFrequency;
    private String valueName;
    private String plotTitle;

    public FitnessPlotObserver(String title, String xAxisTitle, String yAxisTitle, String valueName, int plotUpdateFrequency) {
        this.chart = new SingleValueScatterPlot(title, xAxisTitle, yAxisTitle, valueName);
        this.plotUpdateFrequency = plotUpdateFrequency;
        this.valueName = valueName;
        this.plotTitle = title;
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        this.evaluations = (Integer)data.get("EVALUATIONS");
        Solution solution = (Solution)data.get("BEST_SOLUTION");
        if (this.evaluations != null && solution != null) {
            if (this.evaluations % this.plotUpdateFrequency == 0) {
                this.chart.updateChart(this.evaluations.intValue(), solution.objectives()[0]);
                String plotTitle = this.plotTitle + ". Current fitness: " + String.format("%.5e", solution.objectives()[0]);
                this.chart.chartTitle(plotTitle);
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + " : insufficient for generating real time information. Either EVALUATIONS or BEST_SOLUTION keys have not been registered yet by the algorithm");
        }
    }

    public String toString() {
        return this.valueName;
    }
}

