/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.util.List;
import java.util.Map;
import org.knowm.xchart.XYChart;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.plot.SingleValueScatterPlot;
import org.uma.jmetal.util.point.impl.NadirPoint;

public class NadirObserver<S extends Solution<?>>
implements Observer<Map<String, Object>> {
    private final SingleValueScatterPlot chart;
    private Integer evaluations;
    private final int plotUpdateFrequency;
    private NadirPoint nadirPoint = null;
    private String plotTitle;

    public NadirObserver(String title, int plotUpdateFrequency, long delay) {
        this.chart = new SingleValueScatterPlot(title, "Evaluations", "Nadir", "Nadir");
        this.plotUpdateFrequency = plotUpdateFrequency;
        this.plotTitle = title;
        this.chart.delay(delay);
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        this.evaluations = (Integer)data.get("EVALUATIONS");
        List population = (List)data.get("POPULATION");
        Check.notNull(population);
        if (this.evaluations != null) {
            if (this.evaluations % this.plotUpdateFrequency == 0) {
                NonDominatedSolutionListArchive nonDominatedSolutionListArchive = new NonDominatedSolutionListArchive();
                nonDominatedSolutionListArchive.addAll(population);
                this.nadirPoint = new NadirPoint(((Solution)population.get(0)).objectives().length);
                this.nadirPoint.update(nonDominatedSolutionListArchive.solutions());
                this.chart.chartTitle(this.plotTitle + ". Evaluations: " + this.evaluations);
                this.chart.updateChart(this.nadirPoint.value(0), this.nadirPoint.value(1));
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + " : insufficient for generating real time information. Either EVALUATIONS or POPULATION keys have not been registered yet by the algorithm");
        }
    }

    public XYChart chart() {
        return this.chart.chart();
    }
}

