/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.utilities;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.uma.jmetal.solution.pointsolution.PointSolution;
import org.uma.jmetal.util.archive.impl.BestSolutionsArchive;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.point.impl.ArrayPoint;

public class ExtractSubsetOfParetoDominatedSolutionsFromFile {
    public static void main(String[] args) throws IOException {
        Check.that(args.length == 3, "Wrong number of arguments: " + args.length + "\nThis program should be called with three arguments:\nThe first argument is the name of the file containing the input solutions.\nThe second argument is the name of the file containing the computed output.\nThe third argument is the number of solutions to select from the input file");
        String inputFileName = args[0];
        String outputFileName = args[1];
        int numberOfSolutions = Integer.parseInt(args[2]);
        Stream<String> lines = Files.lines(Path.of(inputFileName, new String[0]));
        List<PointSolution> solutions = lines.filter(line -> !line.equals("")).map(line -> ExtractSubsetOfParetoDominatedSolutionsFromFile.parseLineContainingObjectives(line)).map(vector -> new PointSolution(new ArrayPoint((double[])vector).values())).collect(Collectors.toList());
        BestSolutionsArchive archive = new BestSolutionsArchive(new NonDominatedSolutionListArchive(), numberOfSolutions);
        solutions.forEach(archive::add);
        new SolutionListOutput(archive.solutions()).printObjectivesToFile(outputFileName, ",");
    }

    private static double[] parseLineContainingObjectives(String line) {
        String[] stringValues = line.split(",");
        double[] doubles = Arrays.stream(stringValues).mapToDouble(Double::parseDouble).toArray();
        return doubles;
    }
}

